/*
 * Decompiled with CFR 0.152.
 */
package wj.ap.action;

import java.awt.GraphicsEnvironment;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import wj.ap.file.editor.ITextEditor;
import wj.ap.textviewer.TextViewer;
import wj.ap.util.StatusHelper;

public class CopyOfFontNameAction {
    private IContributionItem fontNameCI = new ControlContribution("fontName"){

        protected Control createControl(Composite parent) {
            CopyOfFontNameAction.this.combo = new Combo(parent, 8);
            GraphicsEnvironment environment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            String[] names = environment.getAvailableFontFamilyNames();
            int i = 0;
            while (i < names.length) {
                char c = names[i].charAt(0);
                if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z')) {
                    CopyOfFontNameAction.this.combo.add(names[i]);
                }
                ++i;
            }
            StatusHelper statusHelper = new StatusHelper();
            String fontName = StatusHelper.getValue("fontName");
            if (fontName == null) {
                fontName = "\u5b8b\u4f53";
            }
            CopyOfFontNameAction.this.combo.setText(fontName);
            CopyOfFontNameAction.this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CopyOfFontNameAction.this.changeFontName(null);
                    StatusHelper.setValue("fontName", CopyOfFontNameAction.this.combo.getText());
                }
            });
            CopyOfFontNameAction.this.combo.setEnabled(false);
            return CopyOfFontNameAction.this.combo;
        }
    };
    private Combo combo;
    private ITextEditor textEditor;

    public void changeFontName(ITextEditor textEditor) {
        if (textEditor != null) {
            this.textEditor = textEditor;
        }
        TextViewer editor = this.textEditor.getTextViewer();
        StyledText styledText = editor.getTextWidget();
        FontData fontData = styledText.getFont().getFontData()[0];
        String fontName = this.combo.getText();
        if (!fontData.getName().equals(fontName)) {
            styledText.setFont(new Font((Device)Display.getCurrent(), fontName, fontData.getHeight(), 0));
        }
    }

    public IContributionItem getContributionItem() {
        return this.fontNameCI;
    }

    public void setEnable(boolean isEnable) {
        if (this.combo == null) {
            return;
        }
        this.combo.setEnabled(isEnable);
    }
}

