/*
 * Decompiled with CFR 0.152.
 */
package wj.ap.action;

import java.util.List;
import org.dom4j.Element;
import org.eclipse.core.resources.IFile;
import wj.ap.file.editor.TagHelper;
import wj.ap.sys.Activator;
import wj.ap.util.ModelHelper;

public class CreateNodeFileHelper {
    public static void createStoryNodeFile(Element newStoryNode) {
        ModelHelper.createFolder(newStoryNode.attributeValue("location"));
        if (!newStoryNode.getName().equals("essay")) {
            ModelHelper.copyFileFromResources("keyword.xml", newStoryNode.attributeValue("location"));
        }
    }

    public static void createFolderNodeFile(Element newFolderNode) {
        Activator.getDefault().invoke("eventExplorerAdd", newFolderNode.attributeValue("id"));
        ModelHelper.createFolder(newFolderNode.attributeValue("location"));
    }

    public static void createFileNodeFile(Element newFileNode) {
        String type = newFileNode.getName();
        type = type.substring(type.indexOf(":") + 1);
        ModelHelper.copyModelFile(type, newFileNode.attributeValue("location"), newFileNode.attributeValue("id"));
        IFile file = ModelHelper.getFileByName(newFileNode.attributeValue("location"));
        Element root = ModelHelper.getDocument(file).getRootElement();
        if (type.equals("chapter") || type.equals("note") || type.equals("theme")) {
            String time = String.valueOf(System.currentTimeMillis());
            root.attribute("createTime").setValue(time);
            root.attribute("lastModifyTime").setValue(time);
        }
        if (type.equals("role") || type.equals("scene")) {
            List<Element> tags = TagHelper.getCheckedTags(type);
            for (Element tag : tags) {
                Element roleTag = root.addElement("tns:tag");
                roleTag.addAttribute("id", tag.attributeValue("id"));
                roleTag.addAttribute("name", tag.attributeValue("name"));
            }
        }
        ModelHelper.saveDocument(root.getDocument(), file);
    }
}

