/*
 * Decompiled with CFR 0.152.
 */
package wj.ap.action;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Element;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import wj.ap.explorer.ExplorerModelHelper;
import wj.ap.explorer.ExplorerView;
import wj.ap.explorer.FileEditorInput;
import wj.ap.search.IndexService;
import wj.ap.sys.Activator;
import wj.ap.util.ModelHelper;
import wj.ap.util.StatusHelper;
import wj.ap.util.WJ;

public class DeleteAction
extends Action {
    public DeleteAction() {
        this.setText("\u5220\u9664");
    }

    public void run() {
        ExplorerView explorer = (ExplorerView)WJ.BroughtToTop(ExplorerView.class.getName());
        Element selectElement = explorer.getSelectNode();
        if (selectElement == null) {
            return;
        }
        String message = "\u60a8\u786e\u5b9a\u8981\u5220\u201c" + selectElement.attributeValue("name") + "\u201d\u5417\uff1f";
        if (!MessageDialog.openQuestion((Shell)Display.getCurrent().getActiveShell(), (String)"\u63d0\u793a", (String)message)) {
            return;
        }
        String nodeType = selectElement.getName();
        if (nodeType.equals("novel") || nodeType.equals("chapter") || nodeType.equals("note")) {
            DeleteAction.saveDeleteNodeId(selectElement.attributeValue("id"));
        }
        if (nodeType.equals("novel")) {
            DeleteAction.deleteStory(selectElement);
        } else if (nodeType.equals("teleplay")) {
            DeleteAction.deleteStory(selectElement);
        } else if (nodeType.equals("essay")) {
            DeleteAction.deleteStory(selectElement);
        } else if (nodeType.equals("outlineFolder")) {
            DeleteAction.deleteOutlineFolder(selectElement);
        } else if (nodeType.equals("chapterFolder")) {
            DeleteAction.deleteChapterFolder(selectElement);
        } else if (nodeType.equals("noteFolder") || nodeType.equals("scriptFolder")) {
            DeleteAction.deleteNoteFolder(selectElement);
        } else if (nodeType.equals("chapter")) {
            DeleteAction.deleteChapter(selectElement);
        } else if (nodeType.equals("theme") || nodeType.equals("roles") || nodeType.equals("storylines") || nodeType.equals("note") || nodeType.equals("script")) {
            DeleteAction.deleteSingleFile(selectElement);
        }
    }

    private static void saveDeleteNodeId(String nodeId) {
        String nodeIds = StatusHelper.getValue("deleteNodeId");
        if (nodeIds == null) {
            nodeIds = "";
        }
        StatusHelper.setValue("deleteNodeId", String.valueOf(nodeIds) + ";" + nodeId);
    }

    public static void deleteStory(Element storyNode) {
        DeleteAction.closeEditor(DeleteAction.getFileIdList4Story(storyNode));
        String id = storyNode.attributeValue("id");
        new IndexService().deleteIndexByStroyId(id);
        ModelHelper.deleteFolder(storyNode.attributeValue("location"));
        ExplorerModelHelper.deleteElement(id);
        Activator.getDefault().invoke("eventDeleteExplorerNode", id);
    }

    private static void closeEditor(List<String> fileIdList) {
        IEditorReference[] editors = WJ.getActivePage().getEditorReferences();
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        int i = 0;
        while (i < editors.length) {
            try {
                FileEditorInput editorInput = (FileEditorInput)editors[i].getEditorInput();
                String id = editorInput.getExplorerNode().attributeValue("id");
                if (fileIdList.contains(id)) {
                    page.closeEditor(editors[i].getEditor(false), false);
                }
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    private static List<String> getFileIdList4Story(Element storyNode) {
        ArrayList<String> fileIdList = new ArrayList<String>();
        List secondLevelList = storyNode.elements();
        for (Element secondLevel : secondLevelList) {
            if (secondLevel.attributeValue("type").equals("file")) {
                fileIdList.add(secondLevel.attributeValue("id"));
                continue;
            }
            List fileList = secondLevel.elements();
            for (Element file : fileList) {
                fileIdList.add(file.attributeValue("id"));
            }
        }
        return fileIdList;
    }

    private static void deleteOutlineFolder(Element outlineFolderNode) {
        DeleteAction.closeEditor(DeleteAction.getFileIdList4Folder(outlineFolderNode));
        DeleteAction.deleteIndexFolder(outlineFolderNode);
        DeleteAction.deleteAllKeyword(outlineFolderNode.getParent().attributeValue("id"));
        ModelHelper.deleteFolder(outlineFolderNode.attributeValue("location"));
        String id = outlineFolderNode.attributeValue("id");
        ExplorerModelHelper.deleteElement(id);
        Activator.getDefault().invoke("eventDeleteExplorerNode", id);
    }

    private static List<String> getFileIdList4Folder(Element folderNode) {
        ArrayList<String> fileIdList = new ArrayList<String>();
        List fileList = folderNode.elements();
        for (Element file : fileList) {
            fileIdList.add(file.attributeValue("id"));
        }
        return fileIdList;
    }

    private static void deleteNoteFolder(Element noteFolderNode) {
        DeleteAction.closeEditor(DeleteAction.getFileIdList4Folder(noteFolderNode));
        DeleteAction.deleteIndexFolder(noteFolderNode);
        ModelHelper.deleteFolder(noteFolderNode.attributeValue("location"));
        String id = noteFolderNode.attributeValue("id");
        ExplorerModelHelper.deleteElement(id);
        Activator.getDefault().invoke("eventDeleteExplorerNode", id);
    }

    private static void deleteChapterFolder(Element chapterFolderElement) {
        DeleteAction.closeEditor(DeleteAction.getFileIdList4Folder(chapterFolderElement));
        DeleteAction.deleteIndexFolder(chapterFolderElement);
        DeleteAction.deleteFolderKeyword(chapterFolderElement);
        ModelHelper.deleteFolder(chapterFolderElement.attributeValue("location"));
        String id = chapterFolderElement.attributeValue("id");
        ExplorerModelHelper.deleteElement(id);
        Activator.getDefault().invoke("eventDeleteExplorerNode", id);
    }

    public static void deleteChapter(Element chapterEement) {
        String id = chapterEement.attributeValue("id");
        ArrayList<String> list = new ArrayList<String>(1);
        list.add(id);
        DeleteAction.closeEditor(list);
        IndexService indexService = new IndexService();
        indexService.deleteIndexByFileId(id);
        DeleteAction.deleteChapterKeyword(chapterEement);
        DeleteAction.deleteFileNode(chapterEement);
        ExplorerModelHelper.deleteElement(id);
        Activator.getDefault().invoke("eventDeleteExplorerNode", id);
    }

    public static void deleteSingleFile(Element themeEement) {
        String id = themeEement.attributeValue("id");
        ArrayList<String> list = new ArrayList<String>(1);
        list.add(id);
        DeleteAction.closeEditor(list);
        IndexService indexService = new IndexService();
        indexService.deleteIndexByFileId(id);
        DeleteAction.deleteFileNode(themeEement);
        ExplorerModelHelper.deleteElement(id);
        Activator.getDefault().invoke("eventDeleteExplorerNode", id);
    }

    private static void deleteRole(Element roleEement) {
        String id = roleEement.attributeValue("id");
        ArrayList<String> list = new ArrayList<String>(1);
        list.add(id);
        DeleteAction.closeEditor(list);
        IndexService indexService = new IndexService();
        indexService.deleteIndexByFileId(id);
        DeleteAction.deleteFileNode(roleEement);
        DeleteAction.deleteAllKeyword(roleEement.getParent().getParent().attributeValue("id"));
        ExplorerModelHelper.deleteElement(id);
        Activator.getDefault().invoke("eventDeleteExplorerNode", id);
    }

    private static void deleteIndexFolder(Element folderElement) {
        List outlineList = folderElement.elements();
        IndexService indexService = new IndexService();
        for (Element outlineElement : outlineList) {
            if (outlineElement == null) continue;
            indexService.deleteIndexByFileId(outlineElement.attributeValue("id"));
        }
    }

    private static void deleteFolderKeyword(Element folderElement) {
        ArrayList<String> chapterIdList = new ArrayList<String>();
        List chapterList = folderElement.elements();
        for (Element chapter : chapterList) {
            if (chapter == null) continue;
            chapterIdList.add(chapter.attributeValue("id"));
        }
        String storyId = folderElement.getParent().attributeValue("id");
        IFile file = ModelHelper.getFileByName(String.valueOf(storyId) + File.separator + "keyword.xml");
        Element root = ModelHelper.getDocument(file).getRootElement();
        List children = root.elements();
        for (Element child : children) {
            if (child == null || !chapterIdList.contains(child.attributeValue("id"))) continue;
            root.remove(child);
        }
        ModelHelper.saveDocument(root.getDocument(), file);
    }

    private static void deleteAllKeyword(String StoryId) {
        IFile file = ModelHelper.getFileByName(String.valueOf(StoryId) + File.separator + "keyword.xml");
        Element root = ModelHelper.getDocument(file).getRootElement();
        List children = root.elements();
        for (Element child : children) {
            if (child == null) continue;
            root.remove(child);
        }
        ModelHelper.saveDocument(root.getDocument(), file);
    }

    private static void deleteChapterKeyword(Element chapterEement) {
        String storyId = chapterEement.getParent().getParent().attributeValue("id");
        IFile file = ModelHelper.getFileByName(String.valueOf(storyId) + File.separator + "keyword.xml");
        Element root = ModelHelper.getDocument(file).getRootElement();
        List children = root.elements();
        for (Element child : children) {
            if (child == null || !child.attributeValue("id").equals(chapterEement.attributeValue("id"))) continue;
            root.remove(child);
        }
        ModelHelper.saveDocument(root.getDocument(), file);
    }

    private static void deleteFileNode(Element fileNode) {
        ModelHelper.deleteFolder(String.valueOf(fileNode.attributeValue("location")) + "_");
        ModelHelper.deleteFile(fileNode.attributeValue("location"));
    }
}

