/*
 * Decompiled with CFR 0.152.
 */
package wj.ap.action;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import wj.ap.file.editor.ITextEditor;
import wj.ap.textviewer.TextViewer;
import wj.ap.util.StatusHelper;

public class FontNameAction
extends Action {
    private ITextEditor textEditor;
    private String fontName;
    private String[] msFontArray = new String[]{"\u5b8b\u4f53", "\u65b0\u5b8b\u4f53", "\u5fae\u8f6f\u96c5\u9ed1"};
    private String[] macFontArray = new String[]{"\u5b8b\u4f53", "\u534e\u6587\u5b8b\u4f53", "\u4e3d\u5b8b", "\u9ed1\u4f53"};
    private static String OS = System.getProperty("os.name").toLowerCase();

    public FontNameAction() {
        super("\u5b57\u4f53", 4);
        this.setToolTipText("\u70b9\u51fb\u56fe\u6807\u8bbe\u7f6e\u5b57\u4f53\u4e3a\u201c\u5b8b\u4f53\u201d");
        this.fontName = StatusHelper.getValue("fontName");
        if (this.fontName == null) {
            this.fontName = "\u5b8b\u4f53";
        }
        this.setMenuCreator(new IMenuCreator(){

            public Menu getMenu(Control parent) {
                Menu menu = new Menu(parent);
                menu.addListener(13, new Listener(){

                    public void handleEvent(Event event) {
                    }
                });
                String[] names = null;
                names = OS.startsWith("windows") ? FontNameAction.this.msFontArray : FontNameAction.this.macFontArray;
                int i = 0;
                while (i < names.length) {
                    FontNameAction.this.createItem(menu, names[i]);
                    ++i;
                }
                return menu;
            }

            public Menu getMenu(Menu parent) {
                return null;
            }

            public void dispose() {
            }
        });
    }

    private void createItem(Menu menu, final String name) {
        final MenuItem item = new MenuItem(menu, 16);
        item.setText(name);
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FontNameAction.this.fontName = name;
                item.setSelection(true);
                FontNameAction.this.changeFontName(null);
                StatusHelper.setValue("fontName", name);
            }
        });
    }

    public void changeFontName(ITextEditor textEditor) {
        TextViewer editor;
        StyledText styledText;
        FontData fontData;
        if (textEditor != null) {
            this.textEditor = textEditor;
        }
        if (!(fontData = (styledText = (editor = this.textEditor.getTextViewer()).getTextWidget()).getFont().getFontData()[0]).getName().equals(this.fontName)) {
            styledText.setFont(new Font((Device)Display.getCurrent(), this.fontName, fontData.getHeight(), 0));
        }
    }

    public void run() {
        this.fontName = "\u5b8b\u4f53";
        this.changeFontName(null);
        StatusHelper.setValue("fontName", this.fontName);
    }
}

