/*
 * Decompiled with CFR 0.152.
 */
package wj.ap.action;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import wj.ap.file.editor.ITextEditor;
import wj.ap.textviewer.TextViewer;
import wj.ap.util.StatusHelper;

public class FontSizeAction
extends Action {
    private ITextEditor textEditor;
    private int[] fontSizeArray = new int[]{11, 12, 14, 16};
    private int[] textIndentArray = new int[]{30, 33, 38, 42};
    private String[] nameArray = new String[]{"\u5c0f", "\u4e2d", "\u5927", "\u6700\u5927"};
    private int selectedIndex = 1;

    public FontSizeAction() {
        super("\u5b57\u53f7", 4);
        this.setToolTipText("\u70b9\u51fb\u56fe\u6807\u8bbe\u7f6e\u5b57\u53f7\u5927\u5c0f\u4e3a\u201c\u4e2d\u201d");
        String fontSizeIndex = StatusHelper.getValue("fontSizeIndex");
        this.selectedIndex = fontSizeIndex == null ? 1 : Integer.parseInt(fontSizeIndex);
        this.setMenuCreator(new IMenuCreator(){

            public Menu getMenu(Control parent) {
                Menu menu = new Menu(parent);
                menu.addListener(13, new Listener(){

                    public void handleEvent(Event event) {
                    }
                });
                FontSizeAction.this.createItem(menu, 0);
                FontSizeAction.this.createItem(menu, 1);
                FontSizeAction.this.createItem(menu, 2);
                FontSizeAction.this.createItem(menu, 3);
                return menu;
            }

            public Menu getMenu(Menu parent) {
                return null;
            }

            public void dispose() {
            }
        });
    }

    private void createItem(Menu menu, final int index) {
        final MenuItem item = new MenuItem(menu, 16);
        item.setText(this.nameArray[index]);
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FontSizeAction.this.selectedIndex = index;
                item.setSelection(true);
                FontSizeAction.this.changeFontSize(null);
                StatusHelper.setValue("fontSizeIndex", String.valueOf(FontSizeAction.this.selectedIndex));
            }
        });
    }

    public void run() {
        this.selectedIndex = 1;
        this.changeFontSize(null);
        StatusHelper.setValue("fontSizeIndex", String.valueOf(this.selectedIndex));
    }

    public void changeFontSize(ITextEditor textEditor) {
        if (textEditor != null) {
            this.textEditor = textEditor;
        }
        TextViewer editor = this.textEditor.getTextViewer();
        StyledText styledText = editor.getTextWidget();
        FontData fontData = styledText.getFont().getFontData()[0];
        styledText.setFont(new Font((Device)Display.getCurrent(), fontData.getName(), this.fontSizeArray[this.selectedIndex], 0));
        styledText.setIndent(this.textIndentArray[this.selectedIndex]);
    }
}

