/*
 * Decompiled with CFR 0.152.
 */
package wj.ap.action;

import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import wj.ap.file.editor.ITextEditor;
import wj.ap.search.SearchResultViewHelper;
import wj.ap.sensitive.SensitiveWordFilter;
import wj.ap.textviewer.TextViewer;
import wj.ap.util.WJ;

public class SensitiveWordCheckAction
extends Action {
    public SensitiveWordCheckAction() {
        this.setText("\u654f\u611f\u8bcd\u68c0\u67e5");
    }

    public void run() {
        IEditorPart editor = WJ.getActivePage().getActiveEditor();
        TextViewer textViewer = ((ITextEditor)editor).getTextViewer();
        final StyledText styledText = textViewer.getTextWidget();
        String text = styledText.getText();
        SensitiveWordFilter filter = new SensitiveWordFilter();
        final Set<String> set = filter.getSensitiveWord(text, 2);
        String message = "";
        Shell shell = Display.getCurrent().getActiveShell();
        if (set.isEmpty()) {
            message = "\u6ca1\u6709\u68c0\u6d4b\u5230\u4efb\u4f55\u654f\u611f\u8bcd\uff01";
            MessageDialog.openInformation((Shell)shell, (String)"\u63d0\u793a", (String)message);
        } else {
            final FindReplaceDocumentAdapter findDdapater = new FindReplaceDocumentAdapter(textViewer.getDocument());
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    for (String keyword : set) {
                        try {
                            SearchResultViewHelper.setKeywordBackgroud(findDdapater, 0, keyword, styledText);
                        }
                        catch (BadLocationException e) {
                            e.printStackTrace();
                        }
                    }
                }
            });
            message = "\u5171\u68c0\u6d4b\u5230" + set.size() + "\u4e2a\u654f\u611f\u8bcd\uff1a\n\n" + set.toString() + "\n\n\u60a8\u8981\u628a\u654f\u611f\u8bcd\u66ff\u6362\u4e3a*\u5417\uff1f";
            if (MessageDialog.openQuestion((Shell)shell, (String)"\u63d0\u793a", (String)message)) {
                for (String keyword : set) {
                    text = text.replaceAll(keyword, this.getStarts(keyword.length()));
                }
                styledText.setText(text);
            }
        }
    }

    private String getStarts(int num) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < num) {
            sb.append("*");
            ++i;
        }
        return sb.toString();
    }
}

