/*
 * Decompiled with CFR 0.152.
 */
package wj.ap.conf;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import wj.ap.conf.IConfTabItem;
import wj.ap.util.ModelHelper;

public class SensitiveWordItem
implements IConfTabItem {
    private Table table;
    private Label tipLbl;
    private Button addBtn;
    private Button delBtn;
    private List<String> fileNameSet;

    @Override
    public void createControl(TabFolder tabFolder) {
        TabItem wordCountItem = new TabItem(tabFolder, 0);
        wordCountItem.setText("\u654f\u611f\u8bcd\u8bbe\u7f6e");
        Composite comp = this.createItem(tabFolder);
        this.initValue();
        this.addListener();
        wordCountItem.setControl((Control)comp);
    }

    private Composite createItem(TabFolder tabFolder) {
        Composite parent = new Composite((Composite)tabFolder, 0);
        parent.setLayout((Layout)new GridLayout(1, false));
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(1, true));
        comp.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        this.tipLbl = new Label(comp, 0);
        this.table = new Table(comp, 65540);
        GridData gd = new GridData(4, 4, true, true);
        this.table.setLayoutData((Object)gd);
        Composite btnComp = new Composite(comp, 0);
        gd = new GridData(0x1000000, 4, true, false);
        btnComp.setLayoutData((Object)gd);
        btnComp.setLayout((Layout)new GridLayout(2, true));
        this.addBtn = new Button(btnComp, 0);
        this.addBtn.setText("\u6dfb\u52a0\u654f\u611f\u8bcd");
        this.delBtn = new Button(btnComp, 0);
        this.delBtn.setText("\u5220\u9664\u654f\u611f\u8bcd");
        return parent;
    }

    private void initValue() {
        IProject project = ModelHelper.getProject();
        IFolder folder = project.getFolder("sensitiveWord");
        this.fileNameSet = new ArrayList<String>();
        if (folder.exists()) {
            try {
                IResource[] files = folder.members();
                int i = 0;
                while (i < files.length) {
                    TableItem item = new TableItem(this.table, 0);
                    item.setText(files[i].getName());
                    this.fileNameSet.add(files[i].getName());
                    ++i;
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        if (this.table.getItemCount() == 0) {
            this.tipLbl.setText("\u5f53\u524d\u7684\u654f\u611f\u8bcd\u5e93\u6765\u81ea\u4e8e\u670d\u52a1\u5668\u3002\n\u5728\u8054\u7f51\u72b6\u6001\u4e0b\u7cfb\u7edf\u5c06\u6bcf\u5929\u83b7\u53d6\u6700\u65b0\u7684\u654f\u611f\u8bcd\u5e93\u3002\n\u60a8\u53ef\u4ee5\u901a\u8fc7\u70b9\u51fb\u201c\u6dfb\u52a0\u654f\u611f\u8bcd\u201d\u6765\u52a0\u5165\u65b0\u7684\u654f\u611f\u8bcd\u5e93\u3002");
        } else {
            this.tipLbl.setText("\u5de5\u5177\u5f53\u524d\u6709\u4ee5\u4e0b\u60a8\u6dfb\u52a0\u7684\u654f\u611f\u8bcd\u5e93\uff1a\n");
        }
    }

    private void addListener() {
        this.addBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(Display.getDefault().getActiveShell(), 4096);
                dialog.setFilterExtensions(new String[]{"*.txt"});
                String filePath = dialog.open();
                if (filePath != null) {
                    File file = new File(filePath);
                    if (SensitiveWordItem.this.fileNameSet.contains(file.getName())) {
                        if (MessageDialog.openQuestion(null, (String)"\u63d0\u793a", (String)("\u6587\u4ef6\u540d\u4e3a\u201c" + file.getName() + "\u201d\u7684\u654f\u611f\u8bcd\u5e93\u4e4b\u524d\u5df2\u6dfb\u52a0\u8fc7\uff0c\u60a8\u786e\u8ba4\u8981\u8986\u76d6\u5417\uff1f"))) {
                            SensitiveWordItem.this.addFile(file, true);
                        }
                    } else {
                        SensitiveWordItem.this.addFile(file, false);
                    }
                }
            }
        });
        this.delBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SensitiveWordItem.this.table.getSelectionCount() == 0) {
                    MessageDialog.openWarning(null, (String)"\u63d0\u793a", (String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u6587\u4ef6\u540d\u79f0\u3002");
                    return;
                }
                TableItem item = SensitiveWordItem.this.table.getSelection()[0];
                if (!MessageDialog.openConfirm(null, (String)"\u63d0\u793a", (String)("\u60a8\u786e\u5b9a\u8981\u5220\u9664\u6587\u4ef6\u201c" + item.getText() + "\u201d\u7801\uff1f"))) {
                    return;
                }
                IProject project = ModelHelper.getProject();
                IFolder folder = project.getFolder("sensitiveWord");
                IFile file = folder.getFile(item.getText());
                try {
                    file.delete(true, null);
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
                SensitiveWordItem.this.fileNameSet.remove(item.getText());
                item.dispose();
            }
        });
    }

    private void addFile(File selectFile, boolean isCover) {
        IFolder folder = ModelHelper.getProject().getFolder("sensitiveWord");
        if (!folder.exists()) {
            try {
                folder.create(true, true, null);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        IFile targetFile = folder.getFile(selectFile.getName());
        try {
            if (targetFile.exists()) {
                targetFile.setContents(selectFile.toURI().toURL().openStream(), true, true, null);
            } else {
                targetFile.create(selectFile.toURI().toURL().openStream(), true, null);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (!isCover) {
            this.fileNameSet.add(selectFile.getName());
            TableItem item = new TableItem(this.table, 0);
            item.setText(selectFile.getName());
            this.tipLbl.setText("\u5de5\u5177\u5f53\u524d\u6709\u4ee5\u4e0b\u60a8\u6dfb\u52a0\u7684\u654f\u611f\u8bcd\u5e93\uff1a\n");
        }
    }
}

