/*
 * Decompiled with CFR 0.152.
 */
package wj.ap.conf;

import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import wj.ap.conf.IConfTabItem;
import wj.ap.conf.TagCreationDialog;
import wj.ap.sys.Activator;
import wj.ap.util.ModelHelper;
import wj.ap.util.WidgterToNodeHelper;

public class TagSelectionItem
implements IConfTabItem {
    public static final String ROLE_TAG = "roleTag.xml";
    public static final String SCENE_TAG = "sceneTag.xml";
    private Table table;
    private IFile file;
    private Document document;
    private String type;
    private Button createBtn;
    private Button deleteBtn;
    private boolean isChange = false;

    public TagSelectionItem(String type) {
        this.type = type;
        this.file = ModelHelper.getFileByName(type);
        this.document = ModelHelper.getDocument(this.file);
    }

    @Override
    public void createControl(TabFolder tabFolder) {
        TabItem roleTagItem = new TabItem(tabFolder, 0);
        if (this.type.equals(ROLE_TAG)) {
            roleTagItem.setText("\u89d2\u8272\u6807\u7b7e");
        } else if (this.type.equals(SCENE_TAG)) {
            roleTagItem.setText("\u573a\u666f\u6807\u7b7e");
        }
        Composite comp = new Composite((Composite)tabFolder, 0);
        comp.setLayoutData((Object)new GridData(4, 4, true, true));
        comp.setLayout((Layout)new GridLayout(1, true));
        this.createTable(comp);
        this.createColumn();
        this.loadTags();
        this.checkTag();
        this.createButton(comp);
        this.addButtonListener();
        roleTagItem.setControl((Control)comp);
    }

    private void createButton(Composite parent) {
        Composite btnComp = new Composite(parent, 0);
        btnComp.setLayoutData((Object)new GridData(4, 4, true, false));
        btnComp.setLayout((Layout)new RowLayout());
        this.createBtn = new Button(btnComp, 0);
        this.createBtn.setText("\u521b\u5efa\u65b0\u6807\u7b7e");
        this.deleteBtn = new Button(btnComp, 0);
        this.deleteBtn.setText("\u5220\u9664\u6807\u7b7e");
    }

    private void addButtonListener() {
        this.createBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Element newTag = TagSelectionItem.this.document.getRootElement().addElement("tns:tag");
                TagCreationDialog dialog = new TagCreationDialog(null, newTag);
                if (dialog.open() == 0) {
                    ModelHelper.saveDocument(TagSelectionItem.this.document, TagSelectionItem.this.file);
                    TableItem item = new TableItem(TagSelectionItem.this.table, 0);
                    item.setData((Object)newTag);
                    item.setText(0, newTag.attributeValue("name"));
                    item.setText(1, newTag.attributeValue("description"));
                    item.setChecked(Boolean.valueOf(newTag.attributeValue("selection")).booleanValue());
                    Activator.getDefault().invoke("eventRoleTagModify", "");
                } else {
                    newTag.getParent().remove(newTag);
                }
            }
        });
        this.deleteBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TagSelectionItem.this.table.getSelection().length == 0) {
                    return;
                }
                TableItem item = TagSelectionItem.this.table.getSelection()[0];
                Element element = (Element)item.getData();
                if (MessageDialog.openConfirm(null, (String)"\u786e\u8ba4", (String)("\u60a8\u786e\u5b9a\u8981\u5220\u9664\u6807\u7b7e\u201c" + element.attributeValue("name") + "\u201d"))) {
                    element.getParent().remove(element);
                    ModelHelper.saveDocument(TagSelectionItem.this.document, TagSelectionItem.this.file);
                    item.dispose();
                    Activator.getDefault().invoke("eventRoleTagModify", "");
                }
            }
        });
    }

    private void createTable(Composite parent) {
        Composite tableComp = new Composite(parent, 0);
        tableComp.setLayoutData((Object)new GridData(4, 4, true, true));
        tableComp.setLayout((Layout)new FillLayout());
        this.table = new Table(tableComp, 67620);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        final TableEditor editor = new TableEditor(this.table);
        editor.horizontalAlignment = 16384;
        editor.grabHorizontal = true;
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent event) {
                Control old = editor.getEditor();
                if (old != null) {
                    old.dispose();
                }
                Point pt = new Point(event.x, event.y);
                final TableItem item = TagSelectionItem.this.table.getItem(pt);
                if (item == null) {
                    return;
                }
                int column = -1;
                int i = 0;
                int n = TagSelectionItem.this.table.getColumnCount();
                while (i < n) {
                    Rectangle rect = item.getBounds(i);
                    if (rect.contains(pt)) {
                        column = i;
                        break;
                    }
                    ++i;
                }
                if (column == -1) {
                    return;
                }
                final Text text = new Text((Composite)TagSelectionItem.this.table, 0);
                text.setForeground(item.getForeground());
                text.setText(item.getText(column));
                text.setForeground(item.getForeground());
                text.selectAll();
                text.setFocus();
                editor.minimumWidth = text.getBounds().width;
                editor.setEditor((Control)text, item, column);
                WidgterToNodeHelper widgterToNodeHelper = new WidgterToNodeHelper(TagSelectionItem.this.file, TagSelectionItem.this.document);
                final Element element = (Element)item.getData();
                Attribute node = element.attribute(column == 0 ? "name" : "description");
                widgterToNodeHelper.mapTextSave(text, (Node)node);
                final int col = column;
                TagSelectionItem.this.isChange = false;
                text.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent event) {
                        item.setText(col, text.getText());
                        TagSelectionItem.this.isChange = true;
                    }
                });
                text.addFocusListener(new FocusListener(){

                    public void focusLost(FocusEvent e) {
                        if (TagSelectionItem.this.isChange) {
                            if (TagSelectionItem.this.type.equals(TagSelectionItem.ROLE_TAG)) {
                                Activator.getDefault().invoke("eventRoleTagModify", element);
                            } else if (TagSelectionItem.this.type.equals(TagSelectionItem.SCENE_TAG)) {
                                Activator.getDefault().invoke("eventSceneTagModify", element);
                            }
                        }
                    }

                    public void focusGained(FocusEvent e) {
                    }
                });
            }
        });
    }

    private void checkTag() {
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.detail != 32) {
                    return;
                }
                TableItem item = (TableItem)e.item;
                Element element = (Element)item.getData();
                element.attribute("selection").setValue(String.valueOf(item.getChecked()));
                ModelHelper.saveDocument(TagSelectionItem.this.document, TagSelectionItem.this.file);
                Activator.getDefault().invoke("eventRoleTagModify", "");
            }
        });
    }

    private void loadTags() {
        Element root = this.document.getRootElement();
        List list = root.elements();
        for (Element element : list) {
            TableItem item = new TableItem(this.table, 0);
            item.setData((Object)element);
            item.setText(0, element.attributeValue("name"));
            item.setText(1, element.attributeValue("description"));
            item.setChecked(Boolean.valueOf(element.attributeValue("selection")).booleanValue());
        }
    }

    private void createColumn() {
        TableColumn nameColumn = new TableColumn(this.table, 32);
        nameColumn.setText("\u540d\u79f0");
        nameColumn.setToolTipText("");
        nameColumn.setWidth(120);
        TableColumn descriptionColumn = new TableColumn(this.table, 32);
        descriptionColumn.setText("\u63cf\u8ff0");
        descriptionColumn.setToolTipText("");
        descriptionColumn.setWidth(250);
    }
}

