/*
 * Decompiled with CFR 0.152.
 */
package wj.ap.conf;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import wj.ap.conf.IConfTabItem;
import wj.ap.util.StatusHelper;

public class WordCountItem
implements IConfTabItem {
    private Button btn;
    private Text txt;
    private StatusHelper statusHelper;
    private Button applyBtn;
    private Button resetBtn;

    @Override
    public void createControl(TabFolder tabFolder) {
        TabItem wordCountItem = new TabItem(tabFolder, 0);
        wordCountItem.setText("\u5c0f\u8bf4\u7ae0\u8282\u5b57\u6570");
        Composite comp = this.createItem(tabFolder);
        this.initValue();
        this.addListener();
        wordCountItem.setControl((Control)comp);
    }

    private Composite createItem(TabFolder tabFolder) {
        Composite parent = new Composite((Composite)tabFolder, 0);
        parent.setLayout((Layout)new GridLayout(1, false));
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        comp.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        this.btn = new Button(comp, 32);
        this.btn.setText("\u542f\u7528\u5b57\u6570\u63d0\u9192");
        GridData gd = new GridData(4, 0x1000000, true, false);
        gd.horizontalSpan = 2;
        this.btn.setLayoutData((Object)gd);
        new Label(comp, 0).setText("\u6bcf\u7ae0\u5b57\u6570\uff1a");
        this.txt = new Text(comp, 2048);
        this.txt.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.applyBtn = new Button(comp, 0);
        this.applyBtn.setText("\u5e94\u7528");
        this.resetBtn = new Button(comp, 0);
        this.resetBtn.setText("\u6062\u590d\u9ed8\u8ba4\u503c");
        return parent;
    }

    private void initValue() {
        this.statusHelper = new StatusHelper();
        String isEnable = StatusHelper.getValue("wordCountEnable");
        if (isEnable == null) {
            this.btn.setSelection(true);
        } else {
            this.btn.setSelection(Boolean.parseBoolean(isEnable));
        }
        String count = StatusHelper.getValue("wordCount");
        if (count == null) {
            this.txt.setText("3000");
        } else {
            this.txt.setText(count);
        }
        this.txt.setEnabled(this.btn.getSelection());
    }

    private void addListener() {
        this.btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WordCountItem.this.txt.setEnabled(WordCountItem.this.btn.getSelection());
            }
        });
        this.txt.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                Pattern pattern = Pattern.compile("[0-9]\\d*");
                Matcher matcher = pattern.matcher(e.text);
                e.doit = matcher.matches() ? true : e.text.length() <= 0;
            }
        });
        this.applyBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String count = WordCountItem.this.txt.getText().trim();
                if (count.equals("") || count.equals("0")) {
                    MessageDialog.openWarning(null, (String)"\u63d0\u793a", (String)"\u5b57\u6570\u4e0d\u80fd\u4e3a\u7a7a\u62160\uff01");
                    return;
                }
                StatusHelper.setValue("wordCountEnable", String.valueOf(WordCountItem.this.btn.getSelection()));
                StatusHelper.setValue("wordCount", count);
                MessageDialog.openInformation(null, (String)"\u63d0\u793a", (String)"\u8bbe\u7f6e\u6210\u529f\uff01");
            }
        });
        this.resetBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WordCountItem.this.txt.setText("3000");
                WordCountItem.this.btn.setEnabled(true);
                WordCountItem.this.btn.setSelection(true);
                StatusHelper.setValue("wordCountEnable", String.valueOf(WordCountItem.this.btn.getSelection()));
                StatusHelper.setValue("wordCount", WordCountItem.this.txt.getText());
            }
        });
    }

    static /* synthetic */ StatusHelper access$2(WordCountItem wordCountItem) {
        return wordCountItem.statusHelper;
    }
}

