/*
 * Decompiled with CFR 0.152.
 */
package wj.ap.explorer;

import java.util.Map;
import org.dom4j.Element;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import wj.ap.explorer.ExplorerHelper;
import wj.ap.explorer.ExplorerModelHelper;
import wj.ap.explorer.ExplorerView;
import wj.ap.explorer.FileEditorInput;
import wj.ap.util.WJ;

public class DragAndDrop4Explorer {
    private Tree tree;
    private Map<String, TreeItem> fileId2TreeItem;

    public DragAndDrop4Explorer(Tree tree, Map<String, TreeItem> fileId2TreeItem) {
        this.tree = tree;
        this.fileId2TreeItem = fileId2TreeItem;
        this.dnd();
    }

    private void dnd() {
        Transfer[] types = new Transfer[]{TextTransfer.getInstance()};
        int operations = 2;
        DragSource dragSource = new DragSource((Control)this.tree, operations);
        dragSource.setTransfer(types);
        dragSource.addDragListener(new DragSourceListener(){

            public void dragStart(DragSourceEvent event) {
                TreeItem[] selection = DragAndDrop4Explorer.this.tree.getSelection();
                if (selection.length <= 0 || selection[0].getItemCount() != 0) {
                    event.doit = false;
                    return;
                }
                event.doit = true;
                TreeItem selectionItem = DragAndDrop4Explorer.this.tree.getSelection()[0];
                Element selectionElement = (Element)selectionItem.getData();
                String nodeName = selectionElement.getName();
                event.doit = nodeName.equals("chapter") || nodeName.equals("note") || nodeName.equals("script");
            }

            public void dragSetData(DragSourceEvent event) {
                event.data = "wwww";
            }

            public void dragFinished(DragSourceEvent event) {
            }
        });
        DropTarget dropTarget = new DropTarget((Control)this.tree, operations);
        dropTarget.setTransfer(types);
        dropTarget.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void dragOver(DropTargetEvent event) {
                Element souce;
                if (event.item == null) {
                    return;
                }
                event.feedback = 24;
                TreeItem targetItem = (TreeItem)event.item;
                Element targetElement = (Element)targetItem.getData();
                Point pt = Display.getCurrent().map(null, (Control)DragAndDrop4Explorer.this.tree, event.x, event.y);
                Rectangle bounds = targetItem.getBounds();
                event.feedback = pt.y < bounds.y + bounds.height / 3 ? (event.feedback |= 2) : (pt.y > bounds.y + 2 * bounds.height / 3 ? (event.feedback |= 4) : (event.feedback |= 1));
                TreeItem sourceItem = DragAndDrop4Explorer.this.tree.getSelection()[0];
                Element sourceParentElement = ((Element)sourceItem.getData()).getParent();
                if ((sourceParentElement.getName().equals(targetElement.getParent().getName()) || sourceParentElement.getName().equals(targetElement.getName())) && !(souce = (Element)sourceItem.getData()).attributeValue("id").equals(targetElement.attributeValue("id"))) {
                    event.detail = 2;
                    return;
                }
                event.detail = 0;
            }

            public void drop(DropTargetEvent event) {
                TreeItem targetItem = (TreeItem)event.item;
                Element targetNode = (Element)targetItem.getData();
                TreeItem sourceItem = DragAndDrop4Explorer.this.tree.getSelection()[0];
                Element selectionParentNode = ((Element)sourceItem.getData()).getParent();
                TreeItem newItem = null;
                if (targetNode.getName().equals(selectionParentNode.getName())) {
                    newItem = new TreeItem(targetItem, 0, 0);
                } else if (targetNode.getParent().getName().equals(selectionParentNode.getName())) {
                    int index = targetItem.getParentItem().indexOf(targetItem);
                    int location = DragAndDrop4Explorer.this.determineLocation(event);
                    switch (location) {
                        case 1: {
                            --index;
                            break;
                        }
                        case 2: {
                            ++index;
                            break;
                        }
                    }
                    if (index < 0) {
                        index = 0;
                    }
                    newItem = new TreeItem(targetItem.getParentItem(), 0, index);
                }
                Element root = ExplorerModelHelper.getElement(null);
                Element currElement = (Element)sourceItem.getData();
                currElement = ExplorerModelHelper.getElementById(root, currElement.attributeValue("id"));
                Element newParentElement = (Element)newItem.getParentItem().getData();
                newParentElement = ExplorerModelHelper.getElementById(root, newParentElement.attributeValue("id"));
                ExplorerModelHelper.deleteElement(currElement.attributeValue("id"));
                ExplorerModelHelper.insertElement(newParentElement.attributeValue("id"), currElement);
                Element newElement = ExplorerModelHelper.getElement(currElement.attributeValue("id"));
                newItem.setText(sourceItem.getText());
                newItem.setData((Object)newElement);
                FileEditorInput editorInput = (FileEditorInput)sourceItem.getData("editorInput");
                IEditorPart part = WJ.getActivePage().findEditor((IEditorInput)editorInput);
                WJ.getActivePage().closeEditor(part, false);
                newItem.setData("editorInput", sourceItem.getData("editorInput"));
                DragAndDrop4Explorer.this.fileId2TreeItem.remove(newElement.attributeValue("id"));
                DragAndDrop4Explorer.this.fileId2TreeItem.put(newElement.attributeValue("id"), newItem);
                ExplorerView.setTreeItemImg(newItem, newElement);
                ExplorerHelper.getNewEditorInput(newElement, newItem);
                ExplorerModelHelper.saveSort4FileNode(newItem.getParentItem());
                sourceItem.dispose();
                super.drop(event);
            }
        });
    }

    private int determineLocation(DropTargetEvent event) {
        if (event.item != null) {
            TreeItem item = (TreeItem)event.item;
            Point pt = this.tree.getDisplay().map(null, (Control)this.tree, event.x, event.y);
            Rectangle bounds = item.getBounds();
            if (pt.y < bounds.y + bounds.height / 2) {
                return 1;
            }
            if (pt.y > bounds.y + bounds.height / 2) {
                return 2;
            }
            return 3;
        }
        return 0;
    }
}

