/*
 * Decompiled with CFR 0.152.
 */
package wj.ap.explorer;

import java.io.File;
import java.util.List;
import org.dom4j.Element;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import wj.ap.explorer.ExplorerModelHelper;

public class EnableAction {
    public boolean isHasStoryNode() {
        return ExplorerModelHelper.getAllStoryName().size() > 0;
    }

    public boolean isHasSelectNode(Tree tree) {
        return tree.getSelection().length > 0;
    }

    public boolean isLeafNode(Tree tree) {
        if (tree.getSelection().length == 0) {
            return false;
        }
        TreeItem item = tree.getSelection()[0];
        Element element = (Element)item.getData();
        return element.attributeValue("type").equals("file");
    }

    public void setEnableOutlineFile(Tree tree, IAction createThemeAction, IAction createRoleAction, IAction createStorylineAction) {
        if (tree.getSelectionCount() == 0) {
            return;
        }
        createThemeAction.setEnabled(true);
        createRoleAction.setEnabled(true);
        createStorylineAction.setEnabled(true);
        Element selectElement = (Element)tree.getSelection()[0].getData();
        String storyId = selectElement.attributeValue("location").replace(File.separator, ";").split(";")[0];
        Element root = ExplorerModelHelper.getElement(null);
        List storyList = root.elements();
        for (Element story : storyList) {
            if (!story.attributeValue("id").equals(storyId)) continue;
            List folderList = story.elements();
            for (Element folder : folderList) {
                if (!folder.getName().equals("outlineFolder")) continue;
                List fileList = folder.elements();
                for (Element file : fileList) {
                    String name = file.getName();
                    if (name.equals("theme")) {
                        createThemeAction.setEnabled(false);
                        continue;
                    }
                    if (name.equals("roles")) {
                        createRoleAction.setEnabled(false);
                        continue;
                    }
                    if (!name.equals("storylines")) continue;
                    createStorylineAction.setEnabled(false);
                }
            }
        }
    }
}

