/*
 * Decompiled with CFR 0.152.
 */
package wj.ap.explorer;

import java.util.HashSet;
import java.util.Set;
import org.dom4j.Element;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import wj.ap.util.StatusHelper;

public class ExpandHelper {
    private Tree tree;
    private Set<String> expandedNodeSet = new HashSet<String>();

    public ExpandHelper(Tree tree) {
        this.tree = tree;
    }

    public void expandedListener() {
        this.tree.addTreeListener(new TreeListener(){

            public void treeExpanded(TreeEvent e) {
                Element element = (Element)((TreeItem)e.item).getData();
                ExpandHelper.this.expandedNodeSet.add(element.attributeValue("id"));
                StringBuilder sb = new StringBuilder();
                for (String node : ExpandHelper.this.expandedNodeSet) {
                    sb.append(node).append(";");
                }
                String nodeStr = sb.substring(0, sb.length() - 1);
                StatusHelper.setValue("expanded", nodeStr);
            }

            public void treeCollapsed(TreeEvent e) {
                Element element = (Element)((TreeItem)e.item).getData();
                ExpandHelper.this.expandedNodeSet.remove(element.attributeValue("id"));
                StringBuilder sb = new StringBuilder();
                for (String node : ExpandHelper.this.expandedNodeSet) {
                    sb.append(node).append(";");
                }
                if (sb.length() != 0) {
                    String nodeStr = sb.substring(0, sb.length() - 1);
                    StatusHelper.setValue("expanded", nodeStr);
                }
            }
        });
    }

    public void restore() {
        TreeItem[] storyItems = this.tree.getItems();
        if (storyItems.length == 0) {
            return;
        }
        String expanded = StatusHelper.getValue("expanded");
        if (expanded != null) {
            String[] parts = expanded.split(";");
            int i = 0;
            while (i < parts.length) {
                this.expandedNodeSet.add(parts[i]);
                ++i;
            }
            i = 0;
            while (i < storyItems.length) {
                Element storyElement = (Element)storyItems[i].getData();
                if (this.expandedNodeSet.contains(storyElement.attributeValue("id"))) {
                    storyItems[i].setExpanded(true);
                    TreeItem[] folderItems = storyItems[i].getItems();
                    int j = 0;
                    while (j < folderItems.length) {
                        Element folderElement = (Element)folderItems[j].getData();
                        if (this.expandedNodeSet.contains(folderElement.attributeValue("id"))) {
                            folderItems[j].setExpanded(true);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
    }
}

