/*
 * Decompiled with CFR 0.152.
 */
package wj.ap.explorer;

import java.io.File;
import java.util.List;
import org.dom4j.Element;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorInput;
import wj.ap.action.ActionFactory4PopMenu;
import wj.ap.explorer.ExplorerModelHelper;
import wj.ap.explorer.ExplorerView;
import wj.ap.explorer.FileEditorInput;
import wj.ap.util.WJ;

public class ExplorerHelper {
    public static IEditorInput getNewEditorInput(Element element, TreeItem treeItem) {
        return new FileEditorInput(element, treeItem);
    }

    private static Element getLastFile(Element storyNode, String folderType) {
        List folderList = storyNode.elements(folderType);
        if (folderList == null || folderList.isEmpty()) {
            return null;
        }
        Element lastFile = null;
        for (Element chapterFolder : folderList) {
            List chapterList = chapterFolder.elements();
            for (Element chapter : chapterList) {
                if (lastFile == null) {
                    lastFile = chapter;
                    continue;
                }
                if (Long.parseLong(chapter.attributeValue("id")) <= Long.parseLong(lastFile.attributeValue("id"))) continue;
                lastFile = chapter;
            }
        }
        return lastFile;
    }

    public static void write() {
        Element story = ExplorerHelper.getCurrStoryElement();
        if (story.getName().equals("novel")) {
            Element lastChapter = ExplorerHelper.getLastFile(story, "chapterFolder");
            if (lastChapter == null) {
                ActionFactory4PopMenu.getInstance().getCreateChapterAction().run();
            } else {
                ExplorerView explorer = (ExplorerView)WJ.getActivePage().findView(ExplorerView.class.getName());
                explorer.openEditor(lastChapter.attributeValue("id"));
            }
        } else if (story.getName().equals("teleplay")) {
            Element lastScript = ExplorerHelper.getLastFile(story, "scriptFolder");
            if (lastScript == null) {
                ActionFactory4PopMenu.getInstance().getCreateTeleplayAction().run();
            } else {
                ExplorerView explorer = (ExplorerView)WJ.getActivePage().findView(ExplorerView.class.getName());
                explorer.openEditor(lastScript.attributeValue("id"));
            }
        }
    }

    public static String getOutlineFilePath(String storyId, String type) {
        List storyList = ExplorerModelHelper.getElement(null).elements();
        for (Element story : storyList) {
            if (!story.attributeValue("id").equals(storyId)) continue;
            List folderList = story.elements();
            for (Element folder : folderList) {
                if (!folder.getName().equals("outlineFolder")) continue;
                List fileList = folder.elements();
                for (Element file : fileList) {
                    if (!file.getName().equals(type)) continue;
                    return file.attributeValue("location");
                }
            }
        }
        return null;
    }

    public static Element getCurrStoryElement() {
        ExplorerView explorer = (ExplorerView)WJ.BroughtToTop(ExplorerView.class.getName());
        String location = explorer.getSelectNodePath();
        if (location == null) {
            return null;
        }
        String[] parts = location.replace(File.separator, ";").split(";");
        Element storyElement = ExplorerModelHelper.getElement(parts[0]);
        return storyElement;
    }

    public static Element getLastFolderElement(Element storyElement, String type) {
        List nodes = storyElement.selectNodes("./tns:" + type, "@id");
        if (nodes == null || nodes.isEmpty()) {
            return null;
        }
        return (Element)nodes.get(0);
    }
}

