/*
 * Decompiled with CFR 0.152.
 */
package wj.ap.explorer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.widgets.TreeItem;
import wj.ap.action.CreateNodeFileHelper;
import wj.ap.sys.Activator;
import wj.ap.util.ModelHelper;
import wj.ap.util.WJ;

public class ExplorerModelHelper {
    public static final int ADD = 1;
    public static final int DELETE = 2;
    public static final int UPDATE = 3;
    public static final int GET = 4;

    public static Element createStoryNode(String storyType, String name, String no) {
        Element story = DocumentHelper.createElement((String)("tns:" + storyType));
        if (no == null) {
            no = WJ.getNo();
        }
        story.addAttribute("id", no);
        story.addAttribute("name", name);
        story.addAttribute("location", no);
        story.addAttribute("type", "project");
        return story;
    }

    public static Element createFolderNode(String parentLocation, String folderType, String name) {
        Element folder = DocumentHelper.createElement((String)("tns:" + folderType));
        String no = WJ.getNo();
        folder.addAttribute("id", no);
        folder.addAttribute("name", name);
        folder.addAttribute("location", String.valueOf(parentLocation) + File.separator + no);
        folder.addAttribute("type", "folder");
        if (folderType.equals("outlineFolder")) {
            folder.addAttribute("no", "1");
        } else if (folderType.equals("chapterFolder") || folderType.equals("scriptFolder")) {
            folder.addAttribute("no", "2");
        } else if (folderType.equals("noteFolder")) {
            folder.addAttribute("no", "3");
        }
        return folder;
    }

    public static Element createFileNode(String parentLocation, String fileType, String name, String no) {
        Element file = DocumentHelper.createElement((String)("tns:" + fileType));
        if (no == null) {
            no = WJ.getNo();
        }
        file.addAttribute("id", no);
        file.addAttribute("name", name);
        file.addAttribute("modifyTime", String.valueOf(System.currentTimeMillis()));
        file.addAttribute("location", String.valueOf(parentLocation) + File.separator + no);
        file.addAttribute("type", "file");
        file.addAttribute("version", "0");
        file.addAttribute("isDirty", "true");
        if (fileType.equals("chapter")) {
            file.addAttribute("wordCount", "0");
        }
        if (fileType.equals("theme")) {
            file.addAttribute("no", "1");
        } else if (fileType.equals("roles")) {
            file.addAttribute("no", "2");
        } else if (fileType.equals("storylines")) {
            file.addAttribute("no", "3");
        } else {
            file.addAttribute("no", "");
        }
        return file;
    }

    public static Element createFileByButton(Element parentNode, String fileType, String name) {
        Element newFile = ExplorerModelHelper.createFileNode(parentNode.attributeValue("location"), fileType, name, null);
        CreateNodeFileHelper.createFileNodeFile(newFile);
        ExplorerModelHelper.insertElement(parentNode.attributeValue("id"), newFile);
        Activator.getDefault().invoke("eventExplorerAdd", newFile.attributeValue("id"));
        return newFile;
    }

    public static void insertElement(String parentId, Element sonElement) {
        ExplorerModelHelper.explorerCRUD(parentId, sonElement, null, null, 1);
    }

    public static void deleteElement(String id) {
        ExplorerModelHelper.explorerCRUD(id, null, null, null, 2);
    }

    public static void updateElement(String nodeId, String attributeName, String value) {
        ExplorerModelHelper.explorerCRUD(nodeId, null, attributeName, value, 3);
    }

    public static Element getElement(String nodeId) {
        return ExplorerModelHelper.explorerCRUD(nodeId, null, null, null, 4);
    }

    public static List<String> getAllStoryName() {
        ArrayList<String> nameList = new ArrayList<String>();
        List storyList = ExplorerModelHelper.getElement(null).elements();
        for (Element story : storyList) {
            nameList.add(story.attributeValue("name"));
        }
        return nameList;
    }

    public static Element getElementById(Element rootExplorerElement, String id) {
        List storyList = rootExplorerElement.elements();
        for (Element story : storyList) {
            if (story.attributeValue("id").equals(id)) {
                return story;
            }
            List secondLevelList = story.elements();
            for (Element secondLevel : secondLevelList) {
                if (secondLevel.attributeValue("id").equals(id)) {
                    return secondLevel;
                }
                if (secondLevel.attributeValue("type").equals("file")) continue;
                List fileList = secondLevel.elements();
                for (Element file : fileList) {
                    if (!file.attributeValue("id").equals(id)) continue;
                    return file;
                }
            }
        }
        return null;
    }

    public static void saveSort4FileNode(TreeItem parentItem) {
        TreeItem[] items = parentItem.getItems();
        int i = 0;
        while (i < items.length) {
            Element element = (Element)items[i].getData();
            ExplorerModelHelper.updateElement(element.attributeValue("id"), "no", String.valueOf(i + 100000));
            ++i;
        }
    }

    public static synchronized Element explorerCRUD(String parentId, Element sonElement, String attribute, String value, int actType) {
        IFile file = ExplorerModelHelper.getExplorerFile();
        Element root = ExplorerModelHelper.getExplorerRoot(file);
        if (actType == 1) {
            if (parentId == null) {
                ModelHelper.addElement(root, sonElement);
            } else {
                Element parentElement = ExplorerModelHelper.getElementById(root, parentId);
                ModelHelper.addElement(parentElement, sonElement);
            }
        } else if (actType == 2) {
            Element targetElement = ExplorerModelHelper.getElementById(root, parentId);
            targetElement.getParent().remove(targetElement);
        } else if (actType == 3) {
            Element targetElement = ExplorerModelHelper.getElementById(root, parentId);
            targetElement.attribute(attribute).setValue(value);
        } else if (actType == 4) {
            if (parentId == null) {
                return root;
            }
            Element targetElement = ExplorerModelHelper.getElementById(root, parentId);
            return targetElement;
        }
        if (actType == 1 || actType == 2 || actType == 3) {
            ExplorerModelHelper.saveExplorerModel(file, root.getDocument());
        }
        return null;
    }

    private static IFile getExplorerFile() {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("_root_");
        String fileName = "explorer.xml";
        IFile file = project.getFile(fileName);
        return file;
    }

    private static Element getExplorerRoot(IFile file) {
        Document doc = null;
        try {
            SAXReader saxReader = new SAXReader();
            InputStreamReader ir = new InputStreamReader(file.getContents(true), "UTF-8");
            doc = saxReader.read((Reader)ir);
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return doc.getRootElement();
    }

    private static void saveExplorerModel(IFile iFile, Document doc) {
        try {
            FileOutputStream os = new FileOutputStream(iFile.getRawLocationURI().getPath());
            byte[] contentByte = doc.asXML().getBytes("utf-8");
            ((OutputStream)os).write(contentByte);
            ((OutputStream)os).close();
            iFile.refreshLocal(2, null);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

