/*
 * Decompiled with CFR 0.152.
 */
package wj.ap.explorer;

import org.dom4j.Element;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import wj.ap.action.ActionFactory4PopMenu;
import wj.ap.action.OpenAction;
import wj.ap.explorer.EnableAction;

public class ExplorerPopMenu {
    private ActionFactory4PopMenu factory = ActionFactory4PopMenu.getInstance();
    private IAction createNovelAction = this.factory.getCreateNovelAction();
    private IAction createTeleplayAction = this.factory.getCreateTeleplayAction();
    private IAction createNoteAction = this.factory.getCreateNoteAction();
    private IAction createThemeAction = this.factory.getCreateThemeAction();
    private IAction createRoleAction = this.factory.getCreateRoleAction();
    private IAction createStorylineAction = this.factory.getCreateStorylineAction();
    private IAction createChapterAction = this.factory.getCreateChapterAction();
    private IAction createScriptAction = this.factory.getCreateScriptAction();
    private IAction openAction = new OpenAction();
    private IAction changeNameAction = this.factory.getChangeNameAction();
    private IAction deleteAction = this.factory.getDeleteAction();
    private IAction importAction = this.factory.getImportAction();
    private IAction exportAction = this.factory.getExportAction();

    public ExplorerPopMenu(final Tree tree) {
        MenuManager menuMgr = new MenuManager();
        Menu menu = menuMgr.createContextMenu((Control)tree);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ExplorerPopMenu.this.addPopMenu(manager, tree);
            }
        });
        menuMgr.setRemoveAllWhenShown(true);
        tree.setMenu(menu);
    }

    private void addPopMenu(IMenuManager manager, Tree tree) {
        if (tree.getSelectionCount() == 0) {
            this.forNovel(manager, tree);
        } else {
            TreeItem item = tree.getSelection()[0];
            Element element = (Element)item.getData();
            String name = element.getName();
            if (name.equals("novel")) {
                this.forNovel(manager, tree);
            } else if (name.equals("outlineFolder") || name.equals("theme") || name.equals("storylines") || name.equals("roles")) {
                this.forOutline(manager, tree);
            } else if (name.equals("chapterFolder") || name.equals("chapter")) {
                this.forChapter(manager, tree);
            } else if (name.equals("noteFolder") || name.equals("note")) {
                this.forNote(manager, tree);
            }
        }
    }

    private void forNovel(IMenuManager manager, Tree tree) {
        manager.add(this.createNovelAction);
        manager.add((IContributionItem)new Separator());
        manager.add(this.createNoteAction);
        manager.add((IContributionItem)new Separator());
        manager.add(this.createThemeAction);
        manager.add(this.createRoleAction);
        manager.add(this.createStorylineAction);
        manager.add((IContributionItem)new Separator());
        manager.add(this.createChapterAction);
        manager.add((IContributionItem)new Separator());
        manager.add(this.openAction);
        manager.add(this.changeNameAction);
        manager.add(this.deleteAction);
        manager.add((IContributionItem)new Separator());
        manager.add(this.importAction);
        manager.add(this.exportAction);
        EnableAction enableAction = new EnableAction();
        boolean isHasStoryNode = enableAction.isHasStoryNode();
        this.createNoteAction.setEnabled(isHasStoryNode);
        boolean isHasSelectNode = enableAction.isHasSelectNode(tree);
        if (isHasSelectNode) {
            enableAction.setEnableOutlineFile(tree, this.createThemeAction, this.createRoleAction, this.createStorylineAction);
        }
        boolean isLeafNode = enableAction.isLeafNode(tree);
        this.openAction.setEnabled(isHasSelectNode && isLeafNode);
        this.changeNameAction.setEnabled(isHasSelectNode);
        this.deleteAction.setEnabled(isHasSelectNode);
        this.exportAction.setEnabled(isHasStoryNode);
    }

    private void forOutline(IMenuManager manager, Tree tree) {
        manager.add(this.createThemeAction);
        manager.add(this.createRoleAction);
        manager.add(this.createStorylineAction);
        manager.add((IContributionItem)new Separator());
        manager.add(this.openAction);
        manager.add(this.changeNameAction);
        manager.add(this.deleteAction);
        manager.add((IContributionItem)new Separator());
        manager.add(this.importAction);
        manager.add(this.exportAction);
        EnableAction enableAction = new EnableAction();
        boolean isHasStoryNode = enableAction.isHasStoryNode();
        boolean isHasSelectNode = enableAction.isHasSelectNode(tree);
        if (isHasSelectNode) {
            enableAction.setEnableOutlineFile(tree, this.createThemeAction, this.createRoleAction, this.createStorylineAction);
        }
        boolean isLeafNode = enableAction.isLeafNode(tree);
        this.openAction.setEnabled(isHasSelectNode && isLeafNode);
        this.changeNameAction.setEnabled(isHasSelectNode);
        this.deleteAction.setEnabled(isHasSelectNode);
        this.exportAction.setEnabled(isHasStoryNode);
    }

    private void forChapter(IMenuManager manager, Tree tree) {
        manager.add(this.createChapterAction);
        manager.add((IContributionItem)new Separator());
        manager.add(this.openAction);
        manager.add(this.changeNameAction);
        manager.add(this.deleteAction);
        manager.add((IContributionItem)new Separator());
        manager.add(this.importAction);
        manager.add(this.exportAction);
        EnableAction enableAction = new EnableAction();
        boolean isHasStoryNode = enableAction.isHasStoryNode();
        boolean isHasSelectNode = enableAction.isHasSelectNode(tree);
        boolean isLeafNode = enableAction.isLeafNode(tree);
        this.openAction.setEnabled(isHasSelectNode && isLeafNode);
        this.changeNameAction.setEnabled(isHasSelectNode);
        this.deleteAction.setEnabled(isHasSelectNode);
        this.exportAction.setEnabled(isHasStoryNode);
    }

    private void forNote(IMenuManager manager, Tree tree) {
        manager.add(this.createNoteAction);
        manager.add((IContributionItem)new Separator());
        manager.add(this.openAction);
        manager.add(this.changeNameAction);
        manager.add(this.deleteAction);
        manager.add((IContributionItem)new Separator());
        manager.add(this.importAction);
        manager.add(this.exportAction);
        EnableAction enableAction = new EnableAction();
        boolean isHasStoryNode = enableAction.isHasStoryNode();
        boolean isHasSelectNode = enableAction.isHasSelectNode(tree);
        boolean isLeafNode = enableAction.isLeafNode(tree);
        this.openAction.setEnabled(isHasSelectNode && isLeafNode);
        this.changeNameAction.setEnabled(isHasSelectNode);
        this.deleteAction.setEnabled(isHasSelectNode);
        this.exportAction.setEnabled(isHasStoryNode);
    }
}

