/*
 * Decompiled with CFR 0.152.
 */
package wj.ap.explorer;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Element;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import wj.ap.explorer.DragAndDrop4Explorer;
import wj.ap.explorer.ExpandHelper;
import wj.ap.explorer.ExplorerHelper;
import wj.ap.explorer.ExplorerModelHelper;
import wj.ap.explorer.ExplorerPopMenu;
import wj.ap.explorer.FileEditorInput;
import wj.ap.file.editor.ITextEditor;
import wj.ap.sys.Activator;
import wj.ap.util.StatusHelper;
import wj.ap.util.TreeViewHelper;
import wj.ap.util.WJ;

public class ExplorerView
extends ViewPart
implements IPropertyChangeListener {
    private Tree tree;
    private Map<String, TreeItem> fileId2TreeItem = new HashMap<String, TreeItem>();
    private boolean systemClose = false;
    private TreeViewHelper treeViewHelper;
    private ExpandHelper expandHelper;
    private boolean isInit = true;

    public void createPartControl(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 2;
        parent.setLayout((Layout)layout);
        this.tree = new Tree(parent, 66308);
        GridData layoutData = new GridData();
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.grabExcessVerticalSpace = true;
        layoutData.horizontalAlignment = 4;
        layoutData.verticalAlignment = 4;
        this.tree.setLayoutData((Object)layoutData);
        this.load();
        this.expandHelper = new ExpandHelper(this.tree);
        this.expandHelper.restore();
        this.expandHelper.expandedListener();
        new ExplorerPopMenu(this.tree);
        this.doubleClick();
        Activator.getDefault().addPropertyChangeListener(this);
        new ExplorerPopMenu(this.tree);
        this.selectEvent();
        this.restorePage();
        this.addPartListener();
        this.addActionButton();
        new DragAndDrop4Explorer(this.tree, this.fileId2TreeItem);
    }

    private void selectEvent() {
        this.tree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Activator.getDefault().invoke("eventExplorerSelect", ExplorerView.this.tree.getSelection()[0]);
            }
        });
    }

    public void setWordCount(String fileNodeId, int wordCount) {
        TreeItem item = this.fileId2TreeItem.get(fileNodeId);
        Element element = (Element)item.getData();
        if (element.getName().equals("chapter")) {
            ExplorerModelHelper.updateElement(fileNodeId, "wordCount", String.valueOf(wordCount));
            element.attribute("wordCount").setValue(String.valueOf(wordCount));
            item.setText(String.valueOf(element.attributeValue("name")) + "\uff08" + element.attributeValue("wordCount") + "\u5b57\uff09");
        }
    }

    public String getSelectNodePath() {
        if (this.tree.getSelection().length == 0) {
            return null;
        }
        TreeItem item = this.tree.getSelection()[0];
        Element element = (Element)item.getData();
        return element.attributeValue("location");
    }

    public Element getSelectNode() {
        if (this.tree.getSelection().length == 0) {
            return null;
        }
        TreeItem item = this.tree.getSelection()[0];
        Element element = (Element)item.getData();
        return element;
    }

    public Tree getTree() {
        return this.tree;
    }

    private void load() {
        Element root = ExplorerModelHelper.getElement(null);
        this.tree.setData((Object)root);
        List storyList = root.selectNodes("./*", "@id");
        Collections.reverse(storyList);
        for (Element storyElement : storyList) {
            TreeItem storyItem = new TreeItem(this.tree, 0);
            storyItem.setText(storyElement.attributeValue("name"));
            storyItem.setData((Object)storyElement);
            ExplorerView.setTreeItemImg(storyItem, storyElement);
            this.fileId2TreeItem.put(storyElement.attributeValue("id"), storyItem);
            if (storyElement.getName().equals("novel") || storyElement.getName().equals("teleplay")) {
                List folderList = storyElement.selectNodes("./*", "@no");
                for (Element folderElement : folderList) {
                    TreeItem folderItem = new TreeItem(storyItem, 0);
                    folderItem.setText(folderElement.attributeValue("name"));
                    folderItem.setData((Object)folderElement);
                    ExplorerView.setTreeItemImg(folderItem, folderElement);
                    this.fileId2TreeItem.put(folderElement.attributeValue("id"), folderItem);
                    List fileList = folderElement.selectNodes("./*", "@no");
                    for (Element fileElement : fileList) {
                        TreeItem fileItem = new TreeItem(folderItem, 0);
                        ExplorerView.setTreeItemImg(fileItem, fileElement);
                        fileItem.setData((Object)fileElement);
                        if (fileElement.getName().equals("chapter")) {
                            fileItem.setText(String.valueOf(fileElement.attributeValue("name")) + "\uff08" + fileElement.attributeValue("wordCount") + "\u5b57\uff09");
                        } else {
                            fileItem.setText(fileElement.attributeValue("name"));
                        }
                        this.fileId2TreeItem.put(fileElement.attributeValue("id"), fileItem);
                        ExplorerHelper.getNewEditorInput(fileElement, fileItem);
                    }
                }
                continue;
            }
            if (!storyElement.getName().equals("essay")) continue;
            List fileList = storyElement.selectNodes("./*", "@no");
            for (Element fileElement : fileList) {
                TreeItem fileItem = new TreeItem(storyItem, 0);
                fileItem.setText(fileElement.attributeValue("name"));
                fileItem.setData((Object)fileElement);
                ExplorerView.setTreeItemImg(fileItem, fileElement);
                this.fileId2TreeItem.put(fileElement.attributeValue("id"), fileItem);
                ExplorerHelper.getNewEditorInput(fileElement, fileItem);
            }
        }
    }

    public void updateTree() {
        Element root = ExplorerModelHelper.getElement(null);
        this.tree.setData((Object)root);
        List storyList = root.selectNodes("./*", "@id");
        Collections.reverse(storyList);
        for (Element storyElement : storyList) {
            TreeItem fileItem;
            List fileList;
            TreeItem storyItem;
            if (this.fileId2TreeItem.containsKey(storyElement.attributeValue("id"))) {
                storyItem = this.fileId2TreeItem.get(storyElement.attributeValue("id"));
                storyItem.setData((Object)storyElement);
                Element stroyElementInItem = (Element)storyItem.getData();
                if (!stroyElementInItem.attributeValue("name").equals(storyElement.attributeValue("name"))) {
                    storyItem.setText(storyElement.attributeValue("name"));
                    storyItem.setData((Object)storyElement);
                }
                List folderList = storyElement.selectNodes("./*", "@no");
                for (Element folderElement : folderList) {
                    TreeItem fileItem2;
                    fileList = folderElement.selectNodes("./*", "@no");
                    if (this.fileId2TreeItem.containsKey(folderElement.attributeValue("id"))) {
                        this.fileId2TreeItem.get(folderElement.attributeValue("id")).setData((Object)folderElement);
                        for (Element fileElement : fileList) {
                            if (this.fileId2TreeItem.containsKey(fileElement.attributeValue("id"))) {
                                fileItem = this.fileId2TreeItem.get(fileElement.attributeValue("id"));
                                fileItem.setData((Object)fileElement);
                                Element fileElementItem = (Element)fileItem.getData();
                                if (Integer.parseInt(fileElementItem.attributeValue("version")) >= Integer.parseInt(fileElement.attributeValue("version"))) continue;
                                if (fileElement.getName().equals("chapter")) {
                                    fileItem.setText(String.valueOf(fileElement.attributeValue("name")) + "\uff08" + fileElement.attributeValue("wordCount") + "\u5b57\uff09");
                                } else {
                                    fileItem.setText(fileElement.attributeValue("name"));
                                }
                                fileItem.setData((Object)fileElement);
                                WJ.reload(fileElement.attributeValue("id"));
                                continue;
                            }
                            TreeItem folderItem = this.fileId2TreeItem.get(folderElement.attributeValue("id"));
                            fileItem2 = new TreeItem(folderItem, 0);
                            fileItem2.setText(String.valueOf(fileElement.attributeValue("name")) + "\uff08" + fileElement.attributeValue("wordCount") + "\u5b57\uff09");
                            fileItem2.setData((Object)fileElement);
                            this.fileId2TreeItem.put(fileElement.attributeValue("id"), fileItem2);
                        }
                        continue;
                    }
                    TreeItem folderItem = new TreeItem(storyItem, 0);
                    folderItem.setData((Object)folderElement);
                    folderItem.setText(folderElement.attributeValue("name"));
                    this.fileId2TreeItem.put(folderElement.attributeValue("id"), folderItem);
                    for (Element fileElement : fileList) {
                        fileItem2 = new TreeItem(folderItem, 0);
                        fileItem2.setData((Object)fileElement);
                        this.fileId2TreeItem.put(fileElement.attributeValue("id"), fileItem2);
                        String fileName = fileElement.getName();
                        if (fileName.equals("chapter")) {
                            fileItem2.setText(String.valueOf(fileElement.attributeValue("name")) + "\uff08" + fileElement.attributeValue("wordCount") + "\u5b57\uff09");
                            continue;
                        }
                        fileItem2.setText(fileElement.attributeValue("name"));
                    }
                }
                continue;
            }
            storyItem = new TreeItem(this.tree, 0);
            storyItem.setText(storyElement.attributeValue("name"));
            storyItem.setData((Object)storyElement);
            ExplorerView.setTreeItemImg(storyItem, storyElement);
            this.fileId2TreeItem.put(storyElement.attributeValue("id"), storyItem);
            List folderList = storyElement.selectNodes("./*", "@no");
            for (Element folderElement : folderList) {
                TreeItem folderItem = new TreeItem(storyItem, 0);
                folderItem.setText(folderElement.attributeValue("name"));
                folderItem.setData((Object)folderElement);
                ExplorerView.setTreeItemImg(folderItem, folderElement);
                this.fileId2TreeItem.put(folderElement.attributeValue("id"), folderItem);
                fileList = folderElement.selectNodes("./*", "@no");
                for (Element fileElement : fileList) {
                    fileItem = new TreeItem(folderItem, 0);
                    ExplorerView.setTreeItemImg(fileItem, fileElement);
                    fileItem.setData((Object)fileElement);
                    if (fileElement.getName().equals("chapter")) {
                        fileItem.setText(String.valueOf(fileElement.attributeValue("name")) + "\uff08" + fileElement.attributeValue("wordCount") + "\u5b57\uff09");
                    } else {
                        fileItem.setText(fileElement.attributeValue("name"));
                    }
                    this.fileId2TreeItem.put(fileElement.attributeValue("id"), fileItem);
                    ExplorerHelper.getNewEditorInput(fileElement, fileItem);
                }
            }
        }
    }

    public static void setTreeItemImg(TreeItem item, Element node) {
        ImageDescriptor imgDes = Activator.getImageDescriptor("icons/" + node.getName() + "16.png");
        if (imgDes != null) {
            item.setImage(imgDes.createImage());
        }
    }

    public void setFocus() {
    }

    public void dispose() {
        Activator.getDefault().removePropertyChangeListener(this);
    }

    public void propertyChange(PropertyChangeEvent event) {
        String source = event.getProperty();
        if (source.equals("eventDeleteExplorerNode")) {
            String nodeId = (String)event.getNewValue();
            TreeItem treeItem = this.fileId2TreeItem.get(nodeId);
            Element element = (Element)treeItem.getData();
            element.getParent().remove(element);
            treeItem.dispose();
            this.fileId2TreeItem.remove(nodeId);
        } else if (source.equals("eventExplorerAdd")) {
            String nodeName;
            String nodeId = (String)event.getNewValue();
            Element newNode = ExplorerModelHelper.getElement(nodeId);
            TreeItem item = null;
            TreeItem parentItem = this.fileId2TreeItem.get(newNode.getParent().attributeValue("id"));
            if (newNode.attributeValue("type").equals("project")) {
                item = new TreeItem(this.tree, 0, 0);
            } else if (newNode.attributeValue("type").equals("folder")) {
                if (newNode.getName().equals("outlineFolder")) {
                    item = new TreeItem(parentItem, 0, 0);
                } else if (newNode.getName().equals("chapterFolder") || newNode.getName().equals("scriptFolder")) {
                    item = newNode.getParent().selectNodes("./tns:outlineFolder").isEmpty() ? new TreeItem(parentItem, 0, 0) : new TreeItem(parentItem, 0, 1);
                } else if (newNode.getName().equals("noteFolder")) {
                    item = new TreeItem(parentItem, 0);
                }
            } else {
                item = newNode.getName().equals("theme") ? new TreeItem(parentItem, 0, 0) : (newNode.getName().equals("roles") ? (newNode.getParent().selectNodes("./tns:theme").isEmpty() ? new TreeItem(parentItem, 0, 0) : new TreeItem(parentItem, 0, 1)) : (newNode.getName().equals("storylines") ? new TreeItem(parentItem, 0) : new TreeItem(parentItem, 0, 0)));
                ExplorerHelper.getNewEditorInput(newNode, item);
            }
            if (newNode.getName().equals("chapter")) {
                item.setText(String.valueOf(newNode.attributeValue("name")) + "\uff08" + newNode.attributeValue("wordCount") + "\u5b57\uff09");
            } else {
                item.setText(newNode.attributeValue("name"));
            }
            item.setData((Object)newNode);
            ExplorerView.setTreeItemImg(item, newNode);
            if (newNode.attributeValue("type").equals("file") && ((nodeName = newNode.getName()).equals("note") || nodeName.equals("chapter") || nodeName.equals("script"))) {
                ExplorerModelHelper.saveSort4FileNode(item.getParentItem());
            }
            this.expanded(item);
            this.fileId2TreeItem.put(newNode.attributeValue("id"), item);
        } else if (source.equals("eventExplorerChange")) {
            Element currElement = (Element)event.getNewValue();
            TreeItem treeItem = this.fileId2TreeItem.get(currElement.attributeValue("id"));
            if (currElement.getName().equals("chapter")) {
                treeItem.setText(String.valueOf(currElement.attributeValue("name")) + "\uff08" + currElement.attributeValue("wordCount") + "\u5b57\uff09");
            } else {
                treeItem.setText(currElement.attributeValue("name"));
            }
        } else if (source.equals("eventSystemClose")) {
            this.systemClose = true;
        }
    }

    private void expanded(TreeItem item) {
        item.setExpanded(true);
        if (item.getParentItem() != null) {
            TreeItem parent = item.getParentItem();
            parent.setExpanded(true);
            if (parent.getParentItem() != null) {
                parent = item.getParentItem();
                parent.setExpanded(true);
            }
        }
    }

    private boolean expanded(TreeItem[] items, Element element) {
        int i = 0;
        while (i < items.length) {
            if (items[i].getItemCount() == 0) {
                if (items[i].getData().equals(element)) {
                    this.tree.select(items[i]);
                    return true;
                }
            } else if (this.expanded(items[i].getItems(), element)) {
                items[i].setExpanded(true);
            }
            ++i;
        }
        return false;
    }

    public Element getFileElement(String fileId) {
        if (this.tree.isDisposed()) {
            return null;
        }
        List storyList = ((Element)this.tree.getData()).elements();
        for (Element story : storyList) {
            List secondLevelList = story.elements();
            for (Element secondLevel : secondLevelList) {
                if (secondLevel.attributeValue("id").equals(fileId)) {
                    return secondLevel;
                }
                List fileList = secondLevel.elements();
                for (Element file : fileList) {
                    if (!file.attributeValue("id").equals(fileId)) continue;
                    return file;
                }
            }
        }
        return null;
    }

    private void doubleClick() {
        this.tree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                TreeItem item = ExplorerView.this.tree.getSelection()[0];
                Element node = (Element)item.getData();
                if (node.attributeValue("type").equals("file")) {
                    ExplorerView.this.openEditor(item);
                } else {
                    item.setExpanded(!item.getExpanded());
                }
            }
        });
    }

    private void openEditor(TreeItem item) {
        IEditorPart editorPart;
        Element element = (Element)item.getData();
        IWorkbenchPage workbenchPage = WJ.getActivePage();
        IEditorInput editorInput = (IEditorInput)item.getData("editorInput");
        if (editorInput == null) {
            editorInput = ExplorerHelper.getNewEditorInput(element, item);
        }
        if ((editorPart = workbenchPage.findEditor(editorInput)) != null) {
            workbenchPage.bringToTop((IWorkbenchPart)editorPart);
        } else {
            try {
                editorPart = workbenchPage.openEditor(editorInput, WJ.getEditorId(element.getName()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void openEditor(String fileId) {
        TreeItem[] storyItems = this.tree.getItems();
        int i = 0;
        while (i < storyItems.length) {
            TreeItem[] secondLevelItems = storyItems[i].getItems();
            int j = 0;
            while (j < secondLevelItems.length) {
                Element element = (Element)secondLevelItems[j].getData();
                if (element.attributeValue("id").equals(fileId)) {
                    this.openEditor(secondLevelItems[j]);
                    return;
                }
                TreeItem[] fileItems = secondLevelItems[j].getItems();
                int k = 0;
                while (k < fileItems.length) {
                    element = (Element)fileItems[k].getData();
                    if (element.attributeValue("id").equals(fileId)) {
                        this.openEditor(fileItems[k]);
                        return;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    private void restorePage() {
        if (StatusHelper.getValue("editorSet") == null) {
            return;
        }
        String[] parts = StatusHelper.getValue("editorSet").split(";");
        int i = 0;
        while (i < parts.length) {
            this.openEditor(parts[i]);
            ++i;
        }
        if (StatusHelper.getValue("topEditor") != null) {
            this.openEditor(StatusHelper.getValue("topEditor"));
        }
    }

    private void addPartListener() {
        WJ.getActivePage().addPartListener(new IPartListener2(){

            public void partVisible(IWorkbenchPartReference partRef) {
            }

            public void partOpened(IWorkbenchPartReference partRef) {
                ExplorerView.this.saveAllEditor(partRef.getPart(false));
            }

            public void partInputChanged(IWorkbenchPartReference partRef) {
            }

            public void partHidden(IWorkbenchPartReference partRef) {
            }

            public void partDeactivated(IWorkbenchPartReference partRef) {
            }

            public void partClosed(IWorkbenchPartReference partRef) {
                ExplorerView.this.saveAllEditor(partRef.getPart(false));
            }

            public void partBroughtToTop(IWorkbenchPartReference partRef) {
                ExplorerView.this.saveTopEditor(partRef.getPart(false));
                ExplorerView.this.selectTreeItem(partRef.getPart(false));
            }

            public void partActivated(IWorkbenchPartReference partRef) {
                if (ExplorerView.this.isInit) {
                    ExplorerView.this.selectTreeItem(partRef.getPart(false));
                    ExplorerView.this.isInit = false;
                }
            }
        });
    }

    private void saveAllEditor(IWorkbenchPart part) {
        if (part instanceof ITextEditor && !this.systemClose) {
            IEditorReference[] efs = WJ.getActivePage().getEditorReferences();
            StringBuilder sb = new StringBuilder("");
            int i = 0;
            while (i < efs.length) {
                try {
                    if (efs[i].getEditorInput() instanceof FileEditorInput) {
                        FileEditorInput input = (FileEditorInput)efs[i].getEditorInput();
                        sb.append(input.getExplorerNode().attributeValue("id")).append(";");
                    }
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
                ++i;
            }
            if (!sb.toString().equals("")) {
                StatusHelper.setValue("editorSet", sb.substring(0, sb.length() - 1));
            } else {
                StatusHelper.setValue("editorSet", "");
                StatusHelper.setValue("topEditor", "");
            }
        }
    }

    private void saveTopEditor(IWorkbenchPart part) {
        if (part instanceof ITextEditor && !this.systemClose) {
            FileEditorInput input = (FileEditorInput)((IEditorPart)part).getEditorInput();
            String id = input.getExplorerNode().attributeValue("id");
            StatusHelper.setValue("topEditor", id);
        }
    }

    private void selectTreeItem(IWorkbenchPart part) {
        if (part instanceof ITextEditor) {
            FileEditorInput editorInput = (FileEditorInput)((IEditorPart)part).getEditorInput();
            final Element element = editorInput.getExplorerNode();
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!ExplorerView.this.tree.isDisposed()) {
                        ExplorerView.this.expanded(ExplorerView.this.tree.getItems(), element);
                    }
                }
            });
        }
    }

    private void addActionButton() {
        this.treeViewHelper = new TreeViewHelper(this.tree);
        IToolBarManager tbm = this.getViewSite().getActionBars().getToolBarManager();
        tbm.add(this.treeViewHelper.getCollapseAction());
    }
}

