/*
 * Decompiled with CFR 0.152.
 */
package wj.ap.file.editor;

import java.io.File;
import java.util.Map;
import java.util.Set;
import org.dom4j.Document;
import org.dom4j.Element;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.IME;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.MultiPageEditorPart;
import wj.ap.explorer.ExplorerModelHelper;
import wj.ap.explorer.ExplorerView;
import wj.ap.explorer.FileEditorInput;
import wj.ap.file.editor.ITextEditor;
import wj.ap.history.IHistory;
import wj.ap.sys.Activator;
import wj.ap.textviewer.KeywordsHelper;
import wj.ap.textviewer.TextViewer;
import wj.ap.util.ModelHelper;
import wj.ap.util.StatusLineItem4WordCount;
import wj.ap.util.WJ;

public class ChapterEditor
extends MultiPageEditorPart
implements IPropertyChangeListener,
ITextEditor,
IHistory {
    private TextViewer viewer;
    private IFile modelFile;
    private Document document;
    private Element description;
    private KeywordsHelper keywordsHelper;
    private StatusLineItem4WordCount statusLine;
    private Map<String, Integer> previousKeywordCountMap;
    private Browser browser = null;
    private boolean isChange = false;
    String preWord = "";

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.modelFile = (IFile)input.getAdapter(this.getClass());
        this.document = ModelHelper.getDocument(this.modelFile);
        this.description = this.document.getRootElement().element("description");
        this.setPartName(input.getName());
        Activator.getDefault().addPropertyChangeListener(this);
    }

    protected void createPages() {
        this.createWritePage();
        this.createPreviewPage();
    }

    private void createWritePage() {
        Composite composite = new Composite(this.getContainer(), 0);
        composite.setLayout((Layout)new FillLayout());
        String path = this.document.getRootElement().attributeValue("location");
        String storyId = path.replace(File.separator, ";").split(";")[0];
        this.keywordsHelper = KeywordsHelper.getKeywordsHelper(storyId);
        this.viewer = new TextViewer(composite, this.document, this.keywordsHelper);
        this.viewer.getDocument().set(this.description.getText());
        int index = this.addPage((Control)composite);
        this.setPageText(index, "\u6b63\u6587");
        this.listnerDocumentChange();
    }

    private void listnerDocumentChange() {
        this.viewer.getDocument().addDocumentListener(new IDocumentListener(){

            public void documentChanged(DocumentEvent event) {
                boolean isOver = false;
                IME ime = ChapterEditor.this.viewer.getTextWidget().getIME();
                if (ime.getCommitCount() != 0 && ime.getCommitCount() == ime.getText().length()) {
                    isOver = true;
                } else if (ime.getCommitCount() == 0 && ime.getText().length() == 0) {
                    isOver = true;
                }
                if (isOver) {
                    if (ChapterEditor.this.viewer.getTextWidget().getText().length() > 30000) {
                        MessageDialog.openWarning(null, (String)"\u63d0\u793a", (String)"\u5f53\u524d\u5b57\u7b26\u6570\u8d85\u8fc7\u4e86\u7cfb\u7edf\u8bbe\u7f6e\u7684\u6700\u5927\u503c30000\u4e2a\uff0c\u4e0d\u80fd\u88ab\u4fdd\u5b58\u548c\u540c\u6b65\uff01");
                        return;
                    }
                    ChapterEditor.this.description.setText(ChapterEditor.this.viewer.getTextWidget().getText());
                    ChapterEditor.this.wordCount();
                    ModelHelper.saveDocument(ChapterEditor.this.document, ChapterEditor.this.modelFile);
                    ChapterEditor.this.countKeyword();
                    ChapterEditor.this.isChange = true;
                    ChapterEditor.this.setDirty();
                }
            }

            public void documentAboutToBeChanged(DocumentEvent event) {
            }
        });
    }

    private void setDirty() {
        ExplorerModelHelper.updateElement(this.document.getRootElement().attributeValue("id"), "isDirty", "true");
    }

    private void countKeyword() {
        boolean isEqual;
        Map<String, Integer> currKeywordCountmap;
        block6: {
            block5: {
                currKeywordCountmap = this.keywordsHelper.countAllRole(this.viewer.getTextWidget().getText());
                isEqual = true;
                if (this.previousKeywordCountMap != null && !this.previousKeywordCountMap.isEmpty()) break block5;
                this.previousKeywordCountMap = currKeywordCountmap;
                if (this.previousKeywordCountMap.isEmpty()) break block6;
                isEqual = false;
                break block6;
            }
            if (currKeywordCountmap.size() != this.previousKeywordCountMap.size()) {
                isEqual = false;
            } else {
                Set<String> keywordSet = currKeywordCountmap.keySet();
                for (String keyword : keywordSet) {
                    if (this.previousKeywordCountMap.containsKey(keyword)) {
                        if (this.previousKeywordCountMap.get(keyword) == currKeywordCountmap.get(keyword)) continue;
                        isEqual = false;
                        break;
                    }
                    isEqual = false;
                    break;
                }
            }
        }
        if (!isEqual) {
            this.keywordsHelper.saveKeywordCount(this.modelFile.getName(), currKeywordCountmap);
        }
    }

    private void wordCount() {
        int wordCount = ModelHelper.getWordCount(this.description.getText());
        ExplorerView view = (ExplorerView)WJ.getActivePage().findView(ExplorerView.class.getName());
        if (view != null) {
            String id = this.document.getRootElement().attributeValue("id");
            view.setWordCount(id, wordCount);
        }
        this.statusLine.setCurrWordCount(wordCount);
    }

    private void initWordCount() {
        int wordCount = ModelHelper.getWordCount(this.description.getText());
        this.statusLine.setCurrWordCount(wordCount);
    }

    private void createPreviewPage() {
        Composite composite = new Composite(this.getContainer(), 0);
        FillLayout layout = new FillLayout();
        composite.setLayout((Layout)layout);
        this.browser = new Browser(composite, 0);
        int index = this.addPage((Control)composite);
        this.setPageText(index, "\u9884\u89c8");
    }

    private String getHtml() {
        StringBuffer sb = new StringBuffer();
        sb.append("<html>");
        sb.append("<head>");
        sb.append("<style type=\"text/css\">");
        sb.append("p{ text-indent: 2em;}");
        sb.append("</style>");
        sb.append("</head>");
        sb.append("<body>");
        String text = this.description.getText();
        String[] parts = text.split("\n");
        int i = 0;
        while (i < parts.length) {
            int index;
            String part = parts[i].trim();
            if (!(part.equals("") || (index = part.indexOf("//")) > -1 && (part = part.substring(0, index)).trim().equals(""))) {
                sb.append("<p>");
                sb.append(part);
                sb.append("</p>");
            }
            ++i;
        }
        sb.append("</body>");
        sb.append("</html>");
        return sb.toString();
    }

    protected void pageChange(int newPageIndex) {
        super.pageChange(newPageIndex);
        if (newPageIndex != 0) {
            this.browser.setText(this.getHtml());
        }
    }

    public void dispose() {
        FileEditorInput input = (FileEditorInput)this.getEditorInput();
        input.removeTreeItem();
        Activator.getDefault().removePropertyChangeListener(this);
        if (this.isChange) {
            if (this.statusLine.getRatio() >= 100.0f) {
                MessageDialog.openInformation(null, (String)"\u606d\u559c", (String)"\u606d\u559c\u4f60\u51fa\u8272\u7684\u5b8c\u6210\u4e86\u4efb\u52a1\uff0c\u7ec4\u7ec7\u5f88\u6b23\u6170\uff01");
            } else {
                MessageDialog.openInformation(null, (String)"\u63d0\u793a", (String)"\u8fd8\u5dee\u70b9\u6ca1\u6709\u5b8c\u6210\uff0c\u8981\u52aa\u529b\u54df\uff01");
            }
        }
    }

    public void setFocus() {
        this.viewer.getTextWidget().setFocus();
        this.statusLine = new StatusLineItem4WordCount((IEditorPart)this);
        String createTime = this.document.getRootElement().attributeValue("createTime");
        this.statusLine.setCreateTime(createTime);
        this.initWordCount();
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("eventExplorerChange")) {
            this.setPartName(this.getEditorInput().getName());
        }
    }

    @Override
    public void reload() {
        boolean oldChangeFlag = this.isChange;
        this.document = ModelHelper.getDocument(this.modelFile);
        this.description = this.document.getRootElement().element("description");
        this.viewer.getDocument().set(this.description.getText());
        this.viewer.reLoadTopIndex();
        if (!oldChangeFlag) {
            this.isChange = false;
        }
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    @Override
    public TextViewer getTextViewer() {
        return this.viewer;
    }

    @Override
    public IFile getModelFile4History() {
        return this.modelFile;
    }
}

