/*
 * Decompiled with CFR 0.152.
 */
package wj.ap.file.editor;

import org.dom4j.Document;
import org.dom4j.Element;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.IME;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import wj.ap.explorer.ExplorerModelHelper;
import wj.ap.explorer.FileEditorInput;
import wj.ap.file.editor.ITextEditor;
import wj.ap.history.IHistory;
import wj.ap.sys.Activator;
import wj.ap.textviewer.TextViewer;
import wj.ap.util.ModelHelper;

public class NoteEditor
extends EditorPart
implements ITextEditor,
IPropertyChangeListener,
IHistory {
    private TextViewer viewer;
    private IFile modelFile;
    private Document document;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.modelFile = (IFile)input.getAdapter(this.getClass());
        this.document = ModelHelper.getDocument(this.modelFile);
        this.setPartName(input.getName());
        Activator.getDefault().addPropertyChangeListener(this);
    }

    public void createPartControl(Composite composite) {
        Composite parent = new Composite(composite, 0);
        parent.setLayout((Layout)new GridLayout(1, true));
        Composite contentComposite = new Composite(parent, 0);
        contentComposite.setLayoutData((Object)new GridData(1808));
        contentComposite.setLayout((Layout)new FillLayout());
        this.viewer = new TextViewer(contentComposite, this.document);
        this.viewer.getDocument().set(this.document.getRootElement().elementText("description"));
        this.listnerDocumentChange();
    }

    private void listnerDocumentChange() {
        this.viewer.addTextListener(new ITextListener(){

            public void textChanged(TextEvent event) {
                boolean isOver = false;
                IME ime = NoteEditor.this.viewer.getTextWidget().getIME();
                if (ime.getCommitCount() != 0 && ime.getCommitCount() == ime.getText().length()) {
                    isOver = true;
                } else if (ime.getCommitCount() == 0 && ime.getText().length() == 0) {
                    isOver = true;
                }
                if (isOver) {
                    if (NoteEditor.this.viewer.getTextWidget().getText().length() > 30000) {
                        MessageDialog.openWarning(null, (String)"\u63d0\u793a", (String)"\u5f53\u524d\u5b57\u7b26\u6570\u8d85\u8fc7\u4e86\u7cfb\u7edf\u8bbe\u7f6e\u7684\u6700\u5927\u503c30000\u4e2a\uff0c\u4e0d\u80fd\u88ab\u4fdd\u5b58\u548c\u540c\u6b65\uff01");
                        return;
                    }
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            Element content = NoteEditor.this.document.getRootElement().element("description");
                            content.setText(NoteEditor.this.viewer.getTextWidget().getText());
                            ModelHelper.saveDocument(NoteEditor.this.document, NoteEditor.this.modelFile);
                        }
                    });
                }
                NoteEditor.this.setDirty();
            }
        });
    }

    private void setDirty() {
        ExplorerModelHelper.updateElement(this.document.getRootElement().attributeValue("id"), "isDirty", "true");
    }

    public void setFocus() {
        this.viewer.getTextWidget().setFocus();
    }

    public void dispose() {
        FileEditorInput input = (FileEditorInput)this.getEditorInput();
        input.removeTreeItem();
        Activator.getDefault().removePropertyChangeListener(this);
    }

    @Override
    public TextViewer getTextViewer() {
        return this.viewer;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("eventExplorerChange")) {
            this.setPartName(this.getEditorInput().getName());
        }
    }

    @Override
    public void reload() {
        this.document = ModelHelper.getDocument(this.modelFile);
        this.viewer.getDocument().set(ModelHelper.getContent(this.document));
        this.viewer.reLoadTopIndex();
    }

    @Override
    public IFile getModelFile4History() {
        return this.modelFile;
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }
}

