/*
 * Decompiled with CFR 0.152.
 */
package wj.ap.file.editor;

import java.io.File;
import java.util.List;
import java.util.Set;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.IME;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import wj.ap.explorer.ExplorerHelper;
import wj.ap.explorer.ExplorerModelHelper;
import wj.ap.explorer.ExplorerView;
import wj.ap.explorer.FileEditorInput;
import wj.ap.file.editor.ITextEditor;
import wj.ap.file.editor.MultiFileHandlerHelper;
import wj.ap.file.editor.TagHelper;
import wj.ap.file.view.RoleManagerView;
import wj.ap.history.IHistory;
import wj.ap.sys.Activator;
import wj.ap.textviewer.KeywordsHelper;
import wj.ap.textviewer.TextViewer;
import wj.ap.util.ModelHelper;
import wj.ap.util.StatusHelper;
import wj.ap.util.WJ;
import wj.ap.util.WidgterToNode4TagHelper;

public class RoleEditor
extends EditorPart
implements IPropertyChangeListener,
ITextEditor,
IHistory {
    private IFile rolesModelFile;
    private IFile roleModelFile;
    private Document rolesModelDocument;
    private Document roleModelDocument;
    private Element currRoleInMom;
    private WidgterToNode4TagHelper widgterToNodeHelper;
    private KeywordsHelper keywordsHelper;
    private Composite tagLocationComposite;
    private Composite tagComp;
    private TextViewer viewer;
    private Button createBtn;
    private Button deleteBtn;
    private Button nextBtn;
    private Button writeBtn;
    private Button viewBtn;
    private RoleManagerView roleManagerView;
    private ModifyListener modifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            RoleEditor.this.keywordsHelper.refreshKeywords();
        }
    };

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.rolesModelFile = (IFile)input.getAdapter(this.getClass());
        this.rolesModelDocument = ModelHelper.getDocument(this.rolesModelFile);
        String storyId = this.rolesModelDocument.getRootElement().attributeValue("location").replace(File.separator, ";").split(";")[0];
        this.keywordsHelper = KeywordsHelper.getKeywordsHelper(storyId);
        this.setPartName(input.getName());
        Activator.getDefault().addPropertyChangeListener(this);
        this.setInitEditElement();
    }

    public void createPartControl(Composite composite) {
        this.createControl(composite);
        this.addListener();
        this.updateControlValue();
    }

    private void addListener() {
        this.viewer.addTextListener(new ITextListener(){

            public void textChanged(TextEvent event) {
                boolean isOver = false;
                IME ime = RoleEditor.this.viewer.getTextWidget().getIME();
                if (ime.getCommitCount() != 0 && ime.getCommitCount() == ime.getText().length()) {
                    isOver = true;
                } else if (ime.getCommitCount() == 0 && ime.getText().length() == 0) {
                    isOver = true;
                }
                if (isOver) {
                    RoleEditor.this.roleModelDocument.getRootElement().element("description").setText(RoleEditor.this.viewer.getTextWidget().getText());
                    ModelHelper.saveDocument(RoleEditor.this.roleModelDocument, RoleEditor.this.roleModelFile);
                    RoleEditor.this.keywordsHelper.refreshKeywords();
                }
            }
        });
        this.createBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Element root;
                String name;
                if (RoleEditor.this.roleModelDocument != null && (name = (root = RoleEditor.this.roleModelDocument.getRootElement()).elementText("name")).trim().equals("")) {
                    MessageDialog.openWarning(null, (String)"\u63d0\u793a", (String)"\u5f53\u524d\u89d2\u8272\u8fd8\u6ca1\u6709\u8f93\u5165\u540d\u79f0\uff0c\u8bf7\u8f93\u5165\u5f53\u524d\u89d2\u8272\u540d\u79f0\u540e\u518d\u521b\u5efa\u3002");
                    return;
                }
                RoleEditor.this.createRole();
            }
        });
        this.deleteBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String message = "\u60a8\u786e\u5b9a\u8981\u5220\u9664\u5f53\u524d\u89d2\u8272\u5417\uff1f";
                if (MessageDialog.openQuestion(null, (String)"\u63d0\u793a", (String)message)) {
                    MultiFileHandlerHelper.deleteElementInMutiFile(RoleEditor.this.currRoleInMom);
                    RoleEditor.this.disable(RoleEditor.this.currRoleInMom.attributeValue("id"));
                    if (RoleEditor.this.roleManagerView != null) {
                        RoleEditor.this.roleManagerView.update(RoleEditor.this.rolesModelDocument);
                    }
                    WJ.refreshKeywordsInEditor(RoleEditor.this.keywordsHelper);
                }
            }
        });
        this.viewBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WJ.BroughtToTop(RoleManagerView.class.getName());
            }
        });
        this.nextBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Element roleNode = ExplorerModelHelper.getElement(RoleEditor.this.rolesModelDocument.getRootElement().attributeValue("id"));
                List outlineList = roleNode.getParent().elements();
                Element storylinesNode = null;
                for (Element outline : outlineList) {
                    if (!outline.getName().equals("storylines")) continue;
                    storylinesNode = outline;
                    break;
                }
                if (storylinesNode == null) {
                    storylinesNode = ExplorerModelHelper.createFileByButton(roleNode.getParent(), "storylines", "\u60c5\u8282");
                }
                ExplorerView explorer = (ExplorerView)WJ.getActivePage().findView(ExplorerView.class.getName());
                explorer.openEditor(storylinesNode.attributeValue("id"));
            }
        });
        this.writeBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExplorerHelper.write();
            }
        });
    }

    private void createRole() {
        this.setCurrRoleByCreate();
        this.updateControlValue();
    }

    private void setCurrRoleByCreate() {
        this.currRoleInMom = MultiFileHandlerHelper.createNewElementInMutiFile(this.rolesModelDocument.getRootElement(), "role");
        this.roleModelFile = ModelHelper.getFileByName(this.currRoleInMom.attributeValue("location"));
        this.roleModelDocument = ModelHelper.getDocument(this.roleModelFile);
        StatusHelper.setValue(this.rolesModelFile, "roleId", this.currRoleInMom.attributeValue("id"));
        if (this.roleManagerView != null) {
            this.roleManagerView.update(this.rolesModelDocument);
        }
        Activator.getDefault().invoke("eventRoleCreate", this.currRoleInMom);
        this.setEnable(true);
    }

    private void createTag() {
        if (this.tagComp != null && !this.tagComp.isDisposed()) {
            this.tagComp.dispose();
            this.tagComp = null;
        }
        this.tagComp = new Composite(this.tagLocationComposite, 0);
        this.tagComp.setLayout((Layout)new GridLayout(8, false));
        this.widgterToNodeHelper = new WidgterToNode4TagHelper(this.roleModelFile, this.roleModelDocument, "eventRoleModify");
        Element role = this.roleModelDocument.getRootElement();
        GridData lblGd = new GridData(4, 0x1000000, true, false);
        GridData txtGd = new GridData(4, 4, true, false);
        Label lbl = new Label(this.tagComp, 131072);
        lbl.setText("\u540d\u79f0\uff1a");
        lbl.setLayoutData((Object)lblGd);
        lbl.setToolTipText("\u89d2\u8272\u540d\u79f0\uff0c\u5728\u4e66\u4e2d\u552f\u4e00");
        Text txt = new Text(this.tagComp, 2048);
        txt.setLayoutData((Object)txtGd);
        txt.setToolTipText("\u540d\u79f0");
        txt.addModifyListener(this.modifyListener);
        this.validName(txt);
        this.widgterToNodeHelper.mapTextSave(txt, (Node)role.element("name"));
        List<Element> tagList = TagHelper.getCheckedTags("role");
        for (Element tag : tagList) {
            Element roleTag = TagHelper.getTagById(role, tag.attributeValue("id"));
            if (roleTag == null) {
                roleTag = TagHelper.createTag(role, tag);
            }
            lbl = new Label(this.tagComp, 131072);
            lbl.setText(String.valueOf(tag.attributeValue("name")) + "\uff1a");
            lbl.setLayoutData((Object)lblGd);
            lbl.setToolTipText(tag.attributeValue("description"));
            txt = new Text(this.tagComp, 2048);
            txt.setLayoutData((Object)txtGd);
            txt.setToolTipText(tag.attributeValue("name"));
            txt.addModifyListener(this.modifyListener);
            this.widgterToNodeHelper.mapTextSave(txt, (Node)roleTag);
        }
        this.tagLocationComposite.layout();
        this.tagLocationComposite.getParent().layout();
    }

    private void validName(final Text text) {
        final List<String> names = this.keywordsHelper.getKeywordInStory();
        names.remove(this.roleModelDocument.getRootElement().elementText("name"));
        text.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                if (names.contains(text.getText())) {
                    MessageDialog.openWarning(null, (String)"\u63d0\u793a", (String)("\u89d2\u8272\u540d\u79f0\u201c" + text.getText() + "\u201d\u5df2\u7ecf\u5b58\u5728\uff01"));
                    text.setFocus();
                    return;
                }
                RoleEditor.this.keywordsHelper.refreshKeywords();
                RoleEditor.this.keywordsHelper.countAllChapterRole();
                RoleManagerView view = (RoleManagerView)WJ.getActivePage().findView(RoleManagerView.class.getName());
                if (view != null) {
                    RoleEditor.this.keywordsHelper.refreshKeywords();
                    view.update(RoleEditor.this.rolesModelDocument);
                }
                WJ.refreshKeywordsInEditor(RoleEditor.this.keywordsHelper);
            }

            public void focusGained(FocusEvent e) {
            }
        });
    }

    private void updateControlValue() {
        this.createTag();
        this.viewer.getTextWidget().setEnabled(true);
        this.viewer.getDocument().set(this.roleModelDocument.getRootElement().element("description").getText());
        this.viewer.updateModel(this.roleModelDocument, this.roleModelFile);
        if (this.roleManagerView != null) {
            this.roleManagerView.selectRow(this.currRoleInMom.attributeValue("id"));
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        String eventName = event.getProperty();
        if (eventName.equals("eventRoleSelectByName")) {
            String name = (String)event.getNewValue();
            List roleList = this.rolesModelDocument.getRootElement().elements("role");
            for (Element roleInMom : roleList) {
                Document roleDoc = ModelHelper.getDocument(roleInMom.attributeValue("location"));
                if (!roleDoc.getRootElement().elementText("name").equals(name)) continue;
                this.changeRole(roleInMom.attributeValue("id"), false);
            }
        } else if (eventName.equals("eventRoleTagModify")) {
            this.roleModelDocument = ModelHelper.getDocument(this.roleModelFile);
            this.updateControlValue();
        } else if (event.getProperty().equals("eventExplorerChange")) {
            this.setPartName(this.getEditorInput().getName());
        }
    }

    @Override
    public void reload() {
        this.roleModelDocument = ModelHelper.getDocument(this.roleModelFile);
        this.updateControlValue();
        this.viewer.reLoadTopIndex();
    }

    public void disable(String roleId) {
        if (this.currRoleInMom.attributeValue("id").equals(roleId)) {
            this.setEnable(false);
            this.currRoleInMom = null;
            this.roleModelDocument = null;
            this.roleModelFile = null;
        }
    }

    private void setEnable(boolean isEnable) {
        if (this.widgterToNodeHelper == null) {
            return;
        }
        Set<Control> controls = this.widgterToNodeHelper.getWidgetNodeMap().keySet();
        for (Control control : controls) {
            control.setEnabled(isEnable);
        }
        this.viewer.getTextWidget().setEnabled(isEnable);
        this.deleteBtn.setEnabled(isEnable);
    }

    public void setFocus() {
        this.viewer.getTextWidget().setFocus();
        RoleManagerView view = (RoleManagerView)WJ.getActivePage().findView(RoleManagerView.class.getName());
        if (view != null) {
            view.registerEditor(this);
        }
    }

    public void dispose() {
        StatusHelper.setValue(this.rolesModelFile, "roleId", this.currRoleInMom.attributeValue("id"));
        FileEditorInput input = (FileEditorInput)this.getEditorInput();
        input.removeTreeItem();
        Activator.getDefault().removePropertyChangeListener(this);
        if (this.roleManagerView != null) {
            this.roleManagerView.unregisterEditor(this);
        }
    }

    @Override
    public TextViewer getTextViewer() {
        return this.viewer;
    }

    @Override
    public IFile getModelFile4History() {
        return this.roleModelFile;
    }

    public void changeRole(String roleId, boolean isLoad) {
        if (isLoad) {
            this.rolesModelDocument = ModelHelper.getDocument(this.rolesModelFile);
        }
        this.setCurrRole(roleId);
        this.updateControlValue();
        StatusHelper.setValue(this.rolesModelFile, "roleId", this.currRoleInMom.attributeValue("id"));
    }

    public Element getCurrRoleInMom() {
        return this.currRoleInMom;
    }

    public IFile getRolesModelFile() {
        return this.rolesModelFile;
    }

    public void registerView(RoleManagerView view) {
        this.roleManagerView = view;
    }

    public void unregisterView() {
        this.roleManagerView = null;
    }

    private void setInitEditElement() {
        List roleList = this.rolesModelDocument.getRootElement().elements("role");
        if (roleList == null || roleList.isEmpty()) {
            this.setCurrRoleByCreate();
        } else {
            String roleId = StatusHelper.getValue(this.rolesModelFile, "roleId");
            this.setCurrRole(roleId);
        }
    }

    private void setCurrRole(String roleId) {
        this.currRoleInMom = ModelHelper.getElement(this.rolesModelDocument.getRootElement().elements("role"), roleId);
        if (this.currRoleInMom == null) {
            this.rolesModelDocument = ModelHelper.getDocument(this.rolesModelFile);
            this.currRoleInMom = ModelHelper.getElement(this.rolesModelDocument.getRootElement().elements("role"), roleId);
            if (this.currRoleInMom == null) {
                this.currRoleInMom = (Element)this.rolesModelDocument.getRootElement().elements("role").get(0);
                StatusHelper.setValue(this.rolesModelFile, "roleId", this.currRoleInMom.attributeValue("id"));
            }
        }
        this.roleModelFile = ModelHelper.getFileByName(this.currRoleInMom.attributeValue("location"));
        this.roleModelDocument = ModelHelper.getDocument(this.roleModelFile);
        this.setEnable(true);
    }

    private void createControl(Composite composite) {
        Composite parent = new Composite(composite, 0);
        parent.setLayout((Layout)new GridLayout(1, true));
        Label topCenterLabel = new Label(parent, 0);
        topCenterLabel.setText("\u89d2\u8272\u8bbe\u5b9a");
        topCenterLabel.setAlignment(0x1000000);
        topCenterLabel.setLayoutData((Object)new GridData(0x1000000, 128, true, false));
        this.tagLocationComposite = new Composite(parent, 0);
        this.tagLocationComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        this.tagLocationComposite.setLayout((Layout)new FillLayout());
        Composite contentComposite = new Composite(parent, 0);
        contentComposite.setLayoutData((Object)new GridData(1808));
        contentComposite.setLayout((Layout)new FillLayout());
        this.viewer = new TextViewer(contentComposite, this.roleModelDocument);
        Composite buttonComposite = new Composite(parent, 0);
        buttonComposite.setLayoutData((Object)new GridData(0x1000000, 4, true, false));
        buttonComposite.setLayout((Layout)new GridLayout(5, true));
        GridData gd = new GridData(0x1000000, 4, true, false);
        this.createBtn = new Button(buttonComposite, 0);
        this.createBtn.setText("\u521b\u5efa");
        this.createBtn.setLayoutData((Object)gd);
        this.deleteBtn = new Button(buttonComposite, 0);
        this.deleteBtn.setText("\u5220\u9664");
        this.deleteBtn.setLayoutData((Object)gd);
        this.viewBtn = new Button(buttonComposite, 0);
        this.viewBtn.setText("\u6d4f\u89c8");
        this.viewBtn.setLayoutData((Object)gd);
        this.nextBtn = new Button(buttonComposite, 0);
        this.nextBtn.setText("\u4e0b\u4e00\u6b65");
        this.nextBtn.setLayoutData((Object)gd);
        this.writeBtn = new Button(buttonComposite, 0);
        this.writeBtn.setText("\u76f4\u63a5\u5199\u4f5c");
        this.writeBtn.setLayoutData((Object)gd);
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }
}

