/*
 * Decompiled with CFR 0.152.
 */
package wj.ap.file.editor;

import java.util.List;
import java.util.Set;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.IME;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import wj.ap.explorer.FileEditorInput;
import wj.ap.file.editor.ITextEditor;
import wj.ap.file.editor.MultiFileHandlerHelper;
import wj.ap.file.editor.TagHelper;
import wj.ap.file.view.SceneManagerView;
import wj.ap.history.IHistory;
import wj.ap.sys.Activator;
import wj.ap.textviewer.TextViewer;
import wj.ap.util.ModelHelper;
import wj.ap.util.StatusHelper;
import wj.ap.util.WJ;
import wj.ap.util.WidgterToNode4TagHelper;

public class ScriptEditor
extends EditorPart
implements IPropertyChangeListener,
ITextEditor,
IHistory {
    private IFile scriptModelFile;
    private Document scriptModelDocument;
    private Element currSceneInMom;
    private IFile sceneModelFile;
    private Document sceneModelDocument;
    private WidgterToNode4TagHelper widgterToNodeHelper;
    private Composite tagComp;
    private TextViewer viewer;
    private Composite tagLocationComposite;
    private Button createBtn;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.scriptModelFile = (IFile)input.getAdapter(this.getClass());
        this.scriptModelDocument = ModelHelper.getDocument(this.scriptModelFile);
        this.setPartName(input.getName());
        Activator.getDefault().addPropertyChangeListener(this);
        this.setInitEditElement();
    }

    public void createPartControl(Composite composite) {
        this.createControl(composite);
        this.addListener();
        this.updateControlValue();
    }

    private void addListener() {
        this.viewer.addTextListener(new ITextListener(){

            public void textChanged(TextEvent event) {
                boolean isOver = false;
                IME ime = ScriptEditor.this.viewer.getTextWidget().getIME();
                if (ime.getCommitCount() != 0 && ime.getCommitCount() == ime.getText().length()) {
                    isOver = true;
                } else if (ime.getCommitCount() == 0 && ime.getText().length() == 0) {
                    isOver = true;
                }
                if (isOver) {
                    ScriptEditor.this.sceneModelDocument.getRootElement().element("description").setText(ScriptEditor.this.viewer.getTextWidget().getText());
                    ModelHelper.saveDocument(ScriptEditor.this.sceneModelDocument, ScriptEditor.this.sceneModelFile);
                }
            }
        });
        this.createBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Element root = ScriptEditor.this.sceneModelDocument.getRootElement();
                String name = root.elementText("name");
                if (name.trim().equals("")) {
                    MessageDialog.openWarning(null, (String)"\u63d0\u793a", (String)"\u5f53\u524d\u573a\u666f\u8fd8\u6ca1\u6709\u8f93\u5165\u540d\u79f0\uff0c\u8bf7\u8f93\u5165\u5f53\u524d\u573a\u666f\u540d\u79f0\u540e\u518d\u521b\u5efa\u3002");
                    return;
                }
                ScriptEditor.this.createScene();
            }
        });
    }

    private void createScene() {
        this.setEnable(true);
        this.setCurrSceneByCreate();
        this.updateControlValue();
    }

    private void updateControlValue() {
        this.createTag();
        this.viewer.getTextWidget().setEnabled(true);
        this.viewer.getDocument().set(this.sceneModelDocument.getRootElement().attributeValue("description"));
        this.viewer.updateModel(this.sceneModelDocument, this.sceneModelFile);
        SceneManagerView sceneView = (SceneManagerView)WJ.getActivePage().findView(SceneManagerView.class.getName());
        if (sceneView != null) {
            sceneView.selectRow(this.currSceneInMom.attributeValue("id"));
        }
    }

    private void setCurrSceneByCreate() {
        this.currSceneInMom = MultiFileHandlerHelper.createNewElementInMutiFile(this.scriptModelDocument.getRootElement(), "scene");
        this.sceneModelFile = ModelHelper.getFileByName(this.currSceneInMom.attributeValue("location"));
        this.sceneModelDocument = ModelHelper.getDocument(this.sceneModelFile);
        StatusHelper.setValue(this.scriptModelFile, "sceneId", this.currSceneInMom.attributeValue("id"));
        SceneManagerView sceneView = (SceneManagerView)WJ.getActivePage().findView(SceneManagerView.class.getName());
        if (sceneView != null) {
            sceneView.update(this.scriptModelDocument);
        }
    }

    private void createTag() {
        if (this.tagComp != null && !this.tagComp.isDisposed()) {
            this.tagComp.dispose();
            this.tagComp = null;
        }
        this.tagComp = new Composite(this.tagLocationComposite, 0);
        this.tagComp.setLayout((Layout)new GridLayout(8, false));
        this.widgterToNodeHelper = new WidgterToNode4TagHelper(this.scriptModelFile, this.scriptModelDocument, "eventSceneModify");
        Element scene = this.sceneModelDocument.getRootElement();
        GridData lblGd = new GridData(4, 0x1000000, false, false);
        GridData txtGd = new GridData(4, 4, true, false);
        Label lbl = new Label(this.tagComp, 131072);
        lbl.setText("\u540d\u79f0\uff1a");
        lbl.setLayoutData((Object)lblGd);
        Text txt = new Text(this.tagComp, 2048);
        txt.setLayoutData((Object)txtGd);
        this.widgterToNodeHelper.mapTextSave(txt, (Node)scene.element("name"));
        List<Element> tagList = TagHelper.getCheckedTags("scene");
        for (Element tag : tagList) {
            Element roleTag = TagHelper.getTagById(scene, tag.attributeValue("id"));
            if (roleTag == null) {
                roleTag = TagHelper.createTag(scene, tag);
            }
            lbl = new Label(this.tagComp, 131072);
            lbl.setText(String.valueOf(tag.attributeValue("name")) + "\uff1a");
            lbl.setLayoutData((Object)lblGd);
            txt = new Text(this.tagComp, 2048);
            txt.setLayoutData((Object)txtGd);
            this.widgterToNodeHelper.mapTextSave(txt, (Node)roleTag);
        }
        this.tagLocationComposite.layout();
    }

    private void setCurrScene(String sceneId) {
        this.currSceneInMom = ModelHelper.getElement(this.scriptModelDocument.getRootElement().elements("scene"), sceneId);
        this.sceneModelFile = ModelHelper.getFileByName(this.currSceneInMom.attributeValue("location"));
        this.sceneModelDocument = ModelHelper.getDocument(this.sceneModelFile);
    }

    public void propertyChange(PropertyChangeEvent event) {
        String eventName = event.getProperty();
        if (eventName.equals("eventSceneTagModify")) {
            this.sceneModelDocument = ModelHelper.getDocument(this.sceneModelFile);
            this.updateControlValue();
        } else if (event.getProperty().equals("eventExplorerChange")) {
            this.setPartName(this.getEditorInput().getName());
        }
    }

    @Override
    public void reload() {
        this.sceneModelDocument = ModelHelper.getDocument(this.sceneModelFile);
        this.updateControlValue();
        this.viewer.reLoadTopIndex();
    }

    public void setFocus() {
        this.viewer.getTextWidget().setFocus();
    }

    public void dispose() {
        StatusHelper.setValue(this.scriptModelFile, "sceneId", this.currSceneInMom.attributeValue("id"));
        FileEditorInput input = (FileEditorInput)this.getEditorInput();
        input.removeTreeItem();
        Activator.getDefault().removePropertyChangeListener(this);
    }

    @Override
    public TextViewer getTextViewer() {
        return this.viewer;
    }

    @Override
    public IFile getModelFile4History() {
        return this.sceneModelFile;
    }

    public void changeScene(String sceneId, boolean isLoad) {
        if (isLoad) {
            this.scriptModelDocument = ModelHelper.getDocument(this.scriptModelFile);
        }
        this.setCurrScene(sceneId);
        this.updateControlValue();
        StatusHelper.setValue(this.scriptModelFile, "sceneId", this.currSceneInMom.attributeValue("id"));
    }

    public IFile getModelFile4Scene() {
        return this.scriptModelFile;
    }

    public Element getCurrSceneInMom() {
        return this.currSceneInMom;
    }

    public void disable(String sceneId) {
        if (this.currSceneInMom.attributeValue("id").equals(sceneId)) {
            this.setEnable(false);
            this.currSceneInMom = null;
        }
    }

    private void setInitEditElement() {
        List sceneList = this.scriptModelDocument.getRootElement().elements("scene");
        if (sceneList == null || sceneList.isEmpty()) {
            this.setCurrSceneByCreate();
        } else {
            String sceneId = StatusHelper.getValue(this.scriptModelFile, "sceneId");
            this.setCurrScene(sceneId);
        }
    }

    private void createControl(Composite composite) {
        Composite parent = new Composite(composite, 0);
        parent.setLayout((Layout)new GridLayout(1, true));
        Label topCenterLabel = new Label(parent, 0);
        topCenterLabel.setText("\u5267\u672c\u8bbe\u5b9a");
        topCenterLabel.setAlignment(0x1000000);
        topCenterLabel.setLayoutData((Object)new GridData(0x1000000, 128, true, false));
        this.tagLocationComposite = new Composite(parent, 0);
        this.tagLocationComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        this.tagLocationComposite.setLayout((Layout)new FillLayout());
        Composite contentComposite = new Composite(parent, 0);
        contentComposite.setLayoutData((Object)new GridData(1808));
        contentComposite.setLayout((Layout)new FillLayout());
        this.viewer = new TextViewer(contentComposite, this.scriptModelDocument);
        Composite buttonComposite = new Composite(parent, 0);
        buttonComposite.setLayoutData((Object)new GridData(0x1000000, 4, false, false));
        buttonComposite.setLayout((Layout)new GridLayout(3, true));
        this.createBtn = new Button(buttonComposite, 0);
        this.createBtn.setText("\u521b\u5efa\u65b0\u5267\u672c");
    }

    private void setEnable(boolean isEnable) {
        Set<Control> controls = this.widgterToNodeHelper.getWidgetNodeMap().keySet();
        for (Control control : controls) {
            control.setEnabled(isEnable);
        }
        this.viewer.getTextWidget().setEnabled(isEnable);
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }
}

