/*
 * Decompiled with CFR 0.152.
 */
package wj.ap.file.editor;

import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.IME;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import wj.ap.explorer.ExplorerHelper;
import wj.ap.explorer.FileEditorInput;
import wj.ap.file.editor.ITextEditor;
import wj.ap.file.editor.MultiFileHandlerHelper;
import wj.ap.file.view.StorylineManagerView;
import wj.ap.history.IHistory;
import wj.ap.sys.Activator;
import wj.ap.textviewer.TextViewer;
import wj.ap.util.ModelHelper;
import wj.ap.util.StatusHelper;
import wj.ap.util.WJ;

public class StorylineEditor
extends EditorPart
implements ITextEditor,
IPropertyChangeListener,
IHistory {
    private IFile storylinesModelFile;
    private Document storylinesDocument;
    private Element currStorylineInMom;
    private IFile storylineModelFile;
    private Document storylineDocument;
    private Text nameText;
    private TextViewer viewer;
    private Button createBtn;
    private Button deleteBtn;
    private Button viewBtn;
    private Button writeBtn;
    private StorylineManagerView storylineManagerView;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.storylinesModelFile = (IFile)input.getAdapter(this.getClass());
        this.storylinesDocument = ModelHelper.getDocument(this.storylinesModelFile);
        this.setPartName(input.getName());
        Activator.getDefault().addPropertyChangeListener(this);
        this.setInitEditElement();
    }

    public void createPartControl(Composite composite) {
        this.createControl(composite);
        this.addListener();
        this.updateContentValue();
    }

    private void addListener() {
        this.viewer.addTextListener(new ITextListener(){

            public void textChanged(TextEvent event) {
                boolean isOver = false;
                IME ime = StorylineEditor.this.viewer.getTextWidget().getIME();
                if (ime.getCommitCount() != 0 && ime.getCommitCount() == ime.getText().length()) {
                    isOver = true;
                } else if (ime.getCommitCount() == 0 && ime.getText().length() == 0) {
                    isOver = true;
                }
                if (isOver) {
                    StorylineEditor.this.storylineDocument.getRootElement().element("description").setText(StorylineEditor.this.viewer.getTextWidget().getText());
                    ModelHelper.saveDocument(StorylineEditor.this.storylineDocument, StorylineEditor.this.storylineModelFile);
                }
            }
        });
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                StorylineEditor.this.storylineDocument.getRootElement().element("name").setText(StorylineEditor.this.nameText.getText());
                ModelHelper.saveDocument(StorylineEditor.this.storylineDocument, StorylineEditor.this.storylineModelFile);
                if (StorylineEditor.this.storylineManagerView != null) {
                    StorylineEditor.this.storylineManagerView.updateSelectRow(StorylineEditor.this.storylineDocument);
                }
            }
        });
        this.createBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Element root;
                String name;
                if (StorylineEditor.this.storylineDocument != null && (name = (root = StorylineEditor.this.storylineDocument.getRootElement()).elementText("name")).trim().equals("")) {
                    MessageDialog.openWarning(null, (String)"\u63d0\u793a", (String)"\u5f53\u524d\u60c5\u8282\u8fd8\u6ca1\u6709\u8f93\u5165\u540d\u79f0\uff0c\u8bf7\u8f93\u5165\u5f53\u524d\u60c5\u8282\u540d\u79f0\u540e\u518d\u521b\u5efa\u3002");
                    return;
                }
                StorylineEditor.this.createStoryline();
            }
        });
        this.deleteBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String message = "\u60a8\u786e\u5b9a\u8981\u5220\u9664\u5f53\u524d\u60c5\u8282\u5417\uff1f";
                if (MessageDialog.openQuestion(null, (String)"\u63d0\u793a", (String)message)) {
                    MultiFileHandlerHelper.deleteElementInMutiFile(StorylineEditor.this.currStorylineInMom);
                    StorylineEditor.this.disable(StorylineEditor.this.currStorylineInMom.attributeValue("id"));
                    if (StorylineEditor.this.storylineManagerView != null) {
                        StorylineEditor.this.storylineManagerView.update(StorylineEditor.this.storylinesDocument);
                    }
                }
            }
        });
        this.viewBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WJ.BroughtToTop(StorylineManagerView.class.getName());
            }
        });
        this.writeBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExplorerHelper.write();
            }
        });
    }

    public void setFocus() {
        this.viewer.getTextWidget().setFocus();
        StorylineManagerView view = (StorylineManagerView)WJ.getActivePage().findView(StorylineManagerView.class.getName());
        if (view != null) {
            view.registerEditor(this);
        }
    }

    private void updateContentValue() {
        this.setEnable(true);
        this.nameText.setText(this.storylineDocument.getRootElement().elementText("name"));
        this.viewer.getDocument().set(this.storylineDocument.getRootElement().elementText("description"));
        this.viewer.updateModel(this.storylineDocument, this.storylineModelFile);
        if (this.storylineManagerView != null) {
            this.storylineManagerView.selectRow(this.currStorylineInMom.attributeValue("id"));
        }
    }

    public void dispose() {
        FileEditorInput input = (FileEditorInput)this.getEditorInput();
        input.removeTreeItem();
        Activator.getDefault().removePropertyChangeListener(this);
        if (this.storylineManagerView != null) {
            this.storylineManagerView.unregisterEditor(this);
        }
    }

    @Override
    public TextViewer getTextViewer() {
        return this.viewer;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("eventExplorerChange")) {
            this.setPartName(this.getEditorInput().getName());
        }
    }

    @Override
    public void reload() {
        this.storylineDocument = ModelHelper.getDocument(this.storylineModelFile);
        this.updateContentValue();
        this.viewer.reLoadTopIndex();
    }

    @Override
    public IFile getModelFile4History() {
        return this.storylineModelFile;
    }

    public void disable(String storylineId) {
        if (this.currStorylineInMom.attributeValue("id").equals(storylineId)) {
            this.setEnable(false);
            this.currStorylineInMom = null;
            this.storylineDocument = null;
            this.storylineModelFile = null;
        }
    }

    public void changeStoryline(String storylineId, boolean isLoad) {
        if (isLoad) {
            this.storylinesDocument = ModelHelper.getDocument(this.storylinesModelFile);
        }
        this.setEnable(true);
        this.setCurrStoryline(storylineId);
        this.updateContentValue();
    }

    public IFile getStorylinesModelFile() {
        return this.storylinesModelFile;
    }

    public Element getCurrStorylineInMom() {
        return this.currStorylineInMom;
    }

    private void createStoryline() {
        this.setEnable(true);
        this.setCurrStorylineByCreate();
        this.updateContentValue();
    }

    private void setInitEditElement() {
        List storylineList = this.storylinesDocument.getRootElement().elements("storyline");
        if (storylineList == null || storylineList.isEmpty()) {
            this.setCurrStorylineByCreate();
        } else {
            String storylineId = StatusHelper.getValue(this.storylinesModelFile, "storylineId");
            this.setCurrStoryline(storylineId);
        }
    }

    private void setCurrStorylineByCreate() {
        this.currStorylineInMom = MultiFileHandlerHelper.createNewElementInMutiFile(this.storylinesDocument.getRootElement(), "storyline");
        this.storylineModelFile = ModelHelper.getFileByName(this.currStorylineInMom.attributeValue("location"));
        this.storylineDocument = ModelHelper.getDocument(this.storylineModelFile);
        StatusHelper.setValue(this.storylinesModelFile, "storylineId", this.currStorylineInMom.attributeValue("id"));
        if (this.storylineManagerView != null) {
            this.storylineManagerView.update(this.storylinesDocument);
        }
    }

    private void setCurrStoryline(String roleId) {
        this.currStorylineInMom = ModelHelper.getElement(this.storylinesDocument.getRootElement().elements("storyline"), roleId);
        this.storylineModelFile = ModelHelper.getFileByName(this.currStorylineInMom.attributeValue("location"));
        this.storylineDocument = ModelHelper.getDocument(this.storylineModelFile);
    }

    private void createControl(Composite composite) {
        Composite parent = new Composite(composite, 0);
        parent.setLayout((Layout)new GridLayout(1, true));
        Composite nameComp = new Composite(parent, 0);
        nameComp.setLayoutData((Object)new GridData(4, 4, true, false));
        nameComp.setLayout((Layout)new GridLayout(2, false));
        Label nameLabel = new Label(nameComp, 0);
        nameLabel.setText("\u60c5\u8282\u540d\uff1a");
        this.nameText = new Text(nameComp, 0);
        this.nameText.setLayoutData((Object)new GridData(1808));
        Composite contentComposite = new Composite(parent, 0);
        contentComposite.setLayoutData((Object)new GridData(1808));
        contentComposite.setLayout((Layout)new FillLayout());
        this.viewer = new TextViewer(contentComposite, this.storylineDocument);
        Composite buttonComposite = new Composite(parent, 0);
        buttonComposite.setLayoutData((Object)new GridData(0x1000000, 4, true, false));
        buttonComposite.setLayout((Layout)new GridLayout(4, true));
        GridData gd = new GridData(0x1000000, 4, true, false);
        this.createBtn = new Button(buttonComposite, 0);
        this.createBtn.setText("\u521b\u5efa ");
        this.createBtn.setLayoutData((Object)gd);
        this.deleteBtn = new Button(buttonComposite, 0);
        this.deleteBtn.setText("\u5220\u9664 ");
        this.deleteBtn.setLayoutData((Object)gd);
        this.viewBtn = new Button(buttonComposite, 0);
        this.viewBtn.setText("\u6d4f\u89c8");
        this.viewBtn.setLayoutData((Object)gd);
        this.writeBtn = new Button(buttonComposite, 0);
        this.writeBtn.setText("\u76f4\u63a5\u5199\u4f5c");
        this.writeBtn.setLayoutData((Object)gd);
        buttonComposite.layout();
    }

    private void setEnable(boolean b) {
        this.nameText.setEnabled(b);
        this.viewer.getTextWidget().setEnabled(b);
    }

    public void registerView(StorylineManagerView view) {
        this.storylineManagerView = view;
    }

    public void unregisterView() {
        this.storylineManagerView = null;
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }
}

