/*
 * Decompiled with CFR 0.152.
 */
package wj.ap.file.editor;

import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.IME;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import wj.ap.explorer.ExplorerHelper;
import wj.ap.explorer.ExplorerModelHelper;
import wj.ap.explorer.ExplorerView;
import wj.ap.explorer.FileEditorInput;
import wj.ap.file.editor.ITextEditor;
import wj.ap.history.IHistory;
import wj.ap.sys.Activator;
import wj.ap.textviewer.TextViewer;
import wj.ap.util.ModelHelper;
import wj.ap.util.WJ;

public class ThemeEditor
extends EditorPart
implements ITextEditor,
IPropertyChangeListener,
IHistory {
    private TextViewer viewer;
    private IFile modelFile;
    private Document document;
    private Button nextBtn;
    private Button writeBtn;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.modelFile = (IFile)input.getAdapter(this.getClass());
        this.document = ModelHelper.getDocument(this.modelFile);
        this.setPartName(input.getName());
        Activator.getDefault().addPropertyChangeListener(this);
    }

    public void createPartControl(Composite composite) {
        Composite parent = new Composite(composite, 0);
        parent.setLayout((Layout)new GridLayout(1, true));
        Label topCenterLabel = new Label(parent, 0);
        topCenterLabel.setText("\u4e3b\u9898\u5927\u7eb2\uff08\u57fa\u672c\u8bbe\u5b9a\uff09");
        topCenterLabel.setAlignment(0x1000000);
        topCenterLabel.setLayoutData((Object)new GridData(0x1000000, 128, true, false));
        Composite contentComposite = new Composite(parent, 0);
        contentComposite.setLayoutData((Object)new GridData(1808));
        contentComposite.setLayout((Layout)new FillLayout());
        this.viewer = new TextViewer(contentComposite, this.document);
        this.viewer.getDocument().set(this.document.getRootElement().elementText("description"));
        Composite buttonComposite = new Composite(parent, 0);
        buttonComposite.setLayoutData((Object)new GridData(0x1000000, 4, false, false));
        buttonComposite.setLayout((Layout)new GridLayout(3, true));
        this.nextBtn = new Button(buttonComposite, 0);
        this.nextBtn.setText("\u4e0b\u4e00\u6b65");
        this.writeBtn = new Button(buttonComposite, 0);
        this.writeBtn.setText("\u76f4\u63a5\u5199\u4f5c");
        this.listner();
    }

    private void listner() {
        this.viewer.addTextListener(new ITextListener(){

            public void textChanged(TextEvent event) {
                boolean isOver = false;
                IME ime = ThemeEditor.this.viewer.getTextWidget().getIME();
                if (ime.getCommitCount() != 0 && ime.getCommitCount() == ime.getText().length()) {
                    isOver = true;
                } else if (ime.getCommitCount() == 0 && ime.getText().length() == 0) {
                    isOver = true;
                }
                if (isOver) {
                    Element content = ThemeEditor.this.document.getRootElement().element("description");
                    content.setText(ThemeEditor.this.viewer.getTextWidget().getText());
                    ModelHelper.saveDocument(ThemeEditor.this.document, ThemeEditor.this.modelFile);
                }
            }
        });
        this.nextBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Element theme = ExplorerModelHelper.getElement(ThemeEditor.this.document.getRootElement().attributeValue("id"));
                List outlineList = theme.getParent().elements();
                Element roleNode = null;
                for (Element outline : outlineList) {
                    if (!outline.getName().equals("roles")) continue;
                    roleNode = outline;
                    break;
                }
                if (roleNode == null) {
                    roleNode = ExplorerModelHelper.createFileByButton(theme.getParent(), "roles", "\u89d2\u8272");
                }
                ExplorerView explorer = (ExplorerView)WJ.getActivePage().findView(ExplorerView.class.getName());
                explorer.openEditor(roleNode.attributeValue("id"));
            }
        });
        this.writeBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExplorerHelper.write();
            }
        });
    }

    public void dispose() {
        FileEditorInput input = (FileEditorInput)this.getEditorInput();
        input.removeTreeItem();
        Activator.getDefault().removePropertyChangeListener(this);
    }

    @Override
    public TextViewer getTextViewer() {
        return this.viewer;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("eventExplorerChange")) {
            this.setPartName(this.getEditorInput().getName());
        }
    }

    @Override
    public void reload() {
        this.document = ModelHelper.getDocument(this.modelFile);
        this.viewer.getDocument().set(ModelHelper.getContent(this.document));
        this.viewer.reLoadTopIndex();
    }

    @Override
    public IFile getModelFile4History() {
        return this.modelFile;
    }

    public void setFocus() {
        this.viewer.getTextWidget().setFocus();
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }
}

