/*
 * Decompiled with CFR 0.152.
 */
package wj.ap.file.view;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.Element;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.part.ViewPart;
import wj.ap.explorer.ExplorerHelper;
import wj.ap.explorer.ExplorerView;
import wj.ap.file.editor.MultiFileHandlerHelper;
import wj.ap.file.editor.RoleEditor;
import wj.ap.file.editor.TagHelper;
import wj.ap.file.view.TableViewActionHelper;
import wj.ap.sys.Activator;
import wj.ap.textviewer.KeywordsHelper;
import wj.ap.util.ModelHelper;
import wj.ap.util.StatusHelper;
import wj.ap.util.WJ;

public class RoleManagerView
extends ViewPart
implements IPropertyChangeListener {
    private Document rolesDoc;
    private Composite tableComp;
    private Table table;
    private Map<String, TableItem> roleId2TableItem = new HashMap<String, TableItem>();
    private Map<String, Integer> tagId2Index;
    private RoleEditor roleEditor;

    public void createPartControl(Composite parent) {
        this.tableComp = parent;
        this.update(null);
        Activator.getDefault().addPropertyChangeListener(this);
        this.setTitleToolTip("\u89d2\u8272\u7ba1\u7406");
    }

    public void update(Document rolesDoc) {
        this.rolesDoc = rolesDoc;
        if (this.table != null) {
            this.table.dispose();
            this.table = null;
        }
        this.table = new Table(this.tableComp, 68356);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        this.createColumn();
        this.loadRoles();
        this.pack();
        this.tableComp.layout();
        this.addListener();
        new TableViewActionHelper(this.table, new DeleteAction(), new CreateAction());
    }

    private void addListener() {
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Element selectElement = (Element)RoleManagerView.this.table.getSelection()[0].getData();
                if (RoleManagerView.this.roleEditor != null) {
                    RoleManagerView.this.roleEditor.changeRole(selectElement.attributeValue("id"), false);
                }
            }
        });
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                if (RoleManagerView.this.table.getSelectionCount() == 0) {
                    return;
                }
                Element selectElement = (Element)RoleManagerView.this.table.getSelection()[0].getData();
                String id = selectElement.getDocument().getRootElement().attributeValue("id");
                ExplorerView explorerView = (ExplorerView)WJ.getActivePage().findView(ExplorerView.class.getName());
                explorerView.openEditor(id);
                RoleManagerView.this.roleEditor.changeRole(selectElement.attributeValue("id"), false);
            }
        });
    }

    private void pack() {
        int i = 0;
        while (i < this.table.getColumnCount()) {
            this.table.getColumn(i).pack();
            ++i;
        }
    }

    private void loadRoles() {
        if (this.rolesDoc == null) {
            return;
        }
        this.roleId2TableItem.clear();
        List<Map.Entry<Element, Integer>> list = WJ.sortElement(this.rolesDoc.getRootElement().elements("role"));
        int count = 1;
        Iterator<Map.Entry<Element, Integer>> it = list.iterator();
        while (it.hasNext()) {
            Element roleInMom = it.next().getKey();
            Element roleRoot = ModelHelper.getDocument(roleInMom.attributeValue("location")).getRootElement();
            TableItem item = new TableItem(this.table, 0);
            item.setData((Object)roleInMom);
            item.setText(0, String.valueOf(count++));
            item.setText(1, roleRoot.elementText("name"));
            item.setText(2, "");
            this.roleId2TableItem.put(roleInMom.attributeValue("id"), item);
            List<Element> tagList = TagHelper.getCheckedTags("role");
            int i = 3;
            List tags = roleRoot.elements("tag");
            for (Element tag : tagList) {
                item.setText(i, this.getTagText(tags, tag.attributeValue("id")));
                ++i;
            }
        }
        String location = this.rolesDoc.getRootElement().attributeValue("location");
        String storyId = location.replace(File.separator, ";").split(";")[0];
        KeywordsHelper keywordsHelper = KeywordsHelper.getKeywordsHelper(storyId);
        this.refreshCount(keywordsHelper.getKeywordCount());
    }

    public void refreshCount(Map<String, Integer> map) {
        TableItem[] items = this.table.getItems();
        int i = 0;
        while (i < items.length) {
            String name = items[i].getText(1);
            Integer count = map.get(name);
            items[i].setText(2, count == null ? "0" : "" + count);
            ++i;
        }
    }

    private String getTagText(List<Element> tags, String tagId) {
        for (Element tag : tags) {
            if (!tag.attributeValue("id").equals(tagId)) continue;
            return tag.getTextTrim();
        }
        return "";
    }

    private void createColumn() {
        TableColumn tableColumn = new TableColumn(this.table, 0x1000000);
        tableColumn.setText("\u5e8f\u53f7");
        tableColumn = new TableColumn(this.table, 0x1000000);
        tableColumn.setText("\u540d\u79f0");
        tableColumn.setToolTipText("\u89d2\u8272\u540d\u79f0");
        tableColumn = new TableColumn(this.table, 0x1000000);
        tableColumn.setText("\u6b21\u6570");
        tableColumn.setToolTipText("\u89d2\u8272\u5728\u6b63\u6587\u4e2d\u51fa\u73b0\u7684\u6b21\u6570");
        this.tagId2Index = new HashMap<String, Integer>();
        int i = 3;
        List<Element> tagList = TagHelper.getCheckedTags("role");
        for (Element tag : tagList) {
            tableColumn = new TableColumn(this.table, 0x1000000);
            tableColumn.setText(tag.attributeValue("name"));
            tableColumn.setToolTipText(tag.attributeValue("description"));
            this.tagId2Index.put(tag.attributeValue("id"), i);
            ++i;
        }
    }

    public void selectRow(String roleId) {
        TableItem item = this.roleId2TableItem.get(roleId);
        if (item != null && this.table.getSelectionCount() == 0) {
            this.table.setSelection(item);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("eventRoleModify")) {
            Element element = (Element)event.getNewValue();
            TableItem item = this.roleId2TableItem.get(element.getParent().attributeValue("id"));
            if (element.getName().equals("tag")) {
                item.setText(this.tagId2Index.get(element.attributeValue("id")).intValue(), element.getTextTrim());
            } else if (element.getName().equals("name")) {
                item.setText(1, element.getText());
            }
            this.pack();
        } else if (event.getProperty().equals("eventDeleteExplorerNode")) {
            IFile file;
            if (!(this.rolesDoc == null || (file = ModelHelper.getFileByName(this.rolesDoc.getRootElement().attributeValue("location"))) != null && file.exists())) {
                this.update(null);
            }
        } else if (event.getProperty().equals("eventRoleTagModify")) {
            this.update(this.rolesDoc);
        }
    }

    public void registerEditor(RoleEditor editor) {
        if (editor.equals(this.roleEditor)) {
            return;
        }
        this.roleEditor = editor;
        this.roleEditor.registerView(this);
        this.update(ModelHelper.getDocument(this.roleEditor.getRolesModelFile()));
        Element roleElement = this.roleEditor.getCurrRoleInMom();
        if (roleElement != null) {
            this.selectRow(roleElement.attributeValue("id"));
        }
    }

    public void unregisterEditor(RoleEditor editor) {
        if (editor.equals(this.roleEditor)) {
            this.roleEditor.unregisterView();
            this.roleEditor = null;
        }
    }

    public void dispose() {
        if (this.roleEditor != null) {
            this.roleEditor.unregisterView();
        }
        Activator.getDefault().removePropertyChangeListener(this);
    }

    public void setFocus() {
        IEditorPart part;
        ExplorerView exploerView;
        String selectNodePath;
        if (this.rolesDoc == null && (selectNodePath = (exploerView = (ExplorerView)WJ.getActivePage().findView(ExplorerView.class.getName())).getSelectNodePath()) != null) {
            String[] parts = selectNodePath.replace(File.separator, ";").split(";");
            String rolesPath = ExplorerHelper.getOutlineFilePath(parts[0], "roles");
            if (rolesPath == null) {
                return;
            }
            this.update(ModelHelper.getDocument(rolesPath));
        }
        if (this.roleEditor == null && (part = WJ.getActivePage().getActiveEditor()) instanceof RoleEditor) {
            this.registerEditor((RoleEditor)part);
        }
    }

    private class CreateAction
    extends Action {
        public CreateAction() {
            this.setText("\u521b\u5efa");
            this.setEnabled(RoleManagerView.this.rolesDoc != null);
        }

        public void run() {
            ExplorerView explorer = (ExplorerView)WJ.getActivePage().findView(ExplorerView.class.getName());
            explorer.openEditor(RoleManagerView.this.rolesDoc.getRootElement().attributeValue("id"));
            TableItem[] items = RoleManagerView.this.table.getItems();
            int i = 0;
            while (i < items.length) {
                if (items[i].getText(1).trim().equals("")) {
                    MessageDialog.openInformation(null, (String)"\u63d0\u793a", (String)("\u7b2c" + (i + 1) + "\u4e2a\u89d2\u8272\u7684\u540d\u79f0\u8fd8\u6ca1\u6709\u8f93\u5165\uff0c\u8bf7\u8f93\u5165\u540e\u518d\u521b\u5efa\u65b0\u89d2\u8272\u3002"));
                    return;
                }
                ++i;
            }
            Element roleInMom = MultiFileHandlerHelper.createNewElementInMutiFile(RoleManagerView.this.rolesDoc.getRootElement(), "role");
            IFile rolesModelFile = ModelHelper.getFileByName(roleInMom.getParent().attributeValue("location"));
            StatusHelper.setValue(rolesModelFile, "roleId", roleInMom.attributeValue("id"));
            RoleManagerView.this.roleEditor.changeRole(roleInMom.attributeValue("id"), true);
            String filePath = roleInMom.getParent().attributeValue("location");
            RoleManagerView.this.update(ModelHelper.getDocument(ModelHelper.getFileByName(filePath)));
            RoleManagerView.this.selectRow(roleInMom.attributeValue("id"));
        }
    }

    private class DeleteAction
    extends Action {
        public DeleteAction() {
            this.setText("\u5220\u9664");
        }

        public void run() {
            TableItem item = RoleManagerView.this.table.getSelection()[0];
            Element elementInMom = (Element)item.getData();
            String message = "\u60a8\u786e\u5b9a\u8981\u5220\u9664\u89d2\u8272\u201c" + item.getText(1) + "\u201d\u5417\uff1f";
            if (MessageDialog.openQuestion(null, (String)"\u63d0\u793a", (String)message)) {
                MultiFileHandlerHelper.deleteElementInMutiFile(elementInMom);
                item.dispose();
                if (RoleManagerView.this.roleEditor != null) {
                    RoleManagerView.this.roleEditor.disable(elementInMom.attributeValue("id"));
                }
                String location = RoleManagerView.this.rolesDoc.getRootElement().attributeValue("location");
                String storyId = location.replace(File.separator, ";").split(";")[0];
                KeywordsHelper keywordsHelper = KeywordsHelper.getKeywordsHelper(storyId);
                WJ.refreshKeywordsInEditor(keywordsHelper);
            }
        }
    }
}

