/*
 * Decompiled with CFR 0.152.
 */
package wj.ap.file.view;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.Element;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;
import wj.ap.explorer.ExplorerView;
import wj.ap.file.editor.MultiFileHandlerHelper;
import wj.ap.file.editor.ScriptEditor;
import wj.ap.file.editor.TagHelper;
import wj.ap.file.view.TableViewActionHelper;
import wj.ap.sys.Activator;
import wj.ap.util.ModelHelper;
import wj.ap.util.WJ;

public class SceneManagerView
extends ViewPart
implements IPropertyChangeListener {
    private Document document;
    private Composite parent;
    private Table table;
    private Map<String, TableItem> sceneId2TableItem = new HashMap<String, TableItem>();
    private Map<String, Integer> tagId2Index = new HashMap<String, Integer>();
    private ScriptEditor currScriptEditor;

    public void createPartControl(Composite parent) {
        this.parent = parent;
        this.update(null);
        Activator.getDefault().addPropertyChangeListener(this);
        this.addPartListener();
        this.setTitleToolTip("\u573a\u666f\u7ba1\u7406");
    }

    public void update(Document scriptDoc) {
        this.document = scriptDoc;
        if (this.table != null) {
            this.table.dispose();
            this.table = null;
            this.sceneId2TableItem.clear();
            this.tagId2Index.clear();
        }
        this.table = new Table(this.parent, 68356);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        this.createColumn();
        this.loadScenes();
        this.parent.layout();
        this.pack();
        this.addListener();
        new TableViewActionHelper(this.table, new DeleteAction(), new CreateAction());
    }

    private void addListener() {
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Element selectElement = (Element)SceneManagerView.this.table.getSelection()[0].getData();
                if (SceneManagerView.this.currScriptEditor != null) {
                    SceneManagerView.this.currScriptEditor.changeScene(selectElement.attributeValue("id"), false);
                }
            }
        });
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                if (SceneManagerView.this.table.getSelectionCount() == 0) {
                    return;
                }
                Element selectElement = (Element)SceneManagerView.this.table.getSelection()[0].getData();
                String location = selectElement.getDocument().getRootElement().attributeValue("location");
                String[] parts = location.replace(File.separator, ";").split(";");
                ExplorerView explorerView = (ExplorerView)WJ.getActivePage().findView(ExplorerView.class.getName());
                explorerView.openEditor(parts[parts.length - 1]);
                SceneManagerView.this.currScriptEditor.changeScene(selectElement.attributeValue("id"), false);
            }
        });
    }

    private void pack() {
        int i = 0;
        while (i < this.table.getColumnCount()) {
            this.table.getColumn(i).pack();
            ++i;
        }
    }

    private void loadScenes() {
        if (this.document == null) {
            return;
        }
        Element root = this.document.getRootElement();
        List list = root.elements("scene");
        int count = 1;
        for (Element element : list) {
            TableItem item = new TableItem(this.table, 0);
            item.setData((Object)element);
            item.setText(0, String.valueOf(count++));
            this.sceneId2TableItem.put(element.attributeValue("id"), item);
            List<Element> tagList = TagHelper.getCheckedTags("scene");
            int i = 1;
            for (Element tag : tagList) {
                item.setText(i, this.getTagText(element, tag.attributeValue("id")));
                ++i;
            }
        }
    }

    private String getTagText(Element sceneElement, String tagId) {
        List tags = sceneElement.elements("tag");
        for (Element tag : tags) {
            if (!tag.attributeValue("id").equals(tagId)) continue;
            return tag.getTextTrim();
        }
        return "";
    }

    private void createColumn() {
        TableColumn tableColumn = new TableColumn(this.table, 0x1000000);
        tableColumn.setText("\u5e8f\u53f7");
        tableColumn = new TableColumn(this.table, 0x1000000);
        tableColumn.setText("\u540d\u79f0");
        int i = 2;
        List<Element> tagList = TagHelper.getCheckedTags("scene");
        for (Element tag : tagList) {
            tableColumn = new TableColumn(this.table, 0x1000000);
            tableColumn.setText(tag.attributeValue("name"));
            tableColumn.setToolTipText(tag.attributeValue("description"));
            this.tagId2Index.put(tag.attributeValue("id"), i);
            ++i;
        }
    }

    public void setFocus() {
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("eventSceneModify")) {
            Element tagElement = (Element)event.getNewValue();
            TableItem item = this.sceneId2TableItem.get(tagElement.getParent().attributeValue("id"));
            if (tagElement.getName().equals("tag")) {
                item.setText(this.tagId2Index.get(tagElement.attributeValue("id")).intValue(), tagElement.getTextTrim());
            } else if (tagElement.getName().equals("name")) {
                item.setText(1, tagElement.getText());
            }
            this.pack();
        } else if (event.getProperty().equals("eventDeleteExplorerNode") && this.document != null) {
            IFile file = ModelHelper.getFileByName(this.document.getRootElement().attributeValue("location"));
            if (file != null && file.exists()) {
                this.update(ModelHelper.getDocument(file));
            } else {
                this.update(null);
            }
        }
    }

    private void loginEditor(IWorkbenchPart part) {
        if (!(part instanceof ScriptEditor)) {
            return;
        }
        ScriptEditor editor = (ScriptEditor)part;
        if (editor.equals(this.currScriptEditor)) {
            return;
        }
        this.currScriptEditor = editor;
        Element sceneElement = this.currScriptEditor.getCurrSceneInMom();
        if (sceneElement == null) {
            return;
        }
        String filePath = sceneElement.getParent().attributeValue("location");
        this.update(ModelHelper.getDocument(filePath));
        this.selectRow(sceneElement.attributeValue("id"));
    }

    public void selectRow(String sceneId) {
        TableItem item = this.sceneId2TableItem.get(sceneId);
        if (item != null && this.table.getSelectionCount() == 0) {
            this.table.setSelection(item);
        }
    }

    public void dispose() {
        Activator.getDefault().removePropertyChangeListener(this);
    }

    private void addPartListener() {
        this.getViewSite().getPage().addPartListener(new IPartListener(){

            public void partOpened(IWorkbenchPart part) {
            }

            public void partDeactivated(IWorkbenchPart part) {
            }

            public void partClosed(IWorkbenchPart part) {
            }

            public void partBroughtToTop(IWorkbenchPart part) {
                SceneManagerView.this.loginEditor(part);
            }

            public void partActivated(IWorkbenchPart part) {
                SceneManagerView.this.loginEditor(part);
            }
        });
    }

    private class CreateAction
    extends Action {
        public CreateAction() {
            this.setText("\u521b\u5efa");
        }

        public void run() {
            Element sceneInMom = MultiFileHandlerHelper.createNewElementInMutiFile(SceneManagerView.this.document.getRootElement(), "scene");
            String scriptFileLocation = sceneInMom.getParent().attributeValue("location");
            String[] parts = scriptFileLocation.replace(File.separator, ";").split(";");
            ExplorerView explorer = (ExplorerView)WJ.getActivePage().findView(ExplorerView.class.getName());
            explorer.openEditor(parts[parts.length - 1]);
            SceneManagerView.this.currScriptEditor.changeScene(sceneInMom.attributeValue("id"), true);
            String filePath = sceneInMom.getParent().attributeValue("location");
            SceneManagerView.this.update(ModelHelper.getDocument(filePath));
            SceneManagerView.this.selectRow(sceneInMom.attributeValue("id"));
        }
    }

    private class DeleteAction
    extends Action {
        public DeleteAction() {
            this.setText("\u5220\u9664");
        }

        public void run() {
            TableItem item = SceneManagerView.this.table.getSelection()[0];
            Element elementInMom = (Element)item.getData();
            String message = "\u60a8\u786e\u5b9a\u8981\u5220\u9664\u573a\u666f\u201c" + item.getText(1) + "\u201d\u5417\uff1f";
            if (MessageDialog.openQuestion(null, (String)"\u63d0\u793a", (String)message)) {
                MultiFileHandlerHelper.deleteElementInMutiFile(elementInMom);
                item.dispose();
                if (SceneManagerView.this.currScriptEditor != null) {
                    SceneManagerView.this.currScriptEditor.disable(elementInMom.attributeValue("id"));
                }
            }
        }
    }
}

