/*
 * Decompiled with CFR 0.152.
 */
package wj.ap.file.view;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.Element;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.part.ViewPart;
import wj.ap.explorer.ExplorerHelper;
import wj.ap.explorer.ExplorerView;
import wj.ap.file.editor.MultiFileHandlerHelper;
import wj.ap.file.editor.StorylineEditor;
import wj.ap.file.view.TableViewActionHelper;
import wj.ap.sys.Activator;
import wj.ap.util.ModelHelper;
import wj.ap.util.StatusHelper;
import wj.ap.util.WJ;

public class StorylineManagerView
extends ViewPart
implements IPropertyChangeListener {
    private Document storylinesDoc;
    private Composite parent;
    private Table table;
    private Map<String, TableItem> storylineIdTableItemMap = new HashMap<String, TableItem>();
    private StorylineEditor storylineEditor;

    public void createPartControl(Composite parent) {
        this.parent = parent;
        this.createTable();
        Activator.getDefault().addPropertyChangeListener(this);
        this.setTitleToolTip("\u60c5\u8282\u7ba1\u7406");
    }

    private void createTable() {
        this.table = new Table(this.parent, 68356);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        this.createColumn();
        this.addListener();
    }

    private void addListener() {
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (StorylineManagerView.this.table.getSelectionCount() == 0) {
                    return;
                }
                Element selectElement = (Element)StorylineManagerView.this.table.getSelection()[0].getData();
                if (StorylineManagerView.this.storylineEditor != null) {
                    StorylineManagerView.this.storylineEditor.changeStoryline(selectElement.attributeValue("id"), false);
                }
            }
        });
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                if (StorylineManagerView.this.table.getSelectionCount() == 0) {
                    return;
                }
                Element selectElement = (Element)StorylineManagerView.this.table.getSelection()[0].getData();
                String id = selectElement.getDocument().getRootElement().attributeValue("id");
                ExplorerView explorerView = (ExplorerView)WJ.getActivePage().findView(ExplorerView.class.getName());
                explorerView.openEditor(id);
                StorylineManagerView.this.storylineEditor.changeStoryline(selectElement.attributeValue("id"), false);
            }
        });
    }

    public void update(Document storylinesDoc) {
        this.storylinesDoc = storylinesDoc;
        this.table.removeAll();
        this.storylineIdTableItemMap.clear();
        if (storylinesDoc == null) {
            return;
        }
        List<Map.Entry<Element, Integer>> list = WJ.sortElement(storylinesDoc.getRootElement().elements());
        int i = 1;
        Iterator<Map.Entry<Element, Integer>> it = list.iterator();
        while (it.hasNext()) {
            Element storyline = it.next().getKey();
            this.createTableItem(storyline, i);
            ++i;
        }
        new TableViewActionHelper(this.table, new DeleteAction(), new CreateAction());
    }

    public void setFocus() {
        IEditorPart part;
        ExplorerView exploerView;
        String selectNodePath;
        if (this.storylinesDoc == null && (selectNodePath = (exploerView = (ExplorerView)WJ.getActivePage().findView(ExplorerView.class.getName())).getSelectNodePath()) != null) {
            String[] parts = selectNodePath.replace(File.separator, ";").split(";");
            String storylinePath = ExplorerHelper.getOutlineFilePath(parts[0], "storylines");
            if (storylinePath == null) {
                return;
            }
            this.update(ModelHelper.getDocument(ModelHelper.getFileByName(storylinePath)));
        }
        if (this.storylineEditor == null && (part = WJ.getActivePage().getActiveEditor()) instanceof StorylineEditor) {
            this.registerEditor((StorylineEditor)part);
        }
    }

    public void dispose() {
        if (this.storylineEditor != null) {
            this.storylineEditor.unregisterView();
        }
        Activator.getDefault().removePropertyChangeListener(this);
    }

    public void selectRow(String storylineId) {
        TableItem item = this.storylineIdTableItemMap.get(storylineId);
        if (item != null && this.table.getSelectionCount() == 0) {
            this.table.setSelection(item);
        }
    }

    public void updateSelectRow(Document storylineDoc) {
        if (this.table == null || this.table.getSelectionCount() == 0) {
            return;
        }
        Element root = storylineDoc.getRootElement();
        TableItem item = this.table.getSelection()[0];
        Element inMom = (Element)item.getData();
        if (root.attributeValue("id").equals(inMom.attributeValue("id"))) {
            item.setText(1, root.elementText("name"));
        }
    }

    public void registerEditor(StorylineEditor editor) {
        if (editor.equals(this.storylineEditor)) {
            return;
        }
        this.storylineEditor = editor;
        this.storylineEditor.registerView(this);
        this.update(ModelHelper.getDocument(this.storylineEditor.getStorylinesModelFile()));
        Element storyline = this.storylineEditor.getCurrStorylineInMom();
        if (storyline != null) {
            this.selectRow(storyline.attributeValue("id"));
        }
    }

    public void unregisterEditor(StorylineEditor editor) {
        if (editor.equals(this.storylineEditor)) {
            this.storylineEditor.unregisterView();
            this.storylineEditor = null;
        }
    }

    private void createTableItem(Element storyline, int index) {
        TableItem item = new TableItem(this.table, 0);
        item.setText(0, String.valueOf(index));
        Document doc = ModelHelper.getDocument(storyline.attributeValue("location"));
        String name = doc.getRootElement().elementText("name");
        item.setText(1, name);
        item.setData((Object)storyline);
        this.storylineIdTableItemMap.put(storyline.attributeValue("id"), item);
    }

    private void createColumn() {
        TableColumn tableColumn = new TableColumn(this.table, 0x1000000);
        tableColumn.setText("\u5e8f\u53f7");
        tableColumn.setWidth(40);
        tableColumn = new TableColumn(this.table, 0x1000000);
        tableColumn.setText("\u60c5\u8282\u540d");
        tableColumn.setWidth(220);
    }

    public void propertyChange(PropertyChangeEvent event) {
        IFile file;
        if (event.getProperty().equals("eventDeleteExplorerNode") && this.storylinesDoc != null && ((file = ModelHelper.getFileByName(this.storylinesDoc.getRootElement().attributeValue("location"))) == null || !file.exists())) {
            this.update(null);
        }
    }

    private class CreateAction
    extends Action {
        public CreateAction() {
            this.setText("\u521b\u5efa");
            this.setEnabled(StorylineManagerView.this.storylinesDoc != null);
        }

        public void run() {
            ExplorerView explorer = (ExplorerView)WJ.getActivePage().findView(ExplorerView.class.getName());
            explorer.openEditor(StorylineManagerView.this.storylinesDoc.getRootElement().attributeValue("id"));
            TableItem[] items = StorylineManagerView.this.table.getItems();
            int i = 0;
            while (i < items.length) {
                if (items[i].getText(1).trim().equals("")) {
                    MessageDialog.openInformation(null, (String)"\u63d0\u793a", (String)("\u7b2c" + (i + 1) + "\u4e2a\u60c5\u8282\u7684\u540d\u79f0\u8fd8\u6ca1\u6709\u8f93\u5165\uff0c\u8bf7\u8f93\u5165\u540e\u518d\u521b\u5efa\u65b0\u60c5\u8282\u3002"));
                    return;
                }
                ++i;
            }
            Element storylineInMom = MultiFileHandlerHelper.createNewElementInMutiFile(StorylineManagerView.this.storylinesDoc.getRootElement(), "storyline");
            IFile storylinesModelFile = ModelHelper.getFileByName(storylineInMom.getParent().attributeValue("location"));
            StatusHelper.setValue(storylinesModelFile, "storylineId", storylineInMom.attributeValue("id"));
            StorylineManagerView.this.storylineEditor.changeStoryline(storylineInMom.attributeValue("id"), true);
            String filePath = storylineInMom.getParent().attributeValue("location");
            StorylineManagerView.this.update(ModelHelper.getDocument(ModelHelper.getFileByName(filePath)));
            StorylineManagerView.this.selectRow(storylineInMom.attributeValue("id"));
        }
    }

    private class DeleteAction
    extends Action {
        public DeleteAction() {
            this.setText("\u5220\u9664");
        }

        public void run() {
            TableItem item = StorylineManagerView.this.table.getSelection()[0];
            Element elementInMom = (Element)item.getData();
            String message = "\u60a8\u786e\u5b9a\u8981\u5220\u9664\u60c5\u8282\u201c" + item.getText(1) + "\u201d\u5417\uff1f";
            if (MessageDialog.openQuestion(null, (String)"\u63d0\u793a", (String)message)) {
                ModelHelper.getFileByName(elementInMom.attributeValue("location"));
                MultiFileHandlerHelper.deleteElementInMutiFile(elementInMom);
                item.dispose();
                StorylineManagerView.this.update(StorylineManagerView.this.storylinesDoc);
                if (StorylineManagerView.this.storylineEditor != null) {
                    StorylineManagerView.this.storylineEditor.disable(elementInMom.attributeValue("id"));
                }
            }
        }
    }
}

