/*
 * Decompiled with CFR 0.152.
 */
package wj.ap.file.view;

import org.dom4j.Element;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import wj.ap.util.ModelHelper;

public class TableViewActionHelper {
    private Table table;
    UpAction upAction = new UpAction();
    DownAction downAction = new DownAction();
    Action deleteAction;
    Action createAction;

    public TableViewActionHelper(Table table, Action deleteAction, Action createAction) {
        this.table = table;
        this.deleteAction = deleteAction;
        this.createAction = createAction;
        this.createMenu();
    }

    private void createMenu() {
        MenuManager menuMgr = new MenuManager();
        Menu menu = menuMgr.createContextMenu((Control)this.table);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                TableViewActionHelper.this.addPopMenu(manager, TableViewActionHelper.this.table);
            }
        });
        menuMgr.setRemoveAllWhenShown(true);
        this.table.setMenu(menu);
    }

    private void addPopMenu(IMenuManager manager, Table table) {
        manager.add((IAction)this.upAction);
        manager.add((IAction)this.downAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.deleteAction);
        manager.add((IAction)this.createAction);
        this.upAction.setEnabled(true);
        this.downAction.setEnabled(true);
        this.deleteAction.setEnabled(true);
        if (table.getSelection().length == 0) {
            this.upAction.setEnabled(false);
            this.downAction.setEnabled(false);
            this.deleteAction.setEnabled(false);
            return;
        }
        TableItem item = table.getSelection()[0];
        int index = table.indexOf(item);
        if (index == 0) {
            this.upAction.setEnabled(false);
        } else if (index == table.getItemCount() - 1) {
            this.downAction.setEnabled(false);
        }
    }

    private void move(boolean up) {
        TableItem item = this.table.getSelection()[0];
        String[] textArray = new String[this.table.getColumnCount()];
        int i = 1;
        while (i < textArray.length) {
            textArray[i] = item.getText(i);
            ++i;
        }
        Element element = (Element)item.getData();
        int index = this.table.indexOf(item);
        index = up ? --index : ++index;
        this.table.remove(this.table.indexOf(item));
        item.dispose();
        item = new TableItem(this.table, 0, index);
        textArray[0] = "";
        item.setText(textArray);
        item.setData((Object)element);
        TableItem[] items = this.table.getItems();
        int i2 = 0;
        while (i2 < items.length) {
            element = (Element)items[i2].getData();
            element.attribute("number").setValue(String.valueOf(i2));
            items[i2].setText(0, String.valueOf(i2 + 1));
            ++i2;
        }
        IFile file = ModelHelper.getFileByName(element.getParent().attributeValue("location"));
        ModelHelper.saveDocument(element.getDocument(), file);
    }

    public void createToolItem(ToolBar tb, final IAction action) {
        ToolItem item = new ToolItem(tb, 8);
        item.setText(action.getText());
        item.setToolTipText(action.getToolTipText());
        item.setImage(action.getImageDescriptor().createImage());
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                action.run();
            }
        });
    }

    private class DownAction
    extends Action {
        public DownAction() {
            this.setText("\u4e0b\u79fb");
        }

        public void run() {
            TableViewActionHelper.this.move(false);
        }
    }

    private class UpAction
    extends Action {
        public UpAction() {
            this.setText("\u4e0a\u79fb");
        }

        public void run() {
            TableViewActionHelper.this.move(true);
        }
    }
}

