/*
 * Decompiled with CFR 0.152.
 */
package wj.ap.history;

import java.io.File;
import org.dom4j.Document;
import org.dom4j.Element;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import wj.ap.history.HistoryView;
import wj.ap.textviewer.TextViewer;
import wj.ap.util.ModelHelper;
import wj.ap.util.WJ;

public class HistoryHelper {
    private TextViewer viewer;
    private IFile editorFile;
    private IFile historyFile;
    private Document historyDoc;
    private int preLineCount = -1;
    private String fileId;

    public HistoryHelper(IFile file, TextViewer viewer) {
        this.editorFile = file;
        this.viewer = viewer;
        this.historyFile = ModelHelper.getFileByName(HistoryHelper.getHistoryFileNameByModelFile(file));
        this.historyDoc = ModelHelper.getDocument(this.historyFile);
    }

    public void createSnapshot(int currLineIndex, String words) {
        String id = WJ.getNo();
        if (this.viewer.getTextWidget().getLineCount() != this.preLineCount) {
            HistoryHelper.snapshotModelFile(this.editorFile, id);
            this.preLineCount = this.viewer.getTextWidget().getLineCount();
            this.fileId = id;
        }
        Element snapshot = this.historyDoc.getRootElement().addElement("tns:snapshot");
        snapshot.addAttribute("id", id);
        snapshot.addAttribute("fileId", this.fileId);
        snapshot.addAttribute("createTime", WJ.getCurrTime4yyMMddHHmmss());
        snapshot.addAttribute("words", words);
        snapshot.addAttribute("line", String.valueOf(currLineIndex));
        snapshot.addAttribute("count", String.valueOf(ModelHelper.getWordCount(this.viewer.getTextWidget().getText())));
        snapshot.setText(this.viewer.getTextWidget().getLine(currLineIndex));
        ModelHelper.saveDocument(this.historyDoc, this.historyFile);
        HistoryView historyview = (HistoryView)WJ.getActivePage().findView(HistoryView.class.getName());
        if (historyview != null) {
            historyview.loadItem(this.historyDoc);
        }
    }

    public static void createSnapshot4Import(IFile file, String content) {
        String id = WJ.getNo();
        HistoryHelper.snapshotModelFile(file, id);
        IFile historyFile = ModelHelper.getFileByName(HistoryHelper.getHistoryFileNameByModelFile(file));
        Document historyDoc = ModelHelper.getDocument(historyFile);
        Element snapshot = historyDoc.getRootElement().addElement("tns:snapshot");
        snapshot.addAttribute("id", id);
        snapshot.addAttribute("fileId", id);
        snapshot.addAttribute("createTime", WJ.getCurrTime4yyMMddHHmmss());
        snapshot.addAttribute("version", "false");
        snapshot.addAttribute("line", "-1");
        snapshot.addAttribute("words", "");
        snapshot.addAttribute("count", String.valueOf(ModelHelper.getWordCount(content)));
        snapshot.setText("");
        ModelHelper.saveDocument(historyDoc, historyFile);
    }

    public static Document getSnapshotFileDocument(IFile modelFile, String snapshotFileName) {
        IFile file = ModelHelper.getProject().getFile(String.valueOf(ModelHelper.getAdditionFolder(modelFile)) + File.separator + snapshotFileName);
        return ModelHelper.getDocument(file);
    }

    public static String getHistoryFileNameByModelFile(IFile modelFile) {
        String historyFileName = String.valueOf(ModelHelper.getAdditionFolder(modelFile)) + File.separator + "history.xml";
        return historyFileName;
    }

    private static void snapshotModelFile(IFile modelFile, String snapshotFileName) {
        IProject project = ModelHelper.getProject();
        IFile file = project.getFile(String.valueOf(ModelHelper.getAdditionFolder(modelFile)) + File.separator + snapshotFileName);
        try {
            ModelHelper.fillFile(file, modelFile.getContents());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }
}

