/*
 * Decompiled with CFR 0.152.
 */
package wj.ap.history;

import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;
import wj.ap.history.HistoryHelper;
import wj.ap.history.IHistory;
import wj.ap.sys.Activator;
import wj.ap.textviewer.TextViewer;
import wj.ap.util.ModelHelper;
import wj.ap.util.TreeViewHelper;
import wj.ap.util.WJ;

public class HistoryView
extends ViewPart
implements IPropertyChangeListener {
    private Composite parent;
    private Tree tree;
    private String snapshotFileVision = "";
    private IHistory currEditor;
    private TreeViewHelper treeViewHelper;

    public void createPartControl(Composite parent) {
        this.parent = parent;
        this.createTree();
        this.initItem();
        this.addPartListener();
        this.setTitleToolTip("\u65f6\u5149\u673a");
        Activator.getDefault().addPropertyChangeListener(this);
        this.addActionButton();
    }

    private void createTree() {
        this.tree = new Tree(this.parent, 68356);
        this.tree.setHeaderVisible(true);
        this.tree.setLinesVisible(true);
        this.createColumn();
        this.addListener();
    }

    private void initItem() {
        IEditorPart part = WJ.getActivePage().getActiveEditor();
        if (part != null && part instanceof IHistory) {
            this.loginEditor((IWorkbenchPart)part);
        }
    }

    private void addListener() {
        this.tree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Element selectElement = (Element)HistoryView.this.tree.getSelection()[0].getData();
                HistoryView.this.changeVersion(selectElement);
            }
        });
        final Color red = this.tree.getDisplay().getSystemColor(3);
        final Color yellow = this.tree.getDisplay().getSystemColor(7);
        this.tree.addListener(40, new Listener(){

            public void handleEvent(Event event) {
                event.detail &= 0xFFFFFFDF;
                if ((event.detail & 2) == 0) {
                    return;
                }
                int clientWidth = ((HistoryView)HistoryView.this).tree.getClientArea().width;
                GC gc = event.gc;
                Color oldForeground = gc.getForeground();
                Color oldBackground = gc.getBackground();
                gc.setForeground(red);
                gc.setBackground(yellow);
                gc.fillGradientRectangle(0, event.y, clientWidth, event.height, false);
                gc.setForeground(oldForeground);
                gc.setBackground(oldBackground);
                event.detail &= 0xFFFFFFFD;
            }
        });
        this.tree.addMouseWheelListener(new MouseWheelListener(){

            public void mouseScrolled(MouseEvent e) {
                Event event = new Event();
                event.type = 1;
                event.keyCode = e.count > 0 ? 0x1000001 : 0x1000002;
                HistoryView.this.tree.getDisplay().post(event);
            }
        });
        this.tree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                TreeItem item;
                if (HistoryView.this.tree.getSelectionCount() == 0) {
                    return;
                }
                item.setExpanded(!(item = HistoryView.this.tree.getSelection()[0]).getExpanded());
            }
        });
    }

    private void changeVersion(Element snapshotElement) {
        if (this.currEditor == null) {
            return;
        }
        TextViewer textViewer = this.currEditor.getTextViewer();
        textViewer.setSnapshotEnable(false);
        StyledText styledText = textViewer.getTextWidget();
        if (styledText == null) {
            return;
        }
        if (!snapshotElement.attributeValue("fileId").equals(this.snapshotFileVision)) {
            this.snapshotFileVision = snapshotElement.attributeValue("fileId");
            Document snapshotDoc = HistoryHelper.getSnapshotFileDocument(this.currEditor.getModelFile4History(), this.snapshotFileVision);
            String content = ModelHelper.getContent(snapshotDoc);
            textViewer.getTextWidget().setText(content);
        }
        String lineTxt = snapshotElement.getText();
        int lineNo = Integer.parseInt(snapshotElement.attributeValue("line"));
        if (lineNo != -1) {
            int start = styledText.getOffsetAtLine(lineNo);
            int length = styledText.getLine(lineNo).length();
            styledText.replaceTextRange(start, length, lineTxt);
            styledText.setSelection(start, start + styledText.getLine(lineNo).length());
            styledText.showSelection();
        }
        textViewer.setSnapshotEnable(true);
    }

    public void loadItem(Document historyDoc) {
        this.tree.removeAll();
        if (historyDoc == null) {
            return;
        }
        List snapshots = historyDoc.getRootElement().elements("snapshot");
        String currDay = "";
        String currHour = "";
        String currMinute = "";
        TreeItem dayItem = null;
        TreeItem hourItem = null;
        TreeItem minuteItem = null;
        int No = 1;
        for (Element snapshot : snapshots) {
            String time = snapshot.attributeValue("createTime");
            String day = time.substring(0, 6);
            String hour = time.substring(6, 8);
            String minute = time.substring(8, 10);
            if (day.equals(currDay)) {
                if (hour.equals(currHour)) {
                    if (minute.equals(currMinute)) {
                        TreeItem item = new TreeItem(minuteItem, 0);
                        item.setText(0, String.valueOf(No));
                        item.setText(1, snapshot.attributeValue("count"));
                        item.setText(2, snapshot.attributeValue("words"));
                        item.setData((Object)snapshot);
                        ++No;
                        continue;
                    }
                    No = 1;
                    currMinute = minute;
                    minuteItem = new TreeItem(hourItem, 0);
                    minuteItem.setText(0, String.valueOf(minute) + "\u5206");
                    minuteItem.setText(1, snapshot.attributeValue("count"));
                    minuteItem.setText(2, snapshot.attributeValue("words"));
                    minuteItem.setData((Object)snapshot);
                    continue;
                }
                currHour = hour;
                hourItem = new TreeItem(dayItem, 0);
                hourItem.setText(0, String.valueOf(hour) + "\u65f6");
                hourItem.setText(1, snapshot.attributeValue("count"));
                hourItem.setText(2, snapshot.attributeValue("words"));
                hourItem.setData((Object)snapshot);
                continue;
            }
            currDay = day;
            dayItem = new TreeItem(this.tree, 0);
            dayItem.setText(0, "20" + day.substring(0, 2) + "\u5e74" + day.substring(2, 4) + "\u6708" + day.substring(4, 6) + "\u65e5");
            dayItem.setText(1, snapshot.attributeValue("count"));
            dayItem.setText(2, snapshot.attributeValue("words"));
            dayItem.setData((Object)snapshot);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        IFile file;
        if (event.getProperty().equals("eventDeleteExplorerNode") && ((file = this.currEditor.getModelFile4History()) == null || !file.exists())) {
            this.loadItem(null);
        }
    }

    private void createColumn() {
        TreeColumn column1 = new TreeColumn(this.tree, 16384);
        column1.setText("\u65f6\u95f4");
        column1.setWidth(120);
        TreeColumn column2 = new TreeColumn(this.tree, 0x1000000);
        column2.setText("\u5b57\u6570");
        column2.setWidth(50);
        TreeColumn column3 = new TreeColumn(this.tree, 16384);
        column3.setText("\u5b57\u7b26");
        column3.setWidth(50);
    }

    private void loginEditor(IWorkbenchPart part) {
        if (!(part instanceof IHistory)) {
            return;
        }
        IHistory editor = (IHistory)part;
        if (editor.equals(this.currEditor)) {
            return;
        }
        this.snapshotFileVision = "";
        this.currEditor = editor;
        IFile newFile = this.currEditor.getModelFile4History();
        Document historDoc = ModelHelper.getDocument(HistoryHelper.getHistoryFileNameByModelFile(newFile));
        this.loadItem(historDoc);
    }

    private void addPartListener() {
        this.getViewSite().getPage().addPartListener(new IPartListener(){

            public void partOpened(IWorkbenchPart part) {
            }

            public void partDeactivated(IWorkbenchPart part) {
            }

            public void partClosed(IWorkbenchPart part) {
            }

            public void partBroughtToTop(IWorkbenchPart part) {
                HistoryView.this.loginEditor(part);
            }

            public void partActivated(IWorkbenchPart part) {
                HistoryView.this.loginEditor(part);
            }
        });
    }

    private void addActionButton() {
        this.treeViewHelper = new TreeViewHelper(this.tree);
        IToolBarManager tbm = this.getViewSite().getActionBars().getToolBarManager();
        tbm.add(this.treeViewHelper.getExpandByDayAction());
        tbm.add(this.treeViewHelper.getExpandByHourAction());
        tbm.add(this.treeViewHelper.getExpandByMinAction());
        tbm.add(this.treeViewHelper.getExpandByTimeAction());
    }

    public void setFocus() {
    }

    public void dispose() {
    }
}

