/*
 * Decompiled with CFR 0.152.
 */
package wj.ap.importexport;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfGState;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfStamper;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import wj.ap.explorer.ExplorerHelper;
import wj.ap.explorer.ExplorerModelHelper;
import wj.ap.file.editor.TagHelper;
import wj.ap.util.ModelHelper;

public class ExportHelper {
    private static String newLine = System.getProperty("line.separator");

    public static void export(Map<String, String> inputMap) {
        String storyId = inputMap.get("storyId");
        String exportPath = String.valueOf(inputMap.get("dir")) + File.separator + inputMap.get("storyName");
        String fileType = inputMap.get("fileType");
        String exportType = inputMap.get("exportType");
        String singleOrMulti = inputMap.get("single");
        File path = new File(exportPath);
        if (!path.exists()) {
            path.mkdir();
        }
        if (fileType.equals("theme")) {
            if (exportType.equals("txt")) {
                ExportHelper.exportTxt4Theme(storyId, exportPath);
            } else if (exportType.equals("pdf")) {
                ExportHelper.exportPdf4Theme(storyId, exportPath);
            }
        } else if (fileType.equals("roles")) {
            if (exportType.equals("txt")) {
                if (singleOrMulti.equals("single")) {
                    ExportHelper.exportSingleTxt4Roles(storyId, exportPath);
                } else {
                    ExportHelper.exportMultiTxt4Roles(storyId, exportPath);
                }
            } else if (exportType.equals("pdf")) {
                if (singleOrMulti.equals("single")) {
                    ExportHelper.exportSinglePdf4Roles(storyId, exportPath);
                } else {
                    ExportHelper.exportMultiPdf4Roles(storyId, exportPath);
                }
            }
        } else if (fileType.equals("storylines")) {
            if (exportType.equals("txt")) {
                if (singleOrMulti.equals("single")) {
                    ExportHelper.exportSingleTxt4Storylines(storyId, exportPath);
                } else {
                    ExportHelper.exportMultiTxt4Storylines(storyId, exportPath);
                }
            } else if (exportType.equals("pdf")) {
                if (singleOrMulti.equals("single")) {
                    ExportHelper.exportSinglePdf4Storylines(storyId, exportPath);
                } else {
                    ExportHelper.exportMultiPdf4Storylines(storyId, exportPath);
                }
            }
        } else if (fileType.equals("chapter")) {
            if (exportType.equals("txt")) {
                if (singleOrMulti.equals("single")) {
                    ExportHelper.exportSingleTxt4Chapter(storyId, exportPath);
                } else {
                    ExportHelper.exportMultiTxt4Chapter(storyId, exportPath);
                }
            } else if (exportType.equals("pdf")) {
                if (singleOrMulti.equals("single")) {
                    ExportHelper.exportSinglePdf4Chapter(storyId, exportPath);
                } else {
                    ExportHelper.exportMultiPdf4Chapter(storyId, exportPath);
                }
            }
        } else if (fileType.equals("note")) {
            if (exportType.equals("txt")) {
                if (singleOrMulti.equals("single")) {
                    ExportHelper.exportSingleTxt4Note(storyId, exportPath);
                } else {
                    ExportHelper.exportMultiTxt4Note(storyId, exportPath);
                }
            } else if (exportType.equals("pdf")) {
                if (singleOrMulti.equals("single")) {
                    ExportHelper.exportSinglePdf4Note(storyId, exportPath);
                } else {
                    ExportHelper.exportMultiPdf4Note(storyId, exportPath);
                }
            }
        }
    }

    private static void exportTxt4Theme(String storyId, String exportPath) {
        Document themeDoc = ModelHelper.getDocument(ModelHelper.getFileByName(ExplorerHelper.getOutlineFilePath(storyId, "theme")));
        org.dom4j.Element storyNode = ExplorerModelHelper.getElement(storyId);
        String path = String.valueOf(exportPath) + File.separator + storyNode.attributeValue("name") + "-\u4e3b\u9898\u5927\u7eb2.txt";
        ExportHelper.exportTxt(path, "\u4e3b\u9898", ExportHelper.formatContent(ModelHelper.getContent(themeDoc)));
    }

    private static void exportPdf4Theme(String storyId, String exportPath) {
        org.dom4j.Element storyNode = ExplorerModelHelper.getElement(storyId);
        ArrayList<String[]> themeList = new ArrayList<String[]>(1);
        String[] themeArray = new String[2];
        themeArray[0] = "\u4e3b\u9898\u5927\u7eb2";
        Document themeDoc = ModelHelper.getDocument(ModelHelper.getFileByName(ExplorerHelper.getOutlineFilePath(storyId, "theme")));
        themeArray[1] = ExportHelper.formatContent(ModelHelper.getContent(themeDoc));
        themeList.add(themeArray);
        ExportHelper.exportPdf(storyId, exportPath, String.valueOf(storyNode.attributeValue("name")) + "-\u4e3b\u9898\u5927\u7eb2", themeList);
    }

    private static void exportMultiTxt4Roles(String storyId, String exportPath) {
        org.dom4j.Element storyNode = ExplorerModelHelper.getElement(storyId);
        String roleRootPath = String.valueOf(exportPath) + File.separator + storyNode.attributeValue("name") + "-\u89d2\u8272\u5927\u7eb2";
        new File(roleRootPath).mkdir();
        Document rolesDoc = ModelHelper.getDocument(ModelHelper.getFileByName(ExplorerHelper.getOutlineFilePath(storyId, "roles")));
        List roleList = rolesDoc.getRootElement().elements();
        for (org.dom4j.Element roleInMom : roleList) {
            org.dom4j.Element roleRootElement = ModelHelper.getDocument(ModelHelper.getFileByName(roleInMom.attributeValue("location"))).getRootElement();
            StringBuilder sb = new StringBuilder();
            List<org.dom4j.Element> tagList = TagHelper.getCheckedTags("role");
            for (org.dom4j.Element tag : tagList) {
                org.dom4j.Element roleTag = TagHelper.getTagById(roleRootElement, tag.attributeValue("id"));
                if (roleTag == null) continue;
                sb.append("\t").append(roleTag.attributeValue("name")).append("\uff1a").append(roleTag.getText()).append(newLine);
            }
            sb.append(ExportHelper.formatContent(roleRootElement.elementText("description")));
            String rolePath = String.valueOf(roleRootPath) + File.separator + roleRootElement.elementText("name") + ".txt";
            ExportHelper.exportTxt(rolePath, roleRootElement.elementText("name"), sb.toString());
        }
    }

    private static void exportSingleTxt4Roles(String storyId, String exportPath) {
        org.dom4j.Element storyNode = ExplorerModelHelper.getElement(storyId);
        String rolePath = String.valueOf(exportPath) + File.separator + storyNode.attributeValue("name") + "-\u89d2\u8272\u5927\u7eb2.txt";
        Document rolesDoc = ModelHelper.getDocument(ModelHelper.getFileByName(ExplorerHelper.getOutlineFilePath(storyId, "roles")));
        List roleList = rolesDoc.getRootElement().elements();
        StringBuilder sb = new StringBuilder(newLine);
        for (org.dom4j.Element roleInMom : roleList) {
            org.dom4j.Element roleRootElement = ModelHelper.getDocument(ModelHelper.getFileByName(roleInMom.attributeValue("location"))).getRootElement();
            sb.append("\t").append(roleRootElement.elementText("name")).append(newLine);
            List<org.dom4j.Element> tagList = TagHelper.getCheckedTags("role");
            for (org.dom4j.Element tag : tagList) {
                org.dom4j.Element roleTag = TagHelper.getTagById(roleRootElement, tag.attributeValue("id"));
                if (roleTag == null) continue;
                sb.append("\t").append(roleTag.attributeValue("name")).append("\uff1a").append(roleTag.getText()).append(newLine);
            }
            sb.append(ExportHelper.formatContent(roleRootElement.elementText("description"))).append(newLine);
        }
        ExportHelper.exportTxt(rolePath, "\u89d2\u8272\u5217\u8868", sb.toString());
    }

    private static void exportMultiPdf4Roles(String storyId, String exportPath) {
        org.dom4j.Element storyNode = ExplorerModelHelper.getElement(storyId);
        String roleRootPath = String.valueOf(exportPath) + File.separator + storyNode.attributeValue("name") + "-\u89d2\u8272\u5927\u7eb2";
        new File(roleRootPath).mkdir();
        Document rolesDoc = ModelHelper.getDocument(ModelHelper.getFileByName(ExplorerHelper.getOutlineFilePath(storyId, "roles")));
        List roleList = rolesDoc.getRootElement().elements();
        for (org.dom4j.Element roleInMom : roleList) {
            org.dom4j.Element roleRootElement = ModelHelper.getDocument(ModelHelper.getFileByName(roleInMom.attributeValue("location"))).getRootElement();
            StringBuilder sb = new StringBuilder();
            List<org.dom4j.Element> tagList = TagHelper.getCheckedTags("role");
            for (org.dom4j.Element tag : tagList) {
                org.dom4j.Element roleTag = TagHelper.getTagById(roleRootElement, tag.attributeValue("id"));
                if (roleTag == null) continue;
                sb.append("\t").append(roleTag.attributeValue("name")).append("\uff1a").append(roleTag.getText()).append(newLine);
            }
            sb.append(ExportHelper.formatContent(roleRootElement.elementText("description")));
            ArrayList<String[]> list = new ArrayList<String[]>(1);
            String[] array = new String[]{roleRootElement.elementText("name"), sb.toString()};
            list.add(array);
            ExportHelper.exportPdf(storyId, roleRootPath, roleRootElement.elementText("name"), list);
        }
    }

    private static void exportSinglePdf4Roles(String storyId, String exportPath) {
        org.dom4j.Element storyNode = ExplorerModelHelper.getElement(storyId);
        Document rolesDoc = ModelHelper.getDocument(ModelHelper.getFileByName(ExplorerHelper.getOutlineFilePath(storyId, "roles")));
        List roleList = rolesDoc.getRootElement().elements();
        ArrayList<String[]> list = new ArrayList<String[]>(roleList.size());
        for (org.dom4j.Element roleInMom : roleList) {
            StringBuilder sb = new StringBuilder(newLine);
            org.dom4j.Element roleRootElement = ModelHelper.getDocument(ModelHelper.getFileByName(roleInMom.attributeValue("location"))).getRootElement();
            List<org.dom4j.Element> tagList = TagHelper.getCheckedTags("role");
            for (org.dom4j.Element tag : tagList) {
                org.dom4j.Element roleTag = TagHelper.getTagById(roleRootElement, tag.attributeValue("id"));
                if (roleTag == null) continue;
                sb.append("\t").append(roleTag.attributeValue("name")).append("\uff1a").append(roleTag.getText()).append(newLine);
            }
            sb.append(ExportHelper.formatContent(roleRootElement.elementText("description"))).append(newLine);
            String[] array = new String[]{roleRootElement.elementText("name"), sb.toString()};
            list.add(array);
        }
        ExportHelper.exportPdf(storyId, exportPath, String.valueOf(storyNode.attributeValue("name")) + "-\u89d2\u8272\u5927\u7eb2", list);
    }

    private static void exportMultiTxt4Storylines(String storyId, String exportPath) {
        org.dom4j.Element storyNode = ExplorerModelHelper.getElement(storyId);
        String roleRootPath = String.valueOf(exportPath) + File.separator + storyNode.attributeValue("name") + "-\u60c5\u8282\u5927\u7eb2";
        new File(roleRootPath).mkdir();
        Document storylinesDoc = ModelHelper.getDocument(ModelHelper.getFileByName(ExplorerHelper.getOutlineFilePath(storyId, "storylines")));
        List storylinesList = storylinesDoc.getRootElement().elements();
        for (org.dom4j.Element storylineInMom : storylinesList) {
            org.dom4j.Element storylineRootElement = ModelHelper.getDocument(ModelHelper.getFileByName(storylineInMom.attributeValue("location"))).getRootElement();
            StringBuilder sb = new StringBuilder();
            sb.append(ExportHelper.formatContent(storylineRootElement.elementText("description")));
            String path = String.valueOf(roleRootPath) + File.separator + storylineRootElement.elementText("name") + ".txt";
            ExportHelper.exportTxt(path, storylineRootElement.elementText("name"), sb.toString());
        }
    }

    private static void exportSingleTxt4Storylines(String storyId, String exportPath) {
        org.dom4j.Element storyNode = ExplorerModelHelper.getElement(storyId);
        String path = String.valueOf(exportPath) + File.separator + storyNode.attributeValue("name") + "-\u60c5\u8282\u5927\u7eb2.txt";
        Document storylinesDoc = ModelHelper.getDocument(ModelHelper.getFileByName(ExplorerHelper.getOutlineFilePath(storyId, "storylines")));
        List storylinesList = storylinesDoc.getRootElement().elements();
        StringBuilder sb = new StringBuilder();
        for (org.dom4j.Element storylineInMom : storylinesList) {
            org.dom4j.Element rootElement = ModelHelper.getDocument(ModelHelper.getFileByName(storylineInMom.attributeValue("location"))).getRootElement();
            sb.append("\t").append(rootElement.elementText("name")).append(newLine);
            sb.append(ExportHelper.formatContent(rootElement.elementText("description"))).append(newLine);
        }
        ExportHelper.exportTxt(path, "\u60c5\u8282", sb.toString());
    }

    private static void exportMultiPdf4Storylines(String storyId, String exportPath) {
        org.dom4j.Element storyNode = ExplorerModelHelper.getElement(storyId);
        String path = String.valueOf(exportPath) + File.separator + storyNode.attributeValue("name") + "-\u60c5\u8282\u5927\u7eb2";
        new File(path).mkdir();
        Document storylinesDoc = ModelHelper.getDocument(ModelHelper.getFileByName(ExplorerHelper.getOutlineFilePath(storyId, "storylines")));
        List storylinesList = storylinesDoc.getRootElement().elements();
        for (org.dom4j.Element storylineInMom : storylinesList) {
            org.dom4j.Element storylineRootElement = ModelHelper.getDocument(ModelHelper.getFileByName(storylineInMom.attributeValue("location"))).getRootElement();
            StringBuilder sb = new StringBuilder();
            sb.append(ExportHelper.formatContent(storylineRootElement.elementText("description")));
            ArrayList<String[]> list = new ArrayList<String[]>(1);
            String[] array = new String[]{storylineRootElement.elementText("name"), sb.toString()};
            list.add(array);
            ExportHelper.exportPdf(storyId, path, storylineRootElement.elementText("name"), list);
        }
    }

    private static void exportSinglePdf4Storylines(String storyId, String exportPath) {
        org.dom4j.Element storyNode = ExplorerModelHelper.getElement(storyId);
        Document storylinesDoc = ModelHelper.getDocument(ModelHelper.getFileByName(ExplorerHelper.getOutlineFilePath(storyId, "storylines")));
        List storylinesList = storylinesDoc.getRootElement().elements();
        ArrayList<String[]> list = new ArrayList<String[]>(storylinesList.size());
        for (org.dom4j.Element storylineInMom : storylinesList) {
            StringBuilder sb = new StringBuilder();
            org.dom4j.Element rootElement = ModelHelper.getDocument(ModelHelper.getFileByName(storylineInMom.attributeValue("location"))).getRootElement();
            sb.append(ExportHelper.formatContent(rootElement.elementText("description"))).append(newLine);
            String[] array = new String[]{rootElement.elementText("name"), sb.toString()};
            list.add(array);
        }
        ExportHelper.exportPdf(storyId, exportPath, String.valueOf(storyNode.attributeValue("name")) + "-\u60c5\u8282\u5927\u7eb2", list);
    }

    private static void exportMultiTxt4Chapter(String storyId, String exportPath) {
        org.dom4j.Element storyNode = ExplorerModelHelper.getElement(storyId);
        String rootPath = String.valueOf(exportPath) + File.separator + storyNode.attributeValue("name") + "-\u7ae0\u8282";
        new File(rootPath).mkdir();
        List folderList = storyNode.selectNodes("./tns:chapterFolder");
        for (org.dom4j.Element folderNode : folderList) {
            List fileList = folderNode.selectNodes("./tns:chapter", "@no");
            Collections.reverse(fileList);
            for (org.dom4j.Element fileNode : fileList) {
                String filePath = String.valueOf(rootPath) + File.separator + fileNode.attributeValue("name") + ".txt";
                Document doc = ModelHelper.getDocument(ModelHelper.getFileByName(fileNode.attributeValue("location")));
                String content = ExportHelper.formatContent(ModelHelper.getContent(doc));
                ExportHelper.exportTxt(filePath, fileNode.attributeValue("name"), content);
            }
        }
    }

    private static void exportSingleTxt4Chapter(String storyId, String exportPath) {
        org.dom4j.Element storyNode = ExplorerModelHelper.getElement(storyId);
        String rootPath = String.valueOf(exportPath) + File.separator + storyNode.attributeValue("name") + "-\u7ae0\u8282.txt";
        List folderList = storyNode.selectNodes("./tns:chapterFolder");
        StringBuilder sb = new StringBuilder();
        for (org.dom4j.Element folderNode : folderList) {
            List fileList = folderNode.selectNodes("./tns:chapter", "@no");
            Collections.reverse(fileList);
            for (org.dom4j.Element fileNode : fileList) {
                sb.append("\t").append(fileNode.attributeValue("name")).append(newLine);
                Document doc = ModelHelper.getDocument(ModelHelper.getFileByName(fileNode.attributeValue("location")));
                sb.append(ExportHelper.formatContent(ModelHelper.getContent(doc)));
            }
        }
        ExportHelper.exportTxt(rootPath, storyNode.attributeValue("name"), sb.toString());
    }

    private static void exportMultiPdf4Chapter(String storyId, String exportPath) {
        org.dom4j.Element storyNode = ExplorerModelHelper.getElement(storyId);
        String rootPath = String.valueOf(exportPath) + File.separator + storyNode.attributeValue("name") + "-\u7ae0\u8282";
        new File(rootPath).mkdir();
        List folderList = storyNode.selectNodes("./tns:chapterFolder");
        for (org.dom4j.Element folderNode : folderList) {
            List fileList = folderNode.selectNodes("./tns:chapter", "@no");
            Collections.reverse(fileList);
            for (org.dom4j.Element fileNode : fileList) {
                Document doc = ModelHelper.getDocument(ModelHelper.getFileByName(fileNode.attributeValue("location")));
                String content = ExportHelper.formatContent(ModelHelper.getContent(doc));
                ArrayList<String[]> list = new ArrayList<String[]>(1);
                String[] array = new String[]{fileNode.attributeValue("name"), content};
                list.add(array);
                ExportHelper.exportPdf(storyId, rootPath, fileNode.attributeValue("name"), list);
            }
        }
    }

    private static void exportSinglePdf4Chapter(String storyId, String exportPath) {
        org.dom4j.Element storyNode = ExplorerModelHelper.getElement(storyId);
        List folderList = storyNode.selectNodes("./tns:chapterFolder");
        ArrayList<String[]> list = new ArrayList<String[]>();
        for (org.dom4j.Element folderNode : folderList) {
            List fileList = folderNode.selectNodes("./tns:chapter", "@no");
            Collections.reverse(fileList);
            for (org.dom4j.Element fileNode : fileList) {
                Document doc = ModelHelper.getDocument(ModelHelper.getFileByName(fileNode.attributeValue("location")));
                String[] array = new String[]{fileNode.attributeValue("name"), ExportHelper.formatContent(ModelHelper.getContent(doc))};
                list.add(array);
            }
        }
        ExportHelper.exportPdf(storyId, exportPath, String.valueOf(storyNode.attributeValue("name")) + "-\u7ae0\u8282", list);
    }

    private static void exportMultiTxt4Note(String storyId, String exportPath) {
        org.dom4j.Element storyNode = ExplorerModelHelper.getElement(storyId);
        String rootPath = String.valueOf(exportPath) + File.separator + storyNode.attributeValue("name") + "-\u7d20\u6750";
        new File(rootPath).mkdir();
        List fileList = null;
        if (storyNode.getName().equals("essay")) {
            fileList = storyNode.selectNodes("./tns:note", "@no");
        } else if (storyNode.getName().equals("novel")) {
            org.dom4j.Element folder = (org.dom4j.Element)storyNode.selectSingleNode("./tns:noteFolder");
            fileList = folder.selectNodes("./tns:note", "@no");
        }
        Collections.reverse(fileList);
        for (org.dom4j.Element fileNode : fileList) {
            String filePath = String.valueOf(rootPath) + File.separator + fileNode.attributeValue("name") + ".txt";
            Document doc = ModelHelper.getDocument(ModelHelper.getFileByName(fileNode.attributeValue("location")));
            String content = ExportHelper.formatContent(ModelHelper.getContent(doc));
            ExportHelper.exportTxt(filePath, fileNode.attributeValue("name"), content);
        }
    }

    private static void exportSingleTxt4Note(String storyId, String exportPath) {
        org.dom4j.Element storyNode = ExplorerModelHelper.getElement(storyId);
        String rootPath = String.valueOf(exportPath) + File.separator + storyNode.attributeValue("name") + "-\u7d20\u6750.txt";
        List fileList = null;
        if (storyNode.getName().equals("essay")) {
            fileList = storyNode.selectNodes("./tns:note", "@no");
        } else if (storyNode.getName().equals("novel")) {
            org.dom4j.Element folder = (org.dom4j.Element)storyNode.selectSingleNode("./tns:noteFolder");
            fileList = folder.selectNodes("./tns:note", "@no");
        }
        StringBuilder sb = new StringBuilder();
        Collections.reverse(fileList);
        for (org.dom4j.Element fileNode : fileList) {
            sb.append("\t").append(fileNode.attributeValue("name")).append(newLine);
            Document doc = ModelHelper.getDocument(ModelHelper.getFileByName(fileNode.attributeValue("location")));
            sb.append(ExportHelper.formatContent(ModelHelper.getContent(doc)));
        }
        ExportHelper.exportTxt(rootPath, storyNode.attributeValue("name"), sb.toString());
    }

    private static void exportMultiPdf4Note(String storyId, String exportPath) {
        org.dom4j.Element storyNode = ExplorerModelHelper.getElement(storyId);
        String rootPath = String.valueOf(exportPath) + File.separator + storyNode.attributeValue("name") + "-\u7d20\u6750";
        new File(rootPath).mkdir();
        List fileList = null;
        if (storyNode.getName().equals("essay")) {
            fileList = storyNode.selectNodes("./tns:note", "@no");
        } else if (storyNode.getName().equals("novel")) {
            org.dom4j.Element folder = (org.dom4j.Element)storyNode.selectSingleNode("./tns:noteFolder");
            fileList = folder.selectNodes("./tns:note", "@no");
        }
        Collections.reverse(fileList);
        for (org.dom4j.Element fileNode : fileList) {
            Document doc = ModelHelper.getDocument(ModelHelper.getFileByName(fileNode.attributeValue("location")));
            String content = ExportHelper.formatContent(ModelHelper.getContent(doc));
            ArrayList<String[]> list = new ArrayList<String[]>(1);
            String[] array = new String[]{fileNode.attributeValue("name"), content};
            list.add(array);
            ExportHelper.exportPdf(storyId, rootPath, fileNode.attributeValue("name"), list);
        }
    }

    private static void exportSinglePdf4Note(String storyId, String exportPath) {
        org.dom4j.Element storyNode = ExplorerModelHelper.getElement(storyId);
        List fileList = null;
        if (storyNode.getName().equals("essay")) {
            fileList = storyNode.selectNodes("./tns:note", "@no");
        } else if (storyNode.getName().equals("novel")) {
            org.dom4j.Element folder = (org.dom4j.Element)storyNode.selectSingleNode("./tns:noteFolder");
            fileList = folder.selectNodes("./tns:note", "@no");
        }
        ArrayList<String[]> list = new ArrayList<String[]>();
        Collections.reverse(fileList);
        for (org.dom4j.Element fileNode : fileList) {
            Document doc = ModelHelper.getDocument(ModelHelper.getFileByName(fileNode.attributeValue("location")));
            String[] array = new String[]{fileNode.attributeValue("name"), ExportHelper.formatContent(ModelHelper.getContent(doc))};
            list.add(array);
        }
        ExportHelper.exportPdf(storyId, exportPath, String.valueOf(storyNode.attributeValue("name")) + "-\u7d20\u6750", list);
    }

    private static void exportPdf(String storyId, String exportPath, String fileName, List<String[]> itemList) {
        int i;
        String exportFileName;
        block11: {
            exportFileName = String.valueOf(exportPath) + File.separator + fileName + "_.pdf";
            com.itextpdf.text.Document doc = new com.itextpdf.text.Document(PageSize.A4);
            doc.addTitle(fileName);
            doc.addAuthor("bookchao");
            doc.addCreator("\u8bfb\u5de2www.bookchao.com");
            try {
                try {
                    BaseFont bfChinese = BaseFont.createFont((String)"STSongStd-Light", (String)"UniGB-UCS2-H", (boolean)true);
                    Font fontChinese = new Font(bfChinese, 12.0f, 0, BaseColor.BLACK);
                    PdfWriter.getInstance((com.itextpdf.text.Document)doc, (OutputStream)new FileOutputStream(exportFileName));
                    doc.open();
                    for (String[] chapter : itemList) {
                        Paragraph titleParagraph = new Paragraph(chapter[0], fontChinese);
                        titleParagraph.setAlignment(1);
                        doc.add((Element)titleParagraph);
                        String[] lines = chapter[1].split("\n");
                        i = 0;
                        while (i < lines.length) {
                            String line = lines[i].trim();
                            if (!line.equals("")) {
                                Paragraph lineParagraph = new Paragraph(line, fontChinese);
                                lineParagraph.setFirstLineIndent(25.0f);
                                lineParagraph.setSpacingBefore(8.0f);
                                doc.add((Element)lineParagraph);
                            }
                            ++i;
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    doc.close();
                    break block11;
                }
            }
            catch (Throwable throwable) {
                doc.close();
                throw throwable;
            }
            doc.close();
        }
        try {
            String exportFileNameWithWaterMark = String.valueOf(exportPath) + File.separator + fileName + ".pdf";
            BaseFont bfChinese = BaseFont.createFont((String)"STSongStd-Light", (String)"UniGB-UCS2-H", (boolean)true);
            PdfReader reader = new PdfReader(exportFileName);
            int pdfFileTotalPages = reader.getNumberOfPages() + 1;
            PdfStamper pdfStamper = new PdfStamper(reader, (OutputStream)new FileOutputStream(exportFileNameWithWaterMark));
            PdfContentByte underPdfContent = null;
            i = 1;
            while (i < pdfFileTotalPages) {
                float pageWidth = reader.getPageSize(i).getWidth();
                float pageHeight = reader.getPageSize(i).getHeight();
                underPdfContent = pdfStamper.getUnderContent(i);
                underPdfContent.beginText();
                underPdfContent.setColorFill(BaseColor.BLACK);
                underPdfContent.setFontAndSize(bfChinese, 12.0f);
                underPdfContent.showTextAligned(0, "www.bookchao.com", pageWidth * 0.4f, pageHeight * 0.4f, 30.0f);
                underPdfContent.endText();
                PdfGState gs = new PdfGState();
                gs.setFillOpacity(0.5f);
                underPdfContent.setGState(gs);
                ++i;
            }
            pdfStamper.close();
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        File file = new File(exportFileName);
        file.delete();
    }

    private static String formatContent(String txt) {
        StringBuilder sb = new StringBuilder();
        String[] parts = txt.split("\n");
        int i = 0;
        while (i < parts.length) {
            if (!parts[i].trim().equals("")) {
                sb.append("    ").append(parts[i].trim()).append(newLine);
            }
            ++i;
        }
        return sb.toString();
    }

    private static void exportTxt(String filePath, String title, String content) {
        StringBuilder sb = new StringBuilder();
        sb.append("\t" + title);
        sb.append(newLine);
        sb.append(content);
        try {
            FileOutputStream fos = new FileOutputStream(filePath);
            fos.write(sb.toString().getBytes());
            fos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

