/*
 * Decompiled with CFR 0.152.
 */
package wj.ap.importexport;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.poi.POIXMLDocument;
import org.apache.poi.hwpf.extractor.WordExtractor;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.xwpf.extractor.XWPFWordExtractor;
import org.dom4j.Element;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ProgressBar;
import wj.ap.action.CreateNodeFileHelper;
import wj.ap.explorer.ExplorerModelHelper;
import wj.ap.explorer.ExplorerView;
import wj.ap.history.HistoryHelper;
import wj.ap.search.IndexService;
import wj.ap.sys.Activator;
import wj.ap.textviewer.KeywordsHelper;
import wj.ap.util.ModelHelper;
import wj.ap.util.WJ;

public class ImportHelper {
    private static Pattern patternTitle = Pattern.compile("^((.{0,8}\u7b2c\\s{0,4}\\S{1,7}\\s{0,4}[\u7ae0|\u56de|\u96c6|\u5219]\\s{0,4}.{0,20})|(\u6954\u5b50))$");
    private static Pattern patternCatalog = Pattern.compile("\\S{1,}\\t\\d{1,}$");

    public static void importFile(Map<String, String> map, ProgressBar progressBar) {
        progressBar.setVisible(true);
        progressBar.setMinimum(0);
        progressBar.setMaximum(100);
        String file = map.get("file");
        String target = map.get("target");
        if (target.equals("novel")) {
            ImportHelper.importBook(file, "novel", progressBar);
        }
        if (target.equals("chapter")) {
            ImportHelper.importChapter(file, map.get("story"), progressBar);
        }
        if (target.equals("note")) {
            ImportHelper.importNote(file, map.get("story"), progressBar);
        }
    }

    private static void importBook(String sourceFilePath, String type, ProgressBar progressBar) {
        Element novelElement = ExplorerModelHelper.createStoryNode(type, ImportHelper.getFileName(sourceFilePath), null);
        ExplorerModelHelper.insertElement(null, novelElement);
        CreateNodeFileHelper.createStoryNodeFile(novelElement);
        Element folderElement = ExplorerModelHelper.createFolderNode(novelElement.attributeValue("location"), "chapterFolder", "\u7ae0\u8282");
        ExplorerModelHelper.insertElement(novelElement.attributeValue("id"), folderElement);
        ModelHelper.createFolder(folderElement.attributeValue("location"));
        ImportHelper.createChapter(novelElement.attributeValue("id"), sourceFilePath, folderElement, progressBar, false);
        ExplorerView view = (ExplorerView)WJ.getActivePage().findView(ExplorerView.class.getName());
        view.updateTree();
    }

    private static String getFileName(String fileName) {
        String[] parts = fileName.replace(File.separator, ";").split(";");
        String name = parts[parts.length - 1];
        return name.substring(0, name.lastIndexOf(46));
    }

    private static void createChapter(final String storyId, String sourceFileName, Element folderElement, ProgressBar progressBar, boolean isImportChapter) {
        Map<String, String> chapterMap = ImportHelper.getChapter(sourceFileName);
        Set<String> chapterNameSet = chapterMap.keySet();
        progressBar.setMaximum(chapterNameSet.size() + 20);
        final IndexService indexService = new IndexService();
        int i = 100000 + chapterNameSet.size() + 1;
        KeywordsHelper keywordsHelper = KeywordsHelper.getKeywordsHelper(storyId);
        String folderNodeLocation = folderElement.attributeValue("location");
        String folderNodeId = folderElement.attributeValue("id");
        for (String chapterName : chapterNameSet) {
            final String content = chapterMap.get(chapterName);
            if (content.length() >= 30000) {
                String message = "\u5f53\u524d\u7ae0\u8282" + chapterName + "\u5b57\u7b26\u6570\u5927\u4e8e30000\u4e2a\uff0c\u8d85\u8fc7\u4e86\u7cfb\u7edf\u8bbe\u7f6e\u7684\u6700\u5927\u5b57\u7b26\u6570\uff01" + "\n\u53ef\u80fd\u662f\u7531\u4e8e\u7cfb\u7edf\u4e0d\u80fd\u89e3\u6790\u60a8\u6587\u6863\u4e2d\u7684\u7ae0\u8282\u540d\u79f0\u5bfc\u81f4\u7684\uff0c\u8bf7\u786e\u8ba4\u60a8\u7684\u7ae0\u8282\u540d\u79f0\u7b26\u5408\u4ee5\u4e0b\u683c\u5f0f\uff1a" + "\n\u7b2cx\u7ae0  \u7ae0\u8282\u540d\u79f0" + "\n\u7b2cx\u56de  \u7ae0\u8282\u540d\u79f0" + "\n\u7b2cx\u96c6  \u7ae0\u8282\u540d\u79f0" + "\n\u7b2cx\u5219  \u7ae0\u8282\u540d\u79f0" + "\n\u53e6\u5916\uff0c\u53ef\u4ee5\u5728\u7b2cx\u7ae0\u3001\u56de\u3001\u96c6\u3001\u5219\u524d\u9762\u52a0\u4e0a\u7b2cx\u5377\uff0c\u5982\uff1a\u7b2c\u4e8c\u5377 \u7b2c\u4e09\u5341\u516d\u7ae0 \u7ea2\u62c2\u591c\u5954 " + "\n\u5982\u679c\u60a8\u7684\u7ae0\u8282\u5b57\u7b26\u592a\u591a\u8bf7\u62c6\u5206\uff0c\u5982\u679c\u60a8\u7684\u7ae0\u8282\u540d\u79f0\u4e0d\u7b26\u5408\u4ee5\u4e0a\u683c\u5f0f\u8bf7\u4fee\u6539\u3002";
                MessageDialog.openWarning(null, (String)"\u63d0\u793a", (String)message);
                break;
            }
            Element chapterNode = ExplorerModelHelper.createFileNode(folderNodeLocation, "chapter", chapterName, null);
            chapterNode.attribute("wordCount").setValue(String.valueOf(ModelHelper.getWordCount(content)));
            chapterNode.attribute("no").setValue(String.valueOf(--i));
            final String chapterId = chapterNode.attributeValue("id");
            final IFile chapterFile = ModelHelper.getFileByName(chapterNode.attributeValue("location"));
            CreateNodeFileHelper.createFileNodeFile(chapterNode);
            Element root = ModelHelper.getDocument(chapterFile).getRootElement();
            ModelHelper.updateContent(root, chapterMap.get(chapterName), chapterFile);
            ExplorerModelHelper.insertElement(folderNodeId, chapterNode);
            Display.getCurrent().asyncExec(new Runnable(){

                @Override
                public void run() {
                    indexService.createIndex(storyId, chapterId, content);
                    HistoryHelper.createSnapshot4Import(chapterFile, content);
                }
            });
            if (isImportChapter) {
                keywordsHelper.saveKeywordCount(chapterId, keywordsHelper.countAllRole(content));
            }
            progressBar.setSelection(progressBar.getSelection() + 1);
        }
    }

    private static void importChapter(String sourceFileName, String targetStoryId, ProgressBar progressBar) {
        Element storyElement = ExplorerModelHelper.getElement(targetStoryId);
        List chapterFolderList = storyElement.elements("chapterFolder");
        Element folderElement = null;
        if (chapterFolderList.isEmpty()) {
            folderElement = ExplorerModelHelper.createFolderNode(storyElement.attributeValue("location"), "chapterFolder", "\u7ae0\u8282");
            ExplorerModelHelper.insertElement(storyElement.attributeValue("id"), folderElement);
            ModelHelper.createFolder(folderElement.attributeValue("location"));
        } else {
            folderElement = (Element)chapterFolderList.get(chapterFolderList.size() - 1);
        }
        progressBar.setSelection(10);
        ImportHelper.createChapter(storyElement.attributeValue("id"), sourceFileName, folderElement, progressBar, true);
        ExplorerView view = (ExplorerView)WJ.getActivePage().findView(ExplorerView.class.getName());
        view.updateTree();
    }

    private static void importNote(String sourceFile, String targetStoryId, ProgressBar progressBar) {
        Element storyElement = ExplorerModelHelper.getElement(targetStoryId);
        Element folderElement = storyElement.element("noteFolder");
        if (folderElement == null) {
            folderElement = ExplorerModelHelper.createFolderNode(storyElement.attributeValue("location"), "noteFolder", "\u7d20\u6750");
            ExplorerModelHelper.insertElement(storyElement.attributeValue("id"), folderElement);
            ModelHelper.createFolder(folderElement.attributeValue("location"));
        }
        progressBar.setSelection(10);
        final String content = ImportHelper.getContent(sourceFile);
        if (content.length() >= 30000) {
            String message = "\u5f53\u524d\u7b14\u8bb0\u5b57\u7b26\u6570\u5927\u4e8e30000\u4e2a\uff0c\u8d85\u8fc7\u4e86\u7cfb\u7edf\u8bbe\u7f6e\u7684\u6700\u5927\u5b57\u7b26\u6570\uff0c\u8bf7\u62c6\u5206\u4e3a\u8f83\u5c0f\u7684\u6587\u6863\u5206\u522b\u5bfc\u5165\u3002";
            MessageDialog.openWarning(null, (String)"\u63d0\u793a", (String)message);
            return;
        }
        String folderLocation = folderElement.attributeValue("location");
        final Element noteElement = ExplorerModelHelper.createFileNode(folderLocation, "note", ImportHelper.getFileName(sourceFile), null);
        ExplorerModelHelper.insertElement(folderElement.attributeValue("id"), noteElement);
        CreateNodeFileHelper.createFileNodeFile(noteElement);
        progressBar.setSelection(20);
        IFile noteFile = ModelHelper.getFileByName(noteElement.attributeValue("location"));
        Element rootElement = ModelHelper.getDocument(noteFile).getRootElement();
        ModelHelper.updateContent(rootElement, content, noteFile);
        progressBar.setSelection(40);
        Activator.getDefault().invoke("eventExplorerAdd", noteElement.attributeValue("id"));
        progressBar.setSelection(60);
        final String storyId = folderElement.getParent().attributeValue("id");
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                IndexService indexService = new IndexService();
                indexService.createIndex(storyId, noteElement.attributeValue("id"), content);
            }
        });
        progressBar.setSelection(80);
        ExplorerView view = (ExplorerView)WJ.getActivePage().findView(ExplorerView.class.getName());
        view.updateTree();
    }

    private static Map<String, String> getChapter(String file) {
        if (file.endsWith(".doc")) {
            return ImportHelper.getChapter4doc(file);
        }
        if (file.endsWith(".docx")) {
            return ImportHelper.getChapter4docx(file);
        }
        return ImportHelper.getChapter4txt(file);
    }

    private static Map<String, String> getChapter4txt(String fileName) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        String[] lines = WJ.getContent4txt(fileName).split("\n");
        String chapterName = null;
        int i = 0;
        while (i < lines.length) {
            String line = lines[i].replace('\u3000', ' ');
            if (!(line = line.trim()).equals("")) {
                Matcher m;
                Matcher matcher = patternTitle.matcher(line);
                if (matcher.find() && !(m = patternCatalog.matcher(line)).find()) {
                    chapterName = line;
                } else {
                    if (chapterName == null) {
                        chapterName = line.length() > 10 ? line.substring(0, 10) : line;
                    }
                    String content = map.containsKey(chapterName) ? String.valueOf((String)map.get(chapterName)) + "\n\n" : "";
                    map.put(chapterName, String.valueOf(content) + line);
                }
            }
            ++i;
        }
        return map;
    }

    private static Map<String, String> getChapter4doc(String file) {
        try {
            FileInputStream is = new FileInputStream(file);
            WordExtractor extractor = new WordExtractor((InputStream)is);
            Map<String, String> map = ImportHelper.getChapter4DocAndDocx(extractor.getText().split("\n"));
            extractor.close();
            return map;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static Map<String, String> getChapter4docx(String file) {
        try {
            OPCPackage opcPackage = POIXMLDocument.openPackage((String)file);
            XWPFWordExtractor extractor = new XWPFWordExtractor(opcPackage);
            Map<String, String> map = ImportHelper.getChapter4DocAndDocx(extractor.getText().split("\n"));
            extractor.close();
            return map;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static Map<String, String> getChapter4DocAndDocx(String[] lines) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        String chapterName = null;
        int i = 0;
        while (i < lines.length) {
            String line = lines[i].trim();
            if (!line.trim().equals("")) {
                Matcher m;
                Matcher matcher = patternTitle.matcher(line);
                if (matcher.find() && !(m = patternCatalog.matcher(line)).find()) {
                    chapterName = line;
                } else {
                    if (chapterName == null) {
                        chapterName = line.length() > 10 ? line.substring(0, 10) : line;
                    }
                    String content = map.containsKey(chapterName) ? String.valueOf((String)map.get(chapterName)) + "\n\n" : "";
                    map.put(chapterName, String.valueOf(content) + line);
                }
            }
            ++i;
        }
        return map;
    }

    private static String getContent(String file) {
        if (file.endsWith(".doc")) {
            return ImportHelper.getContent4doc(file);
        }
        if (file.endsWith(".docx")) {
            return ImportHelper.getContent4docx(file);
        }
        return WJ.getContent4txt(file);
    }

    private static String getContent4doc(String file) {
        try {
            FileInputStream is = new FileInputStream(file);
            WordExtractor extractor = new WordExtractor((InputStream)is);
            String content = extractor.getText();
            extractor.close();
            return content;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static String getContent4docx(String file) {
        try {
            OPCPackage opcPackage = POIXMLDocument.openPackage((String)file);
            XWPFWordExtractor extractor = new XWPFWordExtractor(opcPackage);
            String content = extractor.getText();
            extractor.close();
            return content;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static List<String> listChapterCatalog(String file) {
        if (file.endsWith(".doc")) {
            return ImportHelper.getCatalog4doc(file);
        }
        if (file.endsWith(".docx")) {
            return ImportHelper.getCatalog4docx(file);
        }
        return ImportHelper.getCatalog4txt(file);
    }

    private static List<String> getCatalog4txt(String fileName) {
        ArrayList<String> catalogList = new ArrayList<String>();
        String content = WJ.getContent4txt(fileName);
        String[] lines = content.split("\n");
        int i = 0;
        while (i < lines.length) {
            Matcher m;
            Matcher matcher;
            if (!lines[i].equals("") && (matcher = patternTitle.matcher(lines[i])).find() && !(m = patternCatalog.matcher(lines[i])).find()) {
                catalogList.add(lines[i]);
            }
            ++i;
        }
        return catalogList;
    }

    private static List<String> getCatalog4doc(String file) {
        try {
            FileInputStream is = new FileInputStream(file);
            WordExtractor extractor = new WordExtractor((InputStream)is);
            List<String> catalogList = ImportHelper.getCatalog4DocAndDocx(extractor.getText().split("\n"));
            extractor.close();
            return catalogList;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static List<String> getCatalog4docx(String file) {
        try {
            OPCPackage opcPackage = POIXMLDocument.openPackage((String)file);
            XWPFWordExtractor extractor = new XWPFWordExtractor(opcPackage);
            List<String> catalogList = ImportHelper.getCatalog4DocAndDocx(extractor.getText().split("\n"));
            extractor.close();
            return catalogList;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static List<String> getCatalog4DocAndDocx(String[] lines) {
        ArrayList<String> catalogList = new ArrayList<String>();
        int i = 0;
        while (i < lines.length) {
            Matcher m;
            Matcher matcher;
            String line = lines[i].trim();
            if (!line.equals("") && (matcher = patternTitle.matcher(line)).find() && !(m = patternCatalog.matcher(line)).find()) {
                catalogList.add(line);
            }
            ++i;
        }
        return catalogList;
    }
}

