/*
 * Decompiled with CFR 0.152.
 */
package wj.ap.importexport;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.dialogs.IPageChangingListener;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.PageChangingEvent;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import wj.ap.importexport.ImportFileSelectPage;
import wj.ap.importexport.ImportFileTypeSelectPage;
import wj.ap.importexport.ImportHelper;
import wj.ap.importexport.ImportPreviousPage;

public class ImportWizard
extends Wizard {
    private ImportFileSelectPage selectImportFilePage;
    private ImportFileTypeSelectPage selectTargetFileTypePage;
    private ImportPreviousPage importPreviousPage;
    private Map<String, String> inputMap = new HashMap<String, String>(3);
    private boolean isPerform = true;

    public ImportWizard() {
        this.setWindowTitle("\u5bfc\u5165\u5411\u5bfc");
        this.setNeedsProgressMonitor(true);
        this.selectImportFilePage = new ImportFileSelectPage(this.inputMap);
        this.selectTargetFileTypePage = new ImportFileTypeSelectPage(this.inputMap);
        this.importPreviousPage = new ImportPreviousPage(this.inputMap);
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        WizardDialog dialog = (WizardDialog)this.getContainer();
        dialog.addPageChangingListener(new IPageChangingListener(){

            public void handlePageChanging(PageChangingEvent event) {
                if (event.getTargetPage() instanceof ImportPreviousPage) {
                    ImportPreviousPage page = (ImportPreviousPage)((Object)event.getTargetPage());
                    page.updateMessage();
                }
            }
        });
    }

    public boolean canFinish() {
        return this.selectImportFilePage.isPageComplete() && this.selectTargetFileTypePage.isPageComplete();
    }

    public boolean performFinish() {
        if (!this.isPerform) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)"\u63d0\u793a", (String)"\u6b63\u5728\u5bfc\u5165\uff0c\u8bf7\u7b49\u5f85\u3002");
            return false;
        }
        this.isPerform = false;
        IWizardPage currPage = this.getContainer().getCurrentPage();
        ProgressBar bar = null;
        if (currPage instanceof ImportFileTypeSelectPage) {
            bar = ((ImportFileTypeSelectPage)currPage).getProgressBar();
        } else if (currPage instanceof ImportPreviousPage) {
            bar = ((ImportPreviousPage)currPage).getProgressBar();
        }
        ImportHelper.importFile(this.inputMap, bar);
        MessageDialog.openInformation(null, (String)"\u63d0\u793a", (String)"\u5bfc\u5165\u6210\u529f\uff01\n\u901a\u8fc7\u8bbe\u5b9a\u89d2\u8272\u540d\u79f0\u53ef\u4ee5\u5b9e\u73b0\u5bf9\u89d2\u8272\u7684\u7edf\u8ba1\u3002");
        return true;
    }

    public void addPages() {
        this.addPage((IWizardPage)this.selectImportFilePage);
        this.addPage((IWizardPage)this.selectTargetFileTypePage);
        this.addPage((IWizardPage)this.importPreviousPage);
    }
}

