/*
 * Decompiled with CFR 0.152.
 */
package wj.ap.login;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class ImageButtonWithText
extends Composite {
    private Color textColor = Display.getDefault().getSystemColor(2);
    private Image image;
    private String text;
    private int width;
    private int height;

    public ImageButtonWithText(Composite parent, int style) {
        super(parent, style);
        this.addListener(12, new Listener(){

            public void handleEvent(Event arg0) {
                if (ImageButtonWithText.this.image != null) {
                    ImageButtonWithText.this.image.dispose();
                }
            }
        });
        this.addListener(9, new Listener(){

            public void handleEvent(Event e) {
                ImageButtonWithText.this.paintControl(e);
            }
        });
    }

    private void paintControl(Event event) {
        GC gc = event.gc;
        if (this.image != null) {
            gc.drawImage(this.image, 1, 1);
            Point textSize = gc.textExtent(this.text);
            gc.setForeground(this.textColor);
            gc.drawText(this.text, (this.width - textSize.x) / 2 + 1, (this.height - textSize.y) / 2 + 4, true);
        }
    }

    public void setImage(Image image) {
        this.image = new Image((Device)Display.getDefault(), image, 0);
        this.width = image.getBounds().width;
        this.height = image.getBounds().height;
        this.redraw();
    }

    public void setText(String text) {
        this.text = text;
        this.redraw();
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        int overallWidth = this.width;
        int overallHeight = this.height;
        if (wHint != -1 && wHint < overallWidth) {
            overallWidth = wHint;
        }
        if (hHint != -1 && hHint < overallHeight) {
            overallHeight = hHint;
        }
        return new Point(overallWidth + 2, overallHeight + 2);
    }
}

