/*
 * Decompiled with CFR 0.152.
 */
package wj.ap.login;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.json.JSONObject;
import wj.ap.login.Account;
import wj.ap.util.InternetHelper;
import wj.ap.util.StatusHelper;

public class LoginHelper {
    public static boolean isMobileNO(String mobiles) {
        boolean flag = false;
        try {
            Pattern p = Pattern.compile("^1\\d{10}$");
            Matcher m = p.matcher(mobiles);
            flag = m.matches();
        }
        catch (Exception e) {
            flag = false;
        }
        return flag;
    }

    public static boolean registOrLoginByMeid(String meid) {
        if (meid != null) {
            return LoginHelper.loginByMeid();
        }
        meid = "at" + System.currentTimeMillis() + Math.round(Math.random() * 1000.0);
        String url = String.valueOf(InternetHelper.getHost()) + "/app/uc/regist/auto";
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair("meid", meid));
        String result = InternetHelper.get(url, params);
        System.out.println("meid\u6ce8\u518c\uff1a" + result);
        if (result != null && !result.equals("")) {
            JSONObject obj = new JSONObject(result);
            if (obj.getString("code").equals("001")) {
                Account account = Account.getInstance();
                account.setUserId(obj.getJSONObject("data").getString("id"));
                account.setToken(obj.getJSONObject("data").getString("tk"));
                LoginHelper.saveMeidOrPhone("meid", meid);
                return true;
            }
            return false;
        }
        return false;
    }

    public static boolean sendSms(String phone) {
        String url = String.valueOf(InternetHelper.getHost()) + "/app/uc/regist/sms";
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        Account account = Account.getInstance();
        params.add(new BasicNameValuePair("id", account.getUserId()));
        params.add(new BasicNameValuePair("tk", account.getToken()));
        params.add(new BasicNameValuePair("phone", phone));
        UrlEncodedFormEntity entity = new UrlEncodedFormEntity(params, Charset.forName("UTF-8"));
        try {
            HttpGet get = new HttpGet(String.valueOf(url) + "?" + EntityUtils.toString((HttpEntity)entity, (Charset)Charset.forName("UTF-8")));
            String result = (String)InternetHelper.httpClient.execute((HttpUriRequest)get, (ResponseHandler)new ResponseHandler<String>(){

                public String handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                    StatusLine statusLine = response.getStatusLine();
                    int code = statusLine.getStatusCode();
                    if (code == 200) {
                        return EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)Charset.defaultCharset());
                    }
                    return null;
                }
            });
            if (result != null) {
                System.out.println("\u53d1\u9001\u77ed\u4fe1\uff1a" + result);
                JSONObject obj = new JSONObject(result);
                String code = obj.getString("code");
                if (code.equals("002")) {
                    return false;
                }
            }
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public static boolean registPhone(String phone, String captcha, String nickname) {
        block4: {
            String url = String.valueOf(InternetHelper.getHost()) + "/app/uc/regist/self";
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            Account account = Account.getInstance();
            params.add(new BasicNameValuePair("id", account.getUserId()));
            params.add(new BasicNameValuePair("tk", account.getToken()));
            params.add(new BasicNameValuePair("phone", phone));
            params.add(new BasicNameValuePair("captcha", captcha));
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(params, Charset.forName("UTF-8"));
            try {
                HttpGet get = new HttpGet(String.valueOf(url) + "?" + EntityUtils.toString((HttpEntity)entity, (Charset)Charset.forName("UTF-8")));
                HttpResponse response = InternetHelper.httpClient.execute((HttpUriRequest)get);
                String result = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)Charset.defaultCharset());
                if (result == null) break block4;
                System.out.println("\u624b\u673a\u53f7\u6ce8\u518c\u7684\u4fe1\u606f\uff1a" + result);
                JSONObject obj = new JSONObject(result);
                String code = obj.getString("code");
                if (code.equals("001") || code.equals("004")) {
                    LoginHelper.saveMeidOrPhone("phone", phone);
                    LoginHelper.saveMeidOrPhone("nickname", nickname);
                    if (code.equals("004")) {
                        account.setUserId(obj.getJSONObject("data").getString("id"));
                    }
                    break block4;
                }
                return false;
            }
            catch (IOException e) {
                return false;
            }
        }
        return true;
    }

    public static boolean loginByMeid() {
        block3: {
            JSONObject obj;
            block4: {
                System.out.println("\u6267\u884c\u767b\u5f55\u64cd\u4f5c");
                String url = String.valueOf(InternetHelper.getHost()) + "/app/uc/customer/login";
                ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
                params.add(new BasicNameValuePair("meid", LoginHelper.getMeidOrPhone("meid")));
                UrlEncodedFormEntity entity = new UrlEncodedFormEntity(params, Charset.forName("UTF-8"));
                try {
                    HttpGet get = new HttpGet(String.valueOf(url) + "?" + EntityUtils.toString((HttpEntity)entity, (Charset)Charset.forName("UTF-8")));
                    String result = (String)InternetHelper.httpClient.execute((HttpUriRequest)get, (ResponseHandler)new ResponseHandler<String>(){

                        public String handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                            StatusLine statusLine = response.getStatusLine();
                            int code = statusLine.getStatusCode();
                            if (code == 200) {
                                return EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)Charset.defaultCharset());
                            }
                            return null;
                        }
                    });
                    if (result == null) break block3;
                    obj = new JSONObject(result);
                    String code = obj.getString("code");
                    if (code.equals("001")) break block4;
                    return false;
                }
                catch (IOException e) {
                    return false;
                }
            }
            System.out.println("\u767b\u5f55\u4fe1\u606f\uff1a" + obj);
            Account account = Account.getInstance();
            account.setToken(obj.getJSONObject("data").getString("tk"));
            account.setUserId(obj.getJSONObject("data").getString("id"));
        }
        return true;
    }

    public static String getMeidOrPhone(String key) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject("_root_");
        IFile iFile = project.getFile(".at");
        String filePath = iFile.getLocationURI().getPath();
        if (!iFile.exists()) {
            File file = new File(filePath);
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                return null;
            }
        }
        return (String)StatusHelper.getProperties(filePath).get(key);
    }

    public static void saveMeidOrPhone(String key, String value) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject("_root_");
        IFile iFile = project.getFile(".at");
        String filePath = iFile.getLocationURI().getPath();
        Properties properties = StatusHelper.getProperties(filePath);
        properties.put(key, value);
        StatusHelper.saveProperties(properties, filePath);
    }
}

