/*
 * Decompiled with CFR 0.152.
 */
package wj.ap.search;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.dom4j.Element;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import wj.ap.explorer.ExplorerView;
import wj.ap.file.editor.ITextEditor;
import wj.ap.search.SearchReplaceHelper;
import wj.ap.search.SearchResultView;
import wj.ap.sys.Activator;
import wj.ap.textviewer.TextViewer;
import wj.ap.util.AbstractDialog;
import wj.ap.util.WJ;

public class FindAndReplaceDialog
extends AbstractDialog
implements IPropertyChangeListener {
    private Button chapterBtn;
    private Button bookBtn;
    private Button allBtn;
    private Button replaceAllBtn;
    private Button replaceAndSearchBtn;
    private Button replaceBtn;
    private Button searchBtn;
    private Button closeBtn;
    private Combo searchCombo;
    private Combo replaceCombo;
    private Label tipLabel;
    private String previouseSearchText = "";
    private IEditorPart currEditorPart;
    private Map<IEditorPart, String> replaceInfo = new HashMap<IEditorPart, String>();

    public FindAndReplaceDialog() {
        super(Display.getCurrent().getActiveShell());
        Activator.getDefault().addPropertyChangeListener(this);
        this.currEditorPart = WJ.getActivePage().getActiveEditor();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("\u67e5\u627e\u548c\u66ff\u6362");
        this.listenBroughtTopEditor();
    }

    protected Control createContents(Composite parent) {
        this.createControl(parent);
        this.setSerachScope();
        this.searchAndReplaceCombo();
        this.closeListener();
        this.searchComboListener();
        this.searchListener();
        this.replaceListener();
        this.initControl();
        return parent;
    }

    private void replaceListener() {
        this.replaceAndSearchBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FindAndReplaceDialog.this.replace();
                Activator.getDefault().invoke("eventNext", FindAndReplaceDialog.this.searchBtn.getSelection());
            }
        });
        this.replaceBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FindAndReplaceDialog.this.replace();
            }
        });
        this.replaceAllBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String storyId = null;
                String fileId = null;
                if (!FindAndReplaceDialog.this.allBtn.getSelection()) {
                    if (FindAndReplaceDialog.this.bookBtn.getSelection()) {
                        storyId = (String)FindAndReplaceDialog.this.bookBtn.getData();
                    } else if (FindAndReplaceDialog.this.chapterBtn.getSelection()) {
                        storyId = (String)FindAndReplaceDialog.this.bookBtn.getData();
                        fileId = (String)FindAndReplaceDialog.this.chapterBtn.getData();
                    }
                }
                SearchReplaceHelper.replaceAll(storyId, fileId, FindAndReplaceDialog.this.searchCombo.getText().trim(), FindAndReplaceDialog.this.replaceCombo.getText().trim());
                Activator.getDefault().invoke("eventSearchRemoveAll", "");
                FindAndReplaceDialog.this.enableReplaceButtons(false);
                FindAndReplaceDialog.this.searchBtn.setEnabled(false);
            }
        });
    }

    private void searchListener() {
        this.searchBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FindAndReplaceDialog.this.search(true);
            }
        });
    }

    private void search(boolean forward) {
        StringBuilder sb = new StringBuilder();
        if (this.allBtn.getSelection()) {
            sb.append("\n\n");
        } else if (this.bookBtn.getSelection()) {
            sb.append(this.bookBtn.getData()).append("\n\n");
        } else if (this.chapterBtn.getSelection()) {
            sb.append(this.bookBtn.getData()).append("\n").append(this.chapterBtn.getData()).append("\n");
        }
        sb.append(this.searchCombo.getText().trim());
        if (this.previouseSearchText.equals(sb.toString())) {
            Activator.getDefault().invoke("eventNext", forward);
        } else {
            this.previouseSearchText = sb.toString();
            WJ.BroughtToTop(SearchResultView.class.getName());
            sb.append("\n").append(forward);
            Activator.getDefault().invoke("eventSearch", sb.toString());
        }
    }

    private void searchComboListener() {
        this.searchCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String text = FindAndReplaceDialog.this.searchCombo.getText();
                boolean b = !text.equals("");
                FindAndReplaceDialog.this.replaceAllBtn.setEnabled(b);
                FindAndReplaceDialog.this.searchBtn.setEnabled(b);
            }
        });
    }

    private void initControl() {
        this.enableReplaceButtons(false);
        this.searchCombo.setFocus();
    }

    private void enableReplaceButtons(boolean b) {
        this.replaceAllBtn.setEnabled(b);
        this.replaceBtn.setEnabled(b);
        this.replaceAndSearchBtn.setEnabled(b);
    }

    private void searchAndReplaceCombo() {
        Properties properties = SearchReplaceHelper.getHistoryProperties();
        this.searchCombo.setItems(SearchReplaceHelper.getHistory(properties, "search"));
        this.replaceCombo.setItems(SearchReplaceHelper.getHistory(properties, "replace"));
        if (this.searchCombo.getItemCount() > 0) {
            this.searchCombo.select(0);
        }
        this.searchCombo.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                String currText = FindAndReplaceDialog.this.searchCombo.getText().trim();
                if (currText.equals("")) {
                    return;
                }
                SearchReplaceHelper.saveHistory(FindAndReplaceDialog.this.searchCombo.getItems(), currText, "search");
            }

            public void focusGained(FocusEvent e) {
                FindAndReplaceDialog.this.searchCombo.setItems(SearchReplaceHelper.getHistory(SearchReplaceHelper.getHistoryProperties(), "search"));
                FindAndReplaceDialog.this.searchCombo.select(0);
            }
        });
        this.replaceCombo.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                String currText = FindAndReplaceDialog.this.replaceCombo.getText().trim();
                if (currText.equals("")) {
                    return;
                }
                SearchReplaceHelper.saveHistory(FindAndReplaceDialog.this.replaceCombo.getItems(), currText, "replace");
            }

            public void focusGained(FocusEvent e) {
                FindAndReplaceDialog.this.replaceCombo.setItems(SearchReplaceHelper.getHistory(SearchReplaceHelper.getHistoryProperties(), "replace"));
                if (!FindAndReplaceDialog.this.replaceCombo.getText().trim().equals("")) {
                    FindAndReplaceDialog.this.replaceCombo.select(0);
                }
            }
        });
    }

    private void setSerachScope() {
        ExplorerView explorerView = (ExplorerView)WJ.BroughtToTop(ExplorerView.class.getName());
        Element node = explorerView.getSelectNode();
        if (node == null) {
            this.setScopeBtn(this.allBtn);
            this.bookBtn.setData((Object)"");
            this.chapterBtn.setData((Object)"");
        } else {
            String[] parts = node.attributeValue("location").replace(File.separator, ";").split(";");
            if (node.attributeValue("type").equals("file")) {
                this.setScopeBtn(this.chapterBtn);
                this.bookBtn.setData((Object)parts[0]);
                this.chapterBtn.setData((Object)node.attributeValue("id"));
            } else {
                this.setScopeBtn(this.bookBtn);
                this.bookBtn.setData((Object)parts[0]);
                this.chapterBtn.setData((Object)"");
            }
        }
    }

    private void setScopeBtn(Button btn) {
        this.chapterBtn.setSelection(false);
        this.bookBtn.setSelection(false);
        this.allBtn.setSelection(false);
        if (this.chapterBtn.equals(btn)) {
            this.chapterBtn.setSelection(true);
            this.allBtn.setEnabled(true);
            this.bookBtn.setEnabled(true);
            this.chapterBtn.setEnabled(true);
        }
        if (this.bookBtn.equals(btn)) {
            this.bookBtn.setSelection(true);
            this.allBtn.setEnabled(true);
            this.bookBtn.setEnabled(true);
            this.chapterBtn.setEnabled(false);
        }
        if (this.allBtn.equals(btn)) {
            this.allBtn.setSelection(true);
            this.allBtn.setEnabled(true);
            this.bookBtn.setEnabled(false);
            this.chapterBtn.setEnabled(false);
        }
    }

    private void closeListener() {
        this.closeBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FindAndReplaceDialog.this.getShell().close();
            }
        });
    }

    private void createControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, true));
        Composite searchComp = new Composite(parent, 0);
        GridData gd = new GridData(768);
        searchComp.setLayoutData((Object)gd);
        searchComp.setLayout((Layout)new GridLayout(2, false));
        new Label(searchComp, 0).setText("\u641c\u7d22\uff1a");
        this.searchCombo = new Combo(searchComp, 0);
        this.searchCombo.setLayoutData((Object)new GridData(768));
        new Label(searchComp, 0).setText("\u66ff\u6362\uff1a");
        this.replaceCombo = new Combo(searchComp, 0);
        this.replaceCombo.setLayoutData((Object)new GridData(768));
        Group group = new Group(parent, 0);
        group.setText("\u8303\u56f4");
        group.setLayoutData((Object)new GridData(768));
        group.setLayout((Layout)new GridLayout(3, true));
        this.chapterBtn = new Button((Composite)group, 16);
        this.chapterBtn.setText("\u672c\u7ae0");
        this.chapterBtn.setLayoutData((Object)new GridData(768));
        this.bookBtn = new Button((Composite)group, 16);
        this.bookBtn.setText("\u672c\u4e66");
        this.bookBtn.setLayoutData((Object)new GridData(768));
        this.allBtn = new Button((Composite)group, 16);
        this.allBtn.setText("\u5168\u90e8");
        this.allBtn.setLayoutData((Object)new GridData(768));
        Composite buttonComp = new Composite(parent, 0);
        buttonComp.setLayoutData((Object)new GridData(768));
        buttonComp.setLayout((Layout)new GridLayout(4, true));
        this.replaceAllBtn = new Button(buttonComp, 0);
        this.replaceAllBtn.setText("\u5168\u90e8\u66ff\u6362");
        this.replaceAllBtn.setLayoutData((Object)new GridData(768));
        this.replaceAndSearchBtn = new Button(buttonComp, 0);
        this.replaceAndSearchBtn.setText("\u66ff\u6362\u5e76\u67e5\u627e");
        this.replaceAndSearchBtn.setLayoutData((Object)new GridData(768));
        this.replaceBtn = new Button(buttonComp, 0);
        this.replaceBtn.setText("\u66ff\u6362");
        this.replaceBtn.setLayoutData((Object)new GridData(768));
        this.searchBtn = new Button(buttonComp, 0);
        this.searchBtn.setText("\u67e5\u627e");
        this.searchBtn.setLayoutData((Object)new GridData(768));
        this.searchBtn.setToolTipText("\u641c\u7d22");
        Composite tipComp = new Composite(parent, 0);
        tipComp.setLayoutData((Object)new GridData(768));
        tipComp.setLayout((Layout)new GridLayout(4, true));
        this.tipLabel = new Label(tipComp, 0);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.tipLabel.setLayoutData((Object)gd);
        this.closeBtn = new Button(tipComp, 0);
        this.closeBtn.setText("\u5173\u95ed ");
        this.closeBtn.setLayoutData((Object)new GridData(768));
    }

    public boolean close() {
        super.close();
        Activator.getDefault().removePropertyChangeListener(this);
        return true;
    }

    @Override
    protected int getShellStyle() {
        return 16608;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("eventSearchResult")) {
            int count = (Integer)event.getNewValue();
            this.tipLabel.setText("\u5171\u67e5\u8be2\u5230" + count + "\u6761\u8bb0\u5f55");
            if (count > 0) {
                this.tipLabel.setForeground(Display.getCurrent().getSystemColor(2));
                this.enableReplaceButtons(true);
            } else {
                this.enableReplaceButtons(false);
                this.tipLabel.setForeground(Display.getCurrent().getSystemColor(3));
            }
        }
        if (event.getProperty().equals("eventSelectSearchWord")) {
            this.replaceInfo.putAll((Map)event.getNewValue());
            this.replaceBtn.setEnabled(true);
        }
    }

    private void listenBroughtTopEditor() {
        WJ.getActivePage().addPartListener(new IPartListener2(){

            public void partVisible(IWorkbenchPartReference partRef) {
            }

            public void partOpened(IWorkbenchPartReference partRef) {
                FindAndReplaceDialog.this.setCurrEditor(partRef.getPart(false));
            }

            public void partInputChanged(IWorkbenchPartReference partRef) {
            }

            public void partHidden(IWorkbenchPartReference partRef) {
            }

            public void partDeactivated(IWorkbenchPartReference partRef) {
            }

            public void partClosed(IWorkbenchPartReference partRef) {
            }

            public void partBroughtToTop(IWorkbenchPartReference partRef) {
                FindAndReplaceDialog.this.setCurrEditor(partRef.getPart(false));
            }

            public void partActivated(IWorkbenchPartReference partRef) {
            }
        });
    }

    private void setCurrEditor(IWorkbenchPart part) {
        if (part instanceof ITextEditor) {
            this.currEditorPart = (IEditorPart)part;
        }
    }

    private void replace() {
        String[] parts = this.replaceInfo.get(this.currEditorPart).split(";");
        int start = Integer.parseInt(parts[0]);
        int length = Integer.parseInt(parts[1]);
        TextViewer viewer = ((ITextEditor)this.currEditorPart).getTextViewer();
        StyledText styledText = viewer.getTextWidget();
        styledText.replaceTextRange(start, length, this.replaceCombo.getText());
        this.replaceInfo.remove(this.currEditorPart);
        this.replaceBtn.setEnabled(false);
    }
}

