/*
 * Decompiled with CFR 0.152.
 */
package wj.ap.search;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.eclipse.core.resources.IFolder;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.swt.widgets.TreeItem;
import wj.ap.explorer.ExplorerModelHelper;
import wj.ap.search.LuceneHelper;
import wj.ap.util.ModelHelper;

public class IndexService {
    public static final String STORY_ID = "s";
    public static final String FILE_ID = "f";
    public static final String FILE_CONTENT = "c";
    public static final String SEARCH_TEXT = "searchText";
    public static Map<String, String> searchTerms = null;
    private static LuceneHelper helper = LuceneHelper.getInstance();

    public void createIndex(String storyId, String fileId, String fileContent) {
        if (storyId == null || storyId.equals("") || fileId == null || fileId.equals("") || fileContent == null || fileContent.equals("")) {
            return;
        }
        IndexWriter fsIndexWriter = null;
        try {
            try {
                fsIndexWriter = helper.getFSIndexWriter();
                fsIndexWriter.deleteDocuments(new Term(FILE_ID, fileId));
                org.apache.lucene.document.Document document = new org.apache.lucene.document.Document();
                document.add((Fieldable)new Field(STORY_ID, storyId, Field.Store.YES, Field.Index.NOT_ANALYZED));
                document.add((Fieldable)new Field(FILE_ID, fileId, Field.Store.YES, Field.Index.NOT_ANALYZED));
                document.add((Fieldable)new Field(FILE_CONTENT, fileContent, Field.Store.NO, Field.Index.ANALYZED));
                fsIndexWriter.addDocument(document);
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    fsIndexWriter.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                fsIndexWriter.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static org.apache.lucene.document.Document[] query(String storyId, String fileId, String keyword) {
        TermQuery termQuery;
        Term term;
        BooleanQuery booleanQuery = new BooleanQuery();
        if (storyId != null && !storyId.equals("")) {
            term = new Term(STORY_ID, storyId);
            termQuery = new TermQuery(term);
            booleanQuery.add((Query)termQuery, BooleanClause.Occur.MUST);
        }
        if (fileId != null && !fileId.equals("")) {
            term = new Term(FILE_ID, fileId);
            termQuery = new TermQuery(term);
            booleanQuery.add((Query)termQuery, BooleanClause.Occur.MUST);
        }
        if (keyword == null || keyword.equals("")) {
            return new org.apache.lucene.document.Document[0];
        }
        PhraseQuery query = new PhraseQuery();
        keyword = keyword.trim();
        int i = 0;
        while (i < keyword.length()) {
            Term term2 = new Term(FILE_CONTENT, new String(new char[]{keyword.charAt(i)}));
            query.add(term2);
            ++i;
        }
        query.setSlop(0);
        booleanQuery.add((Query)query, BooleanClause.Occur.MUST);
        IndexSearcher indexSearcher = null;
        org.apache.lucene.document.Document[] documents = null;
        try {
            try {
                FSDirectory fsdirectory = FSDirectory.open((File)helper.getIndexPath());
                indexSearcher = new IndexSearcher(IndexReader.open((Directory)fsdirectory));
                SortField storyIdSort = new SortField(STORY_ID, 6, true);
                SortField fileIdSort = new SortField(FILE_ID, 6, true);
                Sort sort = new Sort(new SortField[]{storyIdSort, fileIdSort});
                TopFieldDocs topDocs = indexSearcher.search((Query)booleanQuery, null, 1000, sort);
                int hits = topDocs.totalHits;
                ScoreDoc[] scoreDocs = topDocs.scoreDocs;
                documents = new org.apache.lucene.document.Document[hits];
                int i2 = 0;
                while (i2 < hits) {
                    documents[i2] = indexSearcher.doc(scoreDocs[i2].doc);
                    ++i2;
                }
            }
            catch (Exception e) {
                org.apache.lucene.document.Document[] documentArray = new org.apache.lucene.document.Document[]{};
                try {
                    indexSearcher.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                return documentArray;
            }
        }
        finally {
            try {
                indexSearcher.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return documents;
    }

    public static int createSearchResultTreeItem(String searchText, String fileId, TreeItem fileTreeItem) {
        try {
            return IndexService.createTreeItem(IndexService.getPattern(searchText), IndexService.getFileContent(fileId), fileTreeItem);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return 0;
        }
    }

    private static String getFileContent(String fileId) {
        String location = ExplorerModelHelper.getElement(fileId).attributeValue("location");
        return ModelHelper.getContent(ModelHelper.getDocument(location));
    }

    public static void createSearchResultTreeItemByContent(String searchText, String content, TreeItem fileTreeItem) {
        try {
            IndexService.createTreeItem(IndexService.getPattern(searchText), content, fileTreeItem);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    private static List<String> getTerms(String text) {
        ArrayList<String> terms = new ArrayList<String>(3);
        try {
            TokenStream tokens = helper.getAnalyzer().reusableTokenStream(SEARCH_TEXT, (Reader)new StringReader(text));
            OffsetAttribute offsetAttr = (OffsetAttribute)tokens.getAttribute(OffsetAttribute.class);
            CharTermAttribute charTermAttr = (CharTermAttribute)tokens.getAttribute(CharTermAttribute.class);
            while (tokens.incrementToken()) {
                char[] charBuf = charTermAttr.buffer();
                String term = new String(charBuf, 0, offsetAttr.endOffset() - offsetAttr.startOffset());
                terms.add(term);
            }
            tokens.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return terms;
    }

    public static String getRegular(String searchText) {
        return searchText.trim();
    }

    public static Pattern getPattern(String searchContent) {
        String regular = IndexService.getRegular(searchContent);
        return Pattern.compile(regular);
    }

    private static int createTreeItem(Pattern pattern, String fileContent, TreeItem parentItem) throws BadLocationException {
        Document doc = new Document();
        doc.set(fileContent);
        int maxWords = 10;
        String[] lineArray = fileContent.split("\n");
        int index = 0;
        int i = 0;
        while (i < lineArray.length) {
            String lineText = lineArray[i];
            if (!lineText.equals("")) {
                Matcher matcher = pattern.matcher(lineText);
                boolean isMatch = false;
                ArrayList matchers = new ArrayList();
                String word = "word";
                String start = "start";
                String end = "end";
                while (matcher.find()) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put(word, matcher.group());
                    map.put(start, matcher.start());
                    map.put(end, matcher.end());
                    matchers.add(map);
                    isMatch = true;
                }
                if (isMatch) {
                    int j = 0;
                    while (j < matchers.size()) {
                        StringBuffer sb = new StringBuffer();
                        Map wordMap = (Map)matchers.get(j);
                        int wordStart = (Integer)wordMap.get(start);
                        int wordEnd = (Integer)wordMap.get(end);
                        if (wordStart > maxWords) {
                            sb.append("...").append(lineText.substring(wordStart - maxWords, wordStart));
                        } else {
                            sb.append(lineText.substring(0, wordStart));
                        }
                        sb.append(lineText.substring(wordStart, wordEnd));
                        if (lineText.length() - wordEnd > maxWords) {
                            sb.append(lineText.substring(wordEnd, wordEnd + maxWords)).append("...");
                        } else {
                            sb.append(lineText.substring(wordEnd, lineText.length()));
                        }
                        TreeItem wordItem = new TreeItem(parentItem, 0);
                        wordItem.setData("lineIndex", (Object)i);
                        wordItem.setData("text", (Object)sb.toString());
                        wordItem.setData("pattern", (Object)pattern);
                        wordItem.setData("matcher", matchers.get(j));
                        wordItem.setData((Object)"line");
                        wordItem.setData("index", (Object)index);
                        wordItem.setData("flag", (Object)"word");
                        ++index;
                        ++j;
                    }
                }
            }
            ++i;
        }
        return index;
    }

    public void deleteIndexByStroyId(String storyId) {
        IndexWriter fsIndexWriter = null;
        try {
            try {
                fsIndexWriter = helper.getFSIndexWriter();
                fsIndexWriter.deleteDocuments(new Term(STORY_ID, storyId));
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    fsIndexWriter.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                fsIndexWriter.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void deleteIndexByFileId(String fileId) {
        IndexWriter fsIndexWriter = null;
        try {
            try {
                fsIndexWriter = helper.getFSIndexWriter();
                fsIndexWriter.deleteDocuments(new Term(FILE_ID, fileId));
                IFolder folder = ModelHelper.getProject().getFolder("index");
                folder.refreshLocal(0, null);
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    fsIndexWriter.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                fsIndexWriter.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

