/*
 * Decompiled with CFR 0.152.
 */
package wj.ap.search;

import java.io.File;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.Version;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.wltea.analyzer.cfg.Configuration;
import org.wltea.analyzer.cfg.DefualtConfig;
import org.wltea.analyzer.dic.Dictionary;
import wj.ap.util.ModelHelper;

public class LuceneHelper {
    private Analyzer analyzer;
    private File indexPath;
    private static Dictionary dictionary;
    private static LuceneHelper helper;

    static {
        Configuration cfg = DefualtConfig.getInstance();
        cfg.setUseSmart(false);
        dictionary = Dictionary.initial((Configuration)cfg);
        LuceneHelper.addExtendsWords(ModelHelper.getAllRoleName());
    }

    public static void addExtendsWords(List<String> extWords) {
        dictionary.addWords(extWords);
    }

    public File getIndexPath() {
        if (this.indexPath == null) {
            IFolder folder = ModelHelper.getProject().getFolder("index");
            if (!folder.exists()) {
                try {
                    folder.create(true, true, null);
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
            this.indexPath = new File(folder.getLocationURI());
        }
        return this.indexPath;
    }

    public IndexWriter getFSIndexWriter() throws Exception {
        IndexWriterConfig writeConfig = new IndexWriterConfig(helper.getVersion(), helper.getAnalyzer());
        writeConfig.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
        FSDirectory fsdirectory = FSDirectory.open((File)helper.getIndexPath());
        IndexWriter indexWriter = new IndexWriter((Directory)fsdirectory, writeConfig);
        return indexWriter;
    }

    public Analyzer getAnalyzer() {
        if (this.analyzer == null) {
            this.analyzer = new StandardAnalyzer(Version.LUCENE_36);
        }
        return this.analyzer;
    }

    public Version getVersion() {
        return Version.LUCENE_36;
    }

    private LuceneHelper() {
    }

    public static LuceneHelper getInstance() {
        if (helper == null) {
            helper = new LuceneHelper();
        }
        return helper;
    }
}

