/*
 * Decompiled with CFR 0.152.
 */
package wj.ap.search;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import org.dom4j.Document;
import org.dom4j.Element;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import wj.ap.explorer.ExplorerModelHelper;
import wj.ap.search.IndexService;
import wj.ap.util.ModelHelper;
import wj.ap.util.WJ;

public class SearchReplaceHelper {
    public static final String SEARCH = "search";
    public static final String REPLACE = "replace";
    private static final String splitChar = "#;#";
    private static final int MAX_COUNT = 5;

    public static Properties getHistoryProperties() {
        IFile file = ModelHelper.getFileByName("search.properties");
        Properties properties = new Properties();
        try {
            properties.load(file.getContents());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return properties;
    }

    public static String[] getHistory(Properties properties, String flag) {
        String history = properties.getProperty(flag);
        if (history == null) {
            return new String[0];
        }
        return history.split(splitChar);
    }

    public static void saveHistory(String[] historyArray, String currInfo, String flag) {
        StringBuilder sb = new StringBuilder(currInfo.trim());
        int i = 0;
        while (i < historyArray.length) {
            if (i == 5) break;
            if (!historyArray[i].equals(currInfo.trim())) {
                sb.append(splitChar).append(historyArray[i]);
            }
            ++i;
        }
        Properties properties = SearchReplaceHelper.getHistoryProperties();
        properties.put(flag, sb.toString());
        try {
            IFile file = ModelHelper.getFileByName("search.properties");
            FileOutputStream fos = new FileOutputStream(file.getLocation().toOSString());
            properties.store(fos, "bookchao");
            ((OutputStream)fos).close();
            file.refreshLocal(1, null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public static void replaceAll(String storyId, String fileId, String searchText, String replaceText) {
        org.apache.lucene.document.Document[] docs = IndexService.query(storyId, fileId, searchText);
        String regular = IndexService.getRegular(searchText);
        Element explorerRootElement = ExplorerModelHelper.getElement(null);
        int i = 0;
        while (i < docs.length) {
            fileId = docs[i].get("f");
            String location = ExplorerModelHelper.getElementById(explorerRootElement, fileId).attributeValue("location");
            IFile file = ModelHelper.getFileByName(location);
            Document fileDoc = ModelHelper.getDocument(file);
            String content = ModelHelper.getContent(fileDoc);
            content = content.replaceAll(regular, replaceText);
            ModelHelper.setContent(fileDoc, content);
            ModelHelper.saveDocument(fileDoc, file);
            WJ.reload(fileId);
            ++i;
        }
    }
}

