/*
 * Decompiled with CFR 0.152.
 */
package wj.ap.search;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.document.Document;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.part.ViewPart;
import wj.ap.explorer.ExplorerModelHelper;
import wj.ap.explorer.ExplorerView;
import wj.ap.explorer.FileEditorInput;
import wj.ap.file.editor.ITextEditor;
import wj.ap.search.IndexService;
import wj.ap.search.SearchResultViewHelper;
import wj.ap.sys.Activator;
import wj.ap.textviewer.TextViewer;
import wj.ap.util.WJ;

public class SearchResultView
extends ViewPart
implements IPropertyChangeListener {
    private Composite parent;
    private Tree tree;
    private String[] terms;
    private IEditorPart currEditorPart;
    private Set<String> searchFileSet = new HashSet<String>();
    private Map<String, Object> nodeIndex = new HashMap<String, Object>(3);

    public void createPartControl(Composite parent) {
        this.parent = parent;
        this.listenBroughtTopEditor();
        Activator.getDefault().addPropertyChangeListener(this);
        this.setTitleToolTip("\u641c\u7d22\u7ed3\u679c");
    }

    private void addListener() {
        this.tree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TreeItem treeItem = SearchResultView.this.tree.getSelection()[0];
                SearchResultView.this.selectNode(treeItem);
            }
        });
        Display display = Display.getDefault();
        Font font = display.getSystemFont();
        final Color yellow = display.getSystemColor(7);
        Color blue = display.getSystemColor(9);
        final TextStyle style1 = new TextStyle(font, yellow, blue);
        this.tree.addListener(42, new Listener(){

            public void handleEvent(Event event) {
                TreeItem treeItem = (TreeItem)event.item;
                String flag = (String)treeItem.getData("flag");
                if (flag.equals("word") && !treeItem.isDisposed()) {
                    TextLayout textLayout = new TextLayout((Device)Display.getDefault());
                    textLayout.setText((String)treeItem.getData("text"));
                    SearchResultView.this.setTreeItemText(treeItem, textLayout, style1);
                    textLayout.draw(event.gc, treeItem.getBounds().x, treeItem.getBounds().y);
                }
            }
        });
        final Color red = this.tree.getDisplay().getSystemColor(3);
        this.tree.addListener(40, new Listener(){

            public void handleEvent(Event event) {
                event.detail &= 0xFFFFFFDF;
                if ((event.detail & 2) == 0) {
                    return;
                }
                int clientWidth = ((SearchResultView)SearchResultView.this).tree.getClientArea().width;
                GC gc = event.gc;
                Color oldForeground = gc.getForeground();
                Color oldBackground = gc.getBackground();
                gc.setForeground(red);
                gc.setBackground(yellow);
                gc.fillGradientRectangle(0, event.y, clientWidth, event.height, false);
                gc.setForeground(oldForeground);
                gc.setBackground(oldBackground);
                event.detail &= 0xFFFFFFFD;
            }
        });
        this.tree.addMouseWheelListener(new MouseWheelListener(){

            public void mouseScrolled(MouseEvent e) {
                Event event = new Event();
                event.type = 1;
                event.keyCode = e.count > 0 ? 0x1000001 : 0x1000002;
                SearchResultView.this.tree.getDisplay().post(event);
            }
        });
    }

    private void selectNode(TreeItem treeItem) {
        this.setHightlight(treeItem);
        this.setNodeIndex(treeItem);
    }

    private void setHightlight(TreeItem treeItem) {
        String flag = (String)treeItem.getData("flag");
        if (flag.equals("story")) {
            return;
        }
        if (flag.equals("file")) {
            ExplorerView explorer = (ExplorerView)WJ.BroughtToTop(ExplorerView.class.getName());
            explorer.openEditor((String)treeItem.getData());
            return;
        }
        if (flag.equals("word")) {
            this.setSelectWordNode(treeItem);
        }
    }

    private void setNodeIndex(TreeItem treeItem) {
        this.nodeIndex.clear();
        String flag = (String)treeItem.getData("flag");
        if (flag.equals("story")) {
            this.nodeIndex.put("storyItem", treeItem);
            return;
        }
        if (flag.equals("file")) {
            TreeItem storyItem = treeItem.getParentItem();
            this.nodeIndex.put("storyItem", storyItem);
            this.nodeIndex.put("fileItem", treeItem);
        }
        if (flag.equals("word")) {
            TreeItem fileItem = treeItem.getParentItem();
            TreeItem storyItem = fileItem.getParentItem();
            this.nodeIndex.put("storyItem", storyItem);
            this.nodeIndex.put("fileItem", fileItem);
            this.nodeIndex.put("wordItem", treeItem);
            this.nodeIndex.put("wordIndex", fileItem.indexOf(treeItem));
        }
    }

    private void setSelectWordNode(TreeItem wordItem) {
        String fileId = (String)wordItem.getParentItem().getData();
        ((ExplorerView)WJ.BroughtToTop(ExplorerView.class.getName())).openEditor(fileId);
        IEditorPart editorPart = WJ.getActivePage().getActiveEditor();
        TextViewer viewer = ((ITextEditor)editorPart).getTextViewer();
        StyledText styledText = viewer.getTextWidget();
        int lineIndex = (Integer)wordItem.getData("lineIndex");
        styledText.setLineBackground(0, styledText.getLineCount(), Display.getCurrent().getSystemColor(1));
        styledText.setLineBackground(lineIndex, 1, Display.getCurrent().getSystemColor(5));
        Map matcher = (Map)wordItem.getData("matcher");
        int lineOffset = styledText.getOffsetAtLine(lineIndex);
        int start = lineOffset + (Integer)matcher.get("start");
        int end = lineOffset + (Integer)matcher.get("end");
        viewer.setSelectedRange(start, end - start);
        viewer.getTextWidget().showSelection();
        HashMap<IEditorPart, String> map = new HashMap<IEditorPart, String>(1);
        map.put(editorPart, String.valueOf(start) + ";" + (end - start));
        Activator.getDefault().invoke("eventSelectSearchWord", map);
    }

    private void setTreeItemText(TreeItem treeItem, TextLayout textLayout, TextStyle style) {
        Pattern pattern = (Pattern)treeItem.getData("pattern");
        String text = (String)treeItem.getData("text");
        Matcher matcher = pattern.matcher(text);
        while (matcher.find()) {
            textLayout.setStyle(style, matcher.start(), matcher.end() - 1);
        }
        treeItem.setData("textLayout", (Object)textLayout);
    }

    private int createItem(Document[] docs) {
        String currStoryId = "";
        String currFileId = "";
        TreeItem storyItem = null;
        TreeItem fileItem = null;
        int count = 0;
        int i = 0;
        while (i < docs.length) {
            Document doc = docs[i];
            if (doc.get("s").equals(currStoryId)) {
                currFileId = doc.get("f");
                fileItem = new TreeItem(storyItem, 0);
                fileItem.setText(ExplorerModelHelper.getElement(currFileId).attributeValue("name"));
                fileItem.setData("flag", (Object)"file");
                fileItem.setData((Object)currFileId);
            } else {
                currStoryId = doc.get("s");
                storyItem = new TreeItem(this.tree, 0);
                storyItem.setData("flag", (Object)"story");
                storyItem.setText(ExplorerModelHelper.getElement(currStoryId).attributeValue("name"));
                currFileId = doc.get("f");
                fileItem = new TreeItem(storyItem, 0);
                fileItem.setText(ExplorerModelHelper.getElement(currFileId).attributeValue("name"));
                fileItem.setData("flag", (Object)"file");
                fileItem.setData((Object)currFileId);
            }
            count += IndexService.createSearchResultTreeItem(this.terms[2], currFileId, fileItem);
            ++i;
        }
        return count;
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (e.getProperty().equals("eventSearch")) {
            this.terms = ((String)e.getNewValue()).split("\n");
            this.search();
        }
        if (e.getProperty().equals("eventNext")) {
            boolean forward = (Boolean)e.getNewValue();
            this.next(forward);
        }
        if (e.getProperty().equals("eventSearchRemoveAll")) {
            if (this.tree != null) {
                this.tree.dispose();
            }
            this.parent.layout();
        }
    }

    private void search() {
        if (this.tree != null) {
            this.tree.dispose();
        }
        this.tree = new Tree(this.parent, 68356);
        Document[] docs = IndexService.query(this.terms[0], this.terms[1], this.terms[2]);
        this.searchFileSet.clear();
        int i = 0;
        while (i < docs.length) {
            this.searchFileSet.add(docs[i].get("f"));
            ++i;
        }
        int count = this.createItem(docs);
        Activator.getDefault().invoke("eventSearchResult", count);
        this.addListener();
        this.tree.pack();
        this.parent.layout();
        this.tree.deselectAll();
        this.nodeIndex.clear();
        this.next(Boolean.parseBoolean(this.terms[3]));
    }

    private void initSelectWordNode(TreeItem fileTreeItem) {
        fileTreeItem.getParentItem().setExpanded(true);
        fileTreeItem.setExpanded(true);
        boolean forward = Boolean.parseBoolean(this.terms[3]);
        TreeItem selectTreeItem = forward ? fileTreeItem.getItem(0) : fileTreeItem.getItem(fileTreeItem.getItemCount() - 1);
        this.tree.setSelection(selectTreeItem);
        this.selectNode(selectTreeItem);
    }

    private TreeItem getFileTreeItem(String fileId) {
        TreeItem item = null;
        if (this.tree.isDisposed()) {
            return null;
        }
        TreeItem[] books = this.tree.getItems();
        int i = 0;
        while (i < books.length) {
            TreeItem[] files = books[i].getItems();
            int j = 0;
            while (j < files.length) {
                String fileIdInItem = (String)files[j].getData();
                if (fileIdInItem.equals(fileId)) {
                    return files[j];
                }
                ++j;
            }
            ++i;
        }
        return item;
    }

    private void next(boolean forward) {
        if (this.tree.getItemCount() == 0) {
            return;
        }
        if (this.nodeIndex.isEmpty()) {
            TreeItem fileTreeItem = this.setFirstEditor(forward);
            this.initSelectWordNode(fileTreeItem);
        } else {
            Integer wordIndex = (Integer)this.nodeIndex.get("wordIndex");
            TreeItem storyItem = (TreeItem)this.nodeIndex.get("storyItem");
            TreeItem fileItem = (TreeItem)this.nodeIndex.get("fileItem");
            TreeItem wordItem = (TreeItem)this.nodeIndex.get("wordItem");
            TreeItem selectItem = null;
            if (this.nodeIndex.containsKey("wordItem")) {
                int count;
                selectItem = wordItem == null || wordItem.isDisposed() ? ((count = fileItem.getItemCount()) == 0 ? SearchResultViewHelper.getNextFileNode(fileItem, forward) : (wordIndex >= count ? fileItem.getItem(count - 1) : fileItem.getItem(wordIndex.intValue()))) : SearchResultViewHelper.getNextWordNode(wordItem, forward);
            } else if (this.nodeIndex.containsKey("fileItem")) {
                if (fileItem.getItemCount() == 0) {
                    selectItem = SearchResultViewHelper.getNextFileNode(fileItem, forward);
                    selectItem.setExpanded(true);
                } else {
                    fileItem.setExpanded(true);
                    selectItem = fileItem.getItem(forward ? 0 : fileItem.getItemCount() - 1);
                }
            } else if (this.nodeIndex.containsKey("storyItem")) {
                storyItem.setExpanded(true);
                selectItem = storyItem.getItem(forward ? 0 : storyItem.getItemCount() - 1);
                selectItem.setExpanded(true);
            }
            String flag = (String)selectItem.getData("flag");
            if (flag.equals("story")) {
                selectItem.setExpanded(true);
            }
            if (flag.equals("file")) {
                selectItem.getParentItem().setExpanded(true);
                selectItem.setExpanded(true);
            }
            if (flag.equals("word")) {
                selectItem.getParentItem().getParentItem().setExpanded(true);
                selectItem.getParentItem().setExpanded(true);
            }
            this.tree.setSelection(selectItem);
            this.selectNode(selectItem);
        }
    }

    private TreeItem setFirstEditor(boolean forward) {
        TreeItem fileTreeItem;
        IEditorPart editor = WJ.getActivePage().getActiveEditor();
        if (editor == null) {
            fileTreeItem = this.getFirstResultEditor(forward);
        } else {
            FileEditorInput input = (FileEditorInput)editor.getEditorInput();
            String currFileId = input.getExplorerNode().attributeValue("id");
            fileTreeItem = this.getFileTreeItem(currFileId);
            if (fileTreeItem == null) {
                fileTreeItem = this.getFirstResultEditor(forward);
            } else {
                this.setCurrEditor((IWorkbenchPart)editor);
            }
        }
        return fileTreeItem;
    }

    private TreeItem getFirstResultEditor(boolean forward) {
        TreeItem bookTreeItem = forward ? this.tree.getItem(0) : this.tree.getItem(this.tree.getItemCount() - 1);
        TreeItem fileTreeItem = forward ? bookTreeItem.getItem(0) : bookTreeItem.getItem(bookTreeItem.getItemCount() - 1);
        String currFileId = (String)fileTreeItem.getData();
        ExplorerView explorer = (ExplorerView)WJ.BroughtToTop(ExplorerView.class.getName());
        explorer.openEditor(currFileId);
        return fileTreeItem;
    }

    public void setFocus() {
    }

    public void dispose() {
        Activator.getDefault().removePropertyChangeListener(this);
        IEditorReference[] editorRefArray = WJ.getActivePage().getEditorReferences();
        Color backgroudColor = Display.getCurrent().getSystemColor(1);
        int i = 0;
        while (i < editorRefArray.length) {
            IEditorPart editorPart = editorRefArray[i].getEditor(false);
            if (editorPart instanceof ITextEditor) {
                StyledText styledText = ((ITextEditor)editorPart).getTextViewer().getTextWidget();
                styledText.setLineBackground(0, styledText.getLineCount(), backgroudColor);
                SearchResultViewHelper.clearSearchStyleRange(styledText);
            }
            ++i;
        }
        this.searchFileSet.clear();
    }

    private void listenBroughtTopEditor() {
        WJ.getActivePage().addPartListener(new IPartListener2(){

            public void partVisible(IWorkbenchPartReference partRef) {
            }

            public void partOpened(IWorkbenchPartReference partRef) {
            }

            public void partInputChanged(IWorkbenchPartReference partRef) {
            }

            public void partHidden(IWorkbenchPartReference partRef) {
            }

            public void partDeactivated(IWorkbenchPartReference partRef) {
            }

            public void partClosed(IWorkbenchPartReference partRef) {
            }

            public void partBroughtToTop(IWorkbenchPartReference partRef) {
                SearchResultView.this.setCurrEditor(partRef.getPart(false));
            }

            public void partActivated(IWorkbenchPartReference partRef) {
            }
        });
    }

    private void setCurrEditor(IWorkbenchPart part) {
        if (part instanceof ITextEditor) {
            this.currEditorPart = (IEditorPart)part;
            FileEditorInput editorInput = (FileEditorInput)this.currEditorPart.getEditorInput();
            String fileId = editorInput.getExplorerNode().attributeValue("id");
            if (!this.searchFileSet.contains(fileId)) {
                return;
            }
            this.handleCurrEditor(fileId);
        }
    }

    private void handleCurrEditor(String fileId) {
        SearchResultViewHelper.setKeywordBackgroud(this.terms[2]);
        this.listenDocumentModify(fileId);
    }

    private void listenDocumentModify(String fileId) {
        final TreeItem fileItem = this.getFileTreeItem(fileId);
        TextViewer editor = ((ITextEditor)this.currEditorPart).getTextViewer();
        editor.addTextListener(new ITextListener((org.eclipse.jface.text.TextViewer)editor){
            private final /* synthetic */ org.eclipse.jface.text.TextViewer val$editor;
            {
                this.val$editor = textViewer;
            }

            public void textChanged(TextEvent event) {
                SearchResultView.this.clearWordNode(fileItem);
                IndexService.createSearchResultTreeItemByContent(SearchResultView.this.terms[2], this.val$editor.getTextWidget().getText(), fileItem);
                fileItem.setExpanded(true);
            }
        });
    }

    private void clearWordNode(TreeItem fileItem) {
        if (fileItem.isDisposed() || fileItem.getItemCount() == 0) {
            return;
        }
        TreeItem[] wordItems = fileItem.getItems();
        int i = 0;
        while (i < wordItems.length) {
            TextLayout textLayout = (TextLayout)wordItems[i].getData("textLayout");
            if (textLayout != null) {
                textLayout.dispose();
                textLayout = null;
            }
            ++i;
        }
        fileItem.removeAll();
    }
}

