/*
 * Decompiled with CFR 0.152.
 */
package wj.ap.search;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IRegion;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import wj.ap.explorer.ExplorerView;
import wj.ap.file.editor.ITextEditor;
import wj.ap.search.IndexService;
import wj.ap.textviewer.TextViewer;
import wj.ap.util.WJ;

public class SearchResultViewHelper {
    private static Color searchForegroud = Display.getCurrent().getSystemColor(5);
    private static Color searchBackgroud = Display.getCurrent().getSystemColor(10);
    private static Color defaultForegroud = Display.getCurrent().getSystemColor(2);
    private static Color defaultBackgroud = Display.getCurrent().getSystemColor(1);

    public static TreeItem getNextStoryNode(TreeItem storyItem, boolean forward) {
        Tree tree = storyItem.getParent();
        int index = tree.indexOf(storyItem);
        index = forward ? ++index : --index;
        index = index >= tree.getItemCount() ? 0 : index;
        index = index < 0 ? tree.getItemCount() - 1 : index;
        return tree.getItem(index);
    }

    public static TreeItem getNextFileNode(TreeItem fileItem, boolean forward) {
        TreeItem storyItem = fileItem.getParentItem();
        int index = storyItem.indexOf(fileItem);
        int n = index = forward ? ++index : --index;
        if (index >= storyItem.getItemCount()) {
            storyItem = SearchResultViewHelper.getNextStoryNode(storyItem, forward);
            return storyItem.getItem(0);
        }
        if (index < 0) {
            storyItem = SearchResultViewHelper.getNextStoryNode(storyItem, forward);
            return storyItem.getItem(storyItem.getItemCount() - 1);
        }
        return storyItem.getItem(index);
    }

    public static TreeItem getNextWordNode(TreeItem wordItem, boolean forward) {
        TreeItem fileItem = wordItem.getParentItem();
        int index = fileItem.indexOf(wordItem);
        int n = index = forward ? ++index : --index;
        if (index >= fileItem.getItemCount() || index < 0) {
            fileItem = SearchResultViewHelper.getNextFileNode(fileItem, forward);
            ExplorerView explorer = (ExplorerView)WJ.BroughtToTop(ExplorerView.class.getName());
            explorer.openEditor((String)fileItem.getData());
            return fileItem.getItem(forward ? 0 : fileItem.getItemCount() - 1);
        }
        return fileItem.getItem(index);
    }

    public static void setKeywordBackgroud(String searchText) {
        TextViewer viewer = ((ITextEditor)WJ.getActivePage().getActiveEditor()).getTextViewer();
        FindReplaceDocumentAdapter findDdapater = new FindReplaceDocumentAdapter(viewer.getDocument());
        StyledText styledText = viewer.getTextWidget();
        SearchResultViewHelper.clearSearchStyleRange(styledText);
        try {
            String searchRegular = IndexService.getRegular(searchText);
            SearchResultViewHelper.setKeywordBackgroud(findDdapater, 0, searchRegular, styledText);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public static void clearSearchStyleRange(StyledText styledText) {
        StyleRange[] rangArray = styledText.getStyleRanges();
        int i = 0;
        while (i < rangArray.length) {
            StyleRange range = rangArray[i];
            if (!range.underline && range.background != null && range.background.equals((Object)searchBackgroud)) {
                range.background = defaultBackgroud;
                range.foreground = defaultForegroud;
                styledText.setStyleRange(range);
            }
            ++i;
        }
    }

    public static void setKeywordBackgroud(FindReplaceDocumentAdapter findDdapater, int offset, String searchRegular, StyledText styledText) throws BadLocationException {
        if (offset >= styledText.getText().length()) {
            return;
        }
        IRegion region = findDdapater.find(offset, searchRegular, true, false, false, true);
        if (region != null) {
            StyleRange range = new StyleRange(region.getOffset(), region.getLength(), searchForegroud, searchBackgroud);
            styledText.setStyleRange(range);
            SearchResultViewHelper.setKeywordBackgroud(findDdapater, region.getOffset() + region.getLength(), searchRegular, styledText);
        }
    }
}

