/*
 * Decompiled with CFR 0.152.
 */
package wj.ap.textviewer;

import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorReference;
import wj.ap.action.CreateNodeFileHelper;
import wj.ap.explorer.ExplorerHelper;
import wj.ap.explorer.ExplorerModelHelper;
import wj.ap.file.editor.ITextEditor;
import wj.ap.file.editor.MultiFileHandlerHelper;
import wj.ap.file.view.RoleManagerView;
import wj.ap.textviewer.TextConfiguation;
import wj.ap.textviewer.TextViewer;
import wj.ap.util.ModelHelper;
import wj.ap.util.StatusHelper;
import wj.ap.util.WJ;

class AddRoleAction
extends Action {
    private final TextViewer textViewer;

    public AddRoleAction(TextViewer textViewer) {
        this.textViewer = textViewer;
        this.setText("\u8bbe\u7f6e\u4e3a\u89d2\u8272");
        this.setDescription("\u5c06\u9009\u62e9\u7684\u6587\u5b57\u4f5c\u4e3a\u89d2\u8272");
    }

    public void run() {
        ITextSelection selection = (ITextSelection)this.textViewer.getSelection();
        this.setEnabled(selection.getLength() != 0);
        String selectedText = selection.getText();
        int i = 0;
        while (i < selectedText.length()) {
            if (Character.isWhitespace(selectedText.charAt(i))) {
                MessageDialog.openInformation(null, (String)"\u63d0\u793a", (String)"\u6240\u9009\u6587\u5b57\u4e2d\u4e0d\u80fd\u5305\u542b\u7a7a\u683c\u6216\u5176\u4ed6\u975e\u6587\u5b57\u6027\u5b57\u7b26\uff01");
                return;
            }
            ++i;
        }
        if (this.textViewer.keywordsHelper.getAllKeyWords().contains(selection.getText())) {
            MessageDialog.openInformation(null, (String)"\u63d0\u793a", (String)("\u5df2\u7ecf\u5b58\u5728\u540d\u79f0\u4e3a\u201c" + selection.getText() + "\u201d\u7684\u89d2\u8272\u3002"));
            return;
        }
        String message = "\u60a8\u60f3\u628a\u201c" + selection.getText() + "\u201d\u8bbe\u7f6e\u4e3a\u89d2\u8272\u5417\uff1f";
        if (MessageDialog.openConfirm((Shell)this.textViewer.getControl().getShell(), (String)"\u63d0\u793a", (String)message)) {
            Node rolesNode;
            Element storyNode = ExplorerHelper.getCurrStoryElement();
            Node outlineFolderNode = storyNode.selectSingleNode("./tns:outlineFolder");
            if (outlineFolderNode == null) {
                outlineFolderNode = ExplorerModelHelper.createFolderNode(storyNode.attributeValue("location"), "outlineFolder", "\u5927\u7eb2");
                ExplorerModelHelper.insertElement(storyNode.attributeValue("id"), (Element)outlineFolderNode);
                CreateNodeFileHelper.createFolderNodeFile((Element)outlineFolderNode);
            }
            if ((rolesNode = outlineFolderNode.selectSingleNode("./tns:roles")) == null) {
                rolesNode = ExplorerModelHelper.createFileByButton((Element)outlineFolderNode, "roles", "\u89d2\u8272\u5927\u7eb2");
            }
            Document rolesDoc = ModelHelper.getDocument(((Element)rolesNode).attributeValue("location"));
            Element roleInMom = MultiFileHandlerHelper.createNewElementInMutiFile(rolesDoc.getRootElement(), "role");
            IFile roleFile = ModelHelper.getFileByName(roleInMom.attributeValue("location"));
            Element role = ModelHelper.getDocument(roleFile).getRootElement();
            role.element("name").setText(selection.getText());
            ModelHelper.saveDocument(role.getDocument(), roleFile);
            IFile rolesModelFile = ModelHelper.getFileByName(roleInMom.getParent().attributeValue("location"));
            StatusHelper.setValue(rolesModelFile, "roleId", roleInMom.attributeValue("id"));
            this.textViewer.keywordsHelper.refreshKeywords();
            this.textViewer.keywordsHelper.countAllChapterRole();
            RoleManagerView view = (RoleManagerView)WJ.getActivePage().findView(RoleManagerView.class.getName());
            if (view != null) {
                view.update(rolesDoc);
            }
            IEditorReference[] editors = WJ.getActivePage().getEditorReferences();
            int i2 = 0;
            while (i2 < editors.length) {
                if (editors[i2].getEditor(false) instanceof ITextEditor) {
                    TextViewer textViewer = ((ITextEditor)editors[i2].getEditor(false)).getTextViewer();
                    textViewer.unconfigure();
                    textViewer.configure(new TextConfiguation(this.textViewer.keywordsHelper));
                }
                ++i2;
            }
        }
    }
}

