/*
 * Decompiled with CFR 0.152.
 */
package wj.ap.textviewer;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import wj.ap.textviewer.KeywordsHelper;

public class KeyWordRule
implements IPredicateRule {
    protected static final int UNDEFINED = -1;
    protected IToken fDefaultToken;
    protected int fColumn = -1;
    protected Map<String, IToken> fWords = new HashMap<String, IToken>();
    private StringBuffer fBuffer = new StringBuffer();
    private boolean fIgnoreCase = false;
    private KeywordsHelper keywordsHelper;

    public KeyWordRule(IToken defaultToken, boolean ignoreCase, KeywordsHelper keywordsHelper) {
        Assert.isNotNull((Object)defaultToken);
        this.fDefaultToken = defaultToken;
        this.fIgnoreCase = ignoreCase;
        this.keywordsHelper = keywordsHelper;
    }

    public KeyWordRule(IToken defaultToken, KeywordsHelper keywordsHelper) {
        Assert.isNotNull((Object)defaultToken);
        this.fDefaultToken = defaultToken;
        this.fIgnoreCase = false;
        this.keywordsHelper = keywordsHelper;
    }

    public void addWord(String word, IToken token) {
        Assert.isNotNull((Object)word);
        Assert.isNotNull((Object)token);
        if (this.fIgnoreCase) {
            word = word.toLowerCase();
        }
        this.fWords.put(word, token);
    }

    public void setColumnConstraint(int column) {
        if (column < 0) {
            column = -1;
        }
        this.fColumn = column;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        int c = scanner.read();
        if (c != -1 && this.isWordStart((char)c) && (this.fColumn == -1 || this.fColumn == scanner.getColumn() - 1)) {
            IToken token;
            this.fBuffer.setLength(0);
            do {
                this.fBuffer.append((char)c);
            } while ((c = scanner.read()) != -1 && this.isWordStartPart(this.fBuffer.toString()));
            scanner.unread();
            String buffer = this.fBuffer.toString();
            if (this.fIgnoreCase) {
                buffer = buffer.toLowerCase();
            }
            if ((token = this.fWords.get(buffer)) != null) {
                return token;
            }
            if (this.fDefaultToken.isUndefined()) {
                this.unreadBuffer(scanner);
            }
            return this.fDefaultToken;
        }
        scanner.unread();
        return Token.UNDEFINED;
    }

    private boolean isWordStart(char c) {
        char[] charArray = this.keywordsHelper.getAllKeywordFirstLetter();
        int i = 0;
        while (i < charArray.length) {
            if (charArray[i] == c) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isWordStartPart(String part) {
        List<String> allKeyWords = this.keywordsHelper.getAllKeyWords();
        for (String keyWord : allKeyWords) {
            if (!keyWord.startsWith(part) || keyWord.equals(part)) continue;
            return true;
        }
        return false;
    }

    protected void unreadBuffer(ICharacterScanner scanner) {
        int i = this.fBuffer.length() - 1;
        while (i >= 0) {
            scanner.unread();
            --i;
        }
    }

    public IToken getSuccessToken() {
        return Token.UNDEFINED;
    }

    public IToken evaluate(ICharacterScanner scanner, boolean resume) {
        return this.fDefaultToken;
    }
}

