/*
 * Decompiled with CFR 0.152.
 */
package wj.ap.textviewer;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Document;
import org.dom4j.Element;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import wj.ap.explorer.ExplorerHelper;
import wj.ap.explorer.ExplorerModelHelper;
import wj.ap.file.view.RoleManagerView;
import wj.ap.sys.Activator;
import wj.ap.util.ModelHelper;
import wj.ap.util.WJ;

public class KeywordsHelper
implements IPropertyChangeListener {
    private List<String> keywordsNoSorted;
    private List<String> keywords;
    private String storyId;
    private char[] firstLetterArray;
    private Map<String, Element> roleNameElementMap;
    private Map<String, Integer> keywordCountMap;
    private IFile keywordFile;
    private Document keywordDoc;
    private static Map<String, KeywordsHelper> map = new HashMap<String, KeywordsHelper>();

    public static KeywordsHelper getKeywordsHelper(String storyId) {
        KeywordsHelper helper = map.get(storyId);
        if (helper == null) {
            helper = new KeywordsHelper(storyId);
            map.put(storyId, helper);
        }
        return helper;
    }

    private KeywordsHelper(String storyId) {
        this.storyId = storyId;
        Activator.getDefault().addPropertyChangeListener(this);
    }

    public void refreshKeywords() {
        this.keywordsNoSorted = null;
        this.keywords = null;
        this.firstLetterArray = null;
        this.keywordCountMap = null;
        this.roleNameElementMap = null;
    }

    public String getKeywordDescription(String name) {
        Element role;
        if (this.roleNameElementMap == null) {
            String roleFilePath = ExplorerHelper.getOutlineFilePath(this.storyId, "roles");
            if (roleFilePath == null) {
                return null;
            }
            List<Element> roleList = ModelHelper.getRoleElements(roleFilePath);
            this.roleNameElementMap = new HashMap<String, Element>(roleList.size());
            for (Element roleInMom : roleList) {
                Element roleRoot = ModelHelper.getDocument(roleInMom.attributeValue("location")).getRootElement();
                this.roleNameElementMap.put(roleRoot.elementText("name"), roleRoot);
            }
        }
        if ((role = this.roleNameElementMap.get(name)) == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder("");
        Integer count = this.getKeywordCount().get(name);
        sb.append("\u6b21\u6570\uff1a").append(count == null ? 0 : count);
        sb.append("<br/>");
        List tagList = role.elements("tag");
        for (Element tag : tagList) {
            sb.append(tag.attributeValue("name")).append("\uff1a").append(tag.getText()).append("<br/>");
        }
        String[] parts = role.elementText("description").split("\n");
        int i = 0;
        while (i < parts.length) {
            if (!parts[i].trim().equals("")) {
                sb.append(parts[i].trim()).append("<br/>");
            }
            ++i;
        }
        return sb.toString();
    }

    public List<String> getAllKeyWords() {
        if (this.keywords == null) {
            this.keywords = new ArrayList<String>();
            List<String> keywordList = this.getKeywordInStory();
            if (keywordList == null || keywordList.isEmpty()) {
                return this.keywords;
            }
            HashMap<String, Integer> keywordCountMap = new HashMap<String, Integer>(keywordList.size());
            Map<String, Integer> oldKeywordCountMap = this.getKeywordCount();
            Iterator<String> iterator = keywordList.iterator();
            while (iterator.hasNext()) {
                String name;
                Integer count = oldKeywordCountMap.get(name = iterator.next());
                keywordCountMap.put(name, count == null ? 0 : count);
            }
            ArrayList keywordCountList = new ArrayList(keywordCountMap.entrySet());
            Collections.sort(keywordCountList, new Comparator<Map.Entry<String, Integer>>(){

                @Override
                public int compare(Map.Entry<String, Integer> o1, Map.Entry<String, Integer> o2) {
                    return o2.getValue() - o1.getValue();
                }
            });
            for (Map.Entry entry : keywordCountList) {
                this.keywords.add((String)entry.getKey());
            }
        }
        return this.keywords;
    }

    public List<String> getKeywordInStory() {
        if (this.keywordsNoSorted == null) {
            String roleFilePath = ExplorerHelper.getOutlineFilePath(this.storyId, "roles");
            if (roleFilePath == null) {
                return null;
            }
            List<String> nameList = ModelHelper.getRoleName4File(roleFilePath);
            this.keywordsNoSorted = nameList;
        }
        return this.keywordsNoSorted;
    }

    public Map<String, Integer> getKeywordCount() {
        if (this.keywordCountMap == null) {
            IFile file = ModelHelper.getFileByName(String.valueOf(this.storyId) + File.separator + "keyword.xml");
            Element root = ModelHelper.getDocument(file).getRootElement();
            List chapterList = root.elements("chapter");
            this.keywordCountMap = new HashMap<String, Integer>();
            for (Element chapter : chapterList) {
                List keywordList = chapter.elements("keyword");
                for (Element keyword : keywordList) {
                    String name = keyword.attributeValue("name");
                    int count = Integer.parseInt(keyword.attributeValue("count"));
                    if (this.keywordCountMap.keySet().contains(name)) {
                        this.keywordCountMap.put(name, count += this.keywordCountMap.get(name).intValue());
                        continue;
                    }
                    this.keywordCountMap.put(name, count);
                }
            }
        }
        return this.keywordCountMap;
    }

    public char[] getAllKeywordFirstLetter() {
        if (this.firstLetterArray == null) {
            HashSet<Character> firstLetterSet = new HashSet<Character>();
            this.keywords = this.getAllKeyWords();
            for (String keyword : this.keywords) {
                if (keyword == null || keyword.equals("")) continue;
                firstLetterSet.add(Character.valueOf(keyword.charAt(0)));
            }
            this.firstLetterArray = new char[firstLetterSet.size()];
            int i = 0;
            Iterator iterator = firstLetterSet.iterator();
            while (iterator.hasNext()) {
                char c;
                this.firstLetterArray[i] = c = ((Character)iterator.next()).charValue();
                ++i;
            }
        }
        return this.firstLetterArray;
    }

    public void saveKeywordCount(String chapterId, Map<String, Integer> map) {
        if (this.keywordFile == null) {
            String path = String.valueOf(ExplorerModelHelper.getElement(this.storyId).attributeValue("location")) + File.separator + "keyword.xml";
            this.keywordFile = ModelHelper.getFileByName(path);
        }
        if (this.keywordDoc == null) {
            this.keywordDoc = ModelHelper.getDocument(this.keywordFile);
        }
        List chapterList = this.keywordDoc.getRootElement().elements("chapter");
        Element currChapterElement = null;
        for (Element chapter : chapterList) {
            if (chapter == null || !chapter.attributeValue("id").equals(chapterId)) continue;
            currChapterElement = chapter;
        }
        if (currChapterElement == null) {
            currChapterElement = this.keywordDoc.getRootElement().addElement("tns:chapter");
            currChapterElement.addAttribute("id", chapterId);
        } else {
            List keywordList = currChapterElement.elements();
            for (Element keyword : keywordList) {
                currChapterElement.remove(keyword);
            }
        }
        Set<String> keySet = map.keySet();
        for (String key : keySet) {
            Element keyword = currChapterElement.addElement("tns:keyword");
            keyword.addAttribute("name", key);
            keyword.addAttribute("count", "" + map.get(key));
        }
        ModelHelper.saveDocument(this.keywordDoc, this.keywordFile);
        this.keywordCountMap = null;
        this.keywordCountMap = this.getKeywordCount();
        RoleManagerView view = (RoleManagerView)WJ.getActivePage().findView(RoleManagerView.class.getName());
        if (view != null) {
            view.refreshCount(this.keywordCountMap);
        }
    }

    public void countAllChapterRole() {
        List fileNodeList = ExplorerModelHelper.getElement(this.storyId).selectNodes("//tns:chapter");
        for (Element fileNode : fileNodeList) {
            String content = ModelHelper.getContent(ModelHelper.getDocument(fileNode.attributeValue("location")));
            this.saveKeywordCount(fileNode.attributeValue("id"), this.countAllRole(content));
        }
    }

    public Map<String, Integer> countAllRole(String content) {
        HashMap<String, Integer> currKeywordCountmap = new HashMap<String, Integer>();
        List<String> keywordList = this.getAllKeyWords();
        if (keywordList == null || keywordList.isEmpty()) {
            return currKeywordCountmap;
        }
        StringBuilder sb = new StringBuilder();
        for (String keyword : keywordList) {
            sb.append(keyword).append('|');
        }
        String regex = sb.substring(0, sb.length() - 1);
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            String keyword = matcher.group();
            if (currKeywordCountmap.containsKey(keyword)) {
                currKeywordCountmap.put(keyword, (Integer)currKeywordCountmap.get(keyword) + 1);
                continue;
            }
            currKeywordCountmap.put(keyword, 1);
        }
        return currKeywordCountmap;
    }

    public void propertyChange(PropertyChangeEvent event) {
        String eventName = event.getProperty();
        if (eventName.equals("eventRoleCreate") || eventName.equals("eventRoleTagModify") || eventName.equals("eventRoleModify")) {
            this.refreshKeywords();
        }
    }
}

