/*
 * Decompiled with CFR 0.152.
 */
package wj.ap.textviewer;

import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import wj.ap.textviewer.KeywordsHelper;
import wj.ap.textviewer.TextContentAssistent;
import wj.ap.textviewer.TextHover;
import wj.ap.textviewer.TextPartitionScanner;

public class TextConfiguation
extends SourceViewerConfiguration {
    private KeywordsHelper keywordsHelper;

    public TextConfiguation(KeywordsHelper keywordsHelper) {
        this.keywordsHelper = keywordsHelper;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler presentationReconciler = new PresentationReconciler();
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)new TextPartitionScanner(this.keywordsHelper));
        presentationReconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        presentationReconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        return presentationReconciler;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        ContentAssistant assistant = new ContentAssistant();
        TextContentAssistent processor = new TextContentAssistent(this.keywordsHelper);
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "key_word");
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "comment");
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__dftl_partition_content_type");
        assistant.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
        assistant.enableAutoActivation(true);
        assistant.setAutoActivationDelay(200);
        assistant.enableAutoInsert(true);
        return assistant;
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        return new TextHover(sourceViewer, this.keywordsHelper);
    }
}

