/*
 * Decompiled with CFR 0.152.
 */
package wj.ap.textviewer;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import wj.ap.textviewer.KeywordsHelper;
import wj.ap.textviewer.TextDocumentReader;

public class TextContentAssistent
implements IContentAssistProcessor {
    private KeywordsHelper keywordsHelper;

    public TextContentAssistent(KeywordsHelper keywordsHelper) {
        this.keywordsHelper = keywordsHelper;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        List<ICompletionProposal> completionProposalList = this.getAssistentData(viewer.getDocument(), offset);
        ICompletionProposal[] completionProposalArray = new ICompletionProposal[completionProposalList.size()];
        return completionProposalList.toArray(completionProposalArray);
    }

    public List<ICompletionProposal> getAssistentData(IDocument doc, int offset) {
        ArrayList<ICompletionProposal> matchKeywords = new ArrayList<ICompletionProposal>();
        List<String> keywords = this.keywordsHelper.getAllKeyWords();
        TextDocumentReader reader = new TextDocumentReader(doc, offset, this.keywordsHelper);
        String backwardStr = reader.readBackwardNotWhiteSpaceText(4);
        int i = 0;
        while (i < backwardStr.length()) {
            String str = backwardStr.substring(i);
            for (String keyword : keywords) {
                if (!keyword.startsWith(str)) continue;
                int replacementOffset = offset - str.length();
                int replacementLength = str.length();
                int cursorPosition = keyword.length();
                matchKeywords.add((ICompletionProposal)new CompletionProposal(keyword, replacementOffset, replacementLength, cursorPosition));
            }
            ++i;
        }
        return matchKeywords;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return this.keywordsHelper.getAllKeywordFirstLetter();
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }
}

