/*
 * Decompiled with CFR 0.152.
 */
package wj.ap.textviewer;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import wj.ap.textviewer.KeywordsHelper;

public class TextDocumentReader {
    private IDocument document;
    private KeywordsHelper keywordsHelper;
    private int offset;

    public TextDocumentReader(IDocument document, int offset, KeywordsHelper keywordsHelper) {
        this.offset = offset;
        this.document = document;
        this.keywordsHelper = keywordsHelper;
    }

    public String readBackwardNotWhiteSpaceText(int num) {
        StringBuffer buf = new StringBuffer();
        int location = this.offset;
        int i = 0;
        while (i < num) {
            if (--location < 0) break;
            try {
                char c = this.document.getChar(location);
                if (Character.isWhitespace(c) || c == '\uffff') break;
                buf.append(c);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
            ++i;
        }
        return buf.reverse().toString();
    }

    public String readForewardNotWhiteSpaceText(int num) {
        StringBuffer buf = new StringBuffer();
        int location = this.offset;
        int i = 0;
        while (i < num) {
            if (++location >= this.document.getLength()) break;
            try {
                char c = this.document.getChar(location);
                if (Character.isWhitespace(c) || c == '\uffff') break;
                buf.append(c);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
            ++i;
        }
        return buf.toString();
    }

    public char readCurrent() {
        try {
            return this.document.getChar(this.offset);
        }
        catch (BadLocationException e) {
            return '\uffff';
        }
    }

    public String getKeywordByCurrorLocation() {
        char currentChar = this.readCurrent();
        if (currentChar == '\uffff') {
            return null;
        }
        ArrayList<String> containList = new ArrayList<String>();
        List<String> allKeywordList = this.keywordsHelper.getAllKeyWords();
        for (String keyword : allKeywordList) {
            if (keyword.indexOf(currentChar) == -1) continue;
            containList.add(keyword);
        }
        for (String keyword : containList) {
            int location = keyword.indexOf(currentChar);
            StringBuffer sb = new StringBuffer();
            sb.append(this.readBackwardNotWhiteSpaceText(location));
            sb.append(currentChar);
            sb.append(this.readForewardNotWhiteSpaceText(keyword.length() - location - 1));
            if (!sb.toString().equals(keyword)) continue;
            return keyword;
        }
        return null;
    }
}

