/*
 * Decompiled with CFR 0.152.
 */
package wj.ap.textviewer;

import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.DefaultTextHover;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.widgets.Shell;
import wj.ap.textviewer.KeywordsHelper;
import wj.ap.textviewer.TextDocumentReader;

public class TextHover
extends DefaultTextHover
implements ITextHoverExtension {
    private int offset;
    private KeywordsHelper keywordsHelper;

    public TextHover(ISourceViewer sourceViewer, KeywordsHelper keywordsHelper) {
        super(sourceViewer);
        this.keywordsHelper = keywordsHelper;
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        this.offset = offset;
        return new Region(offset, 1);
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        TextDocumentReader reader = new TextDocumentReader(textViewer.getDocument(), this.offset, this.keywordsHelper);
        return this.keywordsHelper.getKeywordDescription(reader.getKeywordByCurrorLocation());
    }

    public IInformationControlCreator getHoverControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                DefaultInformationControl control = new DefaultInformationControl(parent, false);
                return control;
            }
        };
    }
}

