/*
 * Decompiled with CFR 0.152.
 */
package wj.ap.textviewer;

import java.util.List;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.RuleBasedPartitionScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import wj.ap.textviewer.KeyWordRule;
import wj.ap.textviewer.KeywordsHelper;

public class TextPartitionScanner
extends RuleBasedPartitionScanner {
    public static final String COMMENT = "comment";
    public static final String KEY_WORD = "key_word";

    public TextPartitionScanner(KeywordsHelper keywordsHelper) {
        Token commentToken = new Token((Object)COMMENT);
        commentToken.setData((Object)new TextAttribute(Display.getCurrent().getSystemColor(5)));
        IPredicateRule[] rules = new IPredicateRule[2];
        rules[0] = new SingleLineRule("//", "\n", (IToken)commentToken);
        Token ruleToken = new Token((Object)new TextAttribute(Display.getCurrent().getSystemColor(2)));
        KeyWordRule rule = new KeyWordRule((IToken)ruleToken, keywordsHelper);
        List<String> allKeyWords = keywordsHelper.getAllKeyWords();
        if (allKeyWords == null) {
            return;
        }
        Color color = Display.getCurrent().getSystemColor(3);
        for (String keyWord : allKeyWords) {
            rule.addWord(keyWord, (IToken)new Token((Object)new TextAttribute(color, null, 0x40000000)));
        }
        rules[1] = rule;
        this.setPredicateRules(rules);
    }
}

