/*
 * Decompiled with CFR 0.152.
 */
package wj.ap.textviewer;

import java.io.File;
import org.dom4j.Document;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.IViewportListener;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.TextViewerUndoManager;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.RuleBasedPartitionScanner;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.IME;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IEditorReference;
import wj.ap.action.ActionFactory4ToolBar;
import wj.ap.explorer.ExplorerHelper;
import wj.ap.explorer.ExplorerView;
import wj.ap.file.editor.ITextEditor;
import wj.ap.history.HistoryHelper;
import wj.ap.search.IndexService;
import wj.ap.sys.Activator;
import wj.ap.textviewer.AddRoleAction;
import wj.ap.textviewer.KeywordsHelper;
import wj.ap.textviewer.TextConfiguation;
import wj.ap.textviewer.TextDocumentReader;
import wj.ap.util.ModelHelper;
import wj.ap.util.StatusHelper;
import wj.ap.util.WJ;

public class TextViewer
extends SourceViewer
implements IPropertyChangeListener {
    private StyledText styledText;
    KeywordsHelper keywordsHelper;
    private IFile modelFile;
    private Document modelDocument;
    private HistoryHelper history;
    private boolean isSnapshot = true;
    private boolean isCreateIndex = true;
    private boolean isPaste = true;
    private String preWord = "";
    private boolean isFirst = true;

    public TextViewer(Composite parent, Document xmlDoc) {
        this(parent, null, 68354, xmlDoc, null, null);
    }

    public TextViewer(Composite parent, Document xmlDoc, KeywordsHelper keywordsHelper) {
        this(parent, null, 68354, xmlDoc, null, keywordsHelper);
    }

    public TextViewer(Composite parent, IVerticalRuler ruler, int styles, Document xmlDoc, IDocument widgetDoc, KeywordsHelper keywordsHelper) {
        super(parent, ruler, styles);
        String toggleKeyWord;
        this.updateModel(xmlDoc, ModelHelper.getFileByName(xmlDoc.getRootElement().attributeValue("location")));
        this.styledText = this.getTextWidget();
        this.styledText.setWordWrap(true);
        this.styledText.setAlignment(16384);
        this.styledText.setDoubleClickEnabled(true);
        this.styledText.setLineSpacing(5);
        if (widgetDoc == null) {
            widgetDoc = new org.eclipse.jface.text.Document();
        }
        if ((toggleKeyWord = StatusHelper.getValue("toggleKeyWord")) == null) {
            toggleKeyWord = "on";
            StatusHelper.setValue("toggleKeyWord", "on");
        }
        if (toggleKeyWord.equals("on")) {
            this.configure(new TextConfiguation(this.keywordsHelper));
            FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)new RuleBasedPartitionScanner(), new String[0]);
            partitioner.connect(widgetDoc);
            widgetDoc.setDocumentPartitioner((IDocumentPartitioner)partitioner);
        }
        this.setDocument(widgetDoc);
        this.listener4Location();
        this.redoUndo();
        this.createIndex();
        this.insertNewLine();
        this.clickLink();
        this.addContentMenu();
        this.listnerDocumentChange4Snapshot();
        Activator.getDefault().addPropertyChangeListener(this);
    }

    public void updateModel(Document modeldoc, IFile modelFile) {
        this.modelDocument = modeldoc;
        this.modelFile = modelFile;
        this.history = new HistoryHelper(modelFile, this);
        String storyId = this.modelDocument.getRootElement().attributeValue("location").replace(File.separator, ";").split(";")[0];
        this.keywordsHelper = KeywordsHelper.getKeywordsHelper(storyId);
    }

    public void setSnapshotEnable(boolean isSnapshot) {
        this.isSnapshot = isSnapshot;
    }

    private void listener4Location() {
        this.addViewportListener(new IViewportListener(){

            public void viewportChanged(int verticalOffset) {
                if (!TextViewer.this.isSnapshot) {
                    return;
                }
                StatusHelper.setValue(TextViewer.this.modelFile, "topIndex", String.valueOf(TextViewer.this.getTopIndex()));
            }
        });
        this.styledText.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                TextViewer.this.reLoadTopIndex();
            }
        });
    }

    public void reLoadTopIndex() {
        if (!this.isSnapshot) {
            return;
        }
        String topIndex = StatusHelper.getValue(this.modelFile, "topIndex");
        if (topIndex == null) {
            topIndex = "0";
        }
        this.setTopIndex(Integer.parseInt(topIndex));
    }

    private void createIndex() {
        this.styledText.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                if (!TextViewer.this.isCreateIndex) {
                    IndexService indexServier = new IndexService();
                    String path = TextViewer.this.modelDocument.getRootElement().attributeValue("location");
                    String[] parts = path.replace(File.separator, ";").split(";");
                    try {
                        indexServier.createIndex(parts[0], parts[parts.length - 1], TextViewer.this.styledText.getText());
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                    TextViewer.this.isCreateIndex = true;
                }
            }

            public void focusGained(FocusEvent e) {
            }
        });
    }

    private void listnerDocumentChange4Snapshot() {
        this.addTextListener(new ITextListener(){

            public void textChanged(final TextEvent event) {
                if (!TextViewer.this.isSnapshot) {
                    return;
                }
                if (TextViewer.this.isFirst) {
                    TextViewer.this.isFirst = false;
                    return;
                }
                final String[] changeWords = new String[1];
                IME ime = TextViewer.this.getTextWidget().getIME();
                if (ime.getCommitCount() != 0 && ime.getCommitCount() == ime.getText().length()) {
                    changeWords[0] = ime.getText();
                } else if (ime.getCommitCount() == 0 && ime.getText().length() == 0) {
                    changeWords[0] = event.getReplacedText();
                    if (changeWords[0] == null && !event.getText().equals("") && TextViewer.this.preWord.indexOf(event.getText()) == -1) {
                        changeWords[0] = event.getText();
                    }
                }
                if (changeWords[0] != null) {
                    TextViewer.this.preWord = changeWords[0];
                    TextViewer.this.isCreateIndex = false;
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            TextViewer.this.history.createSnapshot(TextViewer.this.getTextWidget().getLineAtOffset(event.getOffset()), changeWords[0]);
                            changeWords[0] = null;
                        }
                    });
                }
            }
        });
    }

    private void clickLink() {
        this.styledText.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                if (StatusHelper.getValue("toggleKeyWord").equals("off")) {
                    return;
                }
                IDocument doc = TextViewer.this.getDocument();
                try {
                    int offset = TextViewer.this.styledText.getOffsetAtLocation(new Point(e.x, e.y));
                    TextDocumentReader reader = new TextDocumentReader(doc, offset, TextViewer.this.keywordsHelper);
                    if (reader.getKeywordByCurrorLocation() != null) {
                        Cursor cursor = new Cursor(TextViewer.this.styledText.getCursor().getDevice(), 21);
                        TextViewer.this.styledText.setCursor(cursor);
                    } else {
                        Cursor cursor = new Cursor(TextViewer.this.styledText.getCursor().getDevice(), 0);
                        TextViewer.this.styledText.setCursor(cursor);
                    }
                }
                catch (Exception ex) {
                    Cursor cursor = new Cursor(TextViewer.this.styledText.getCursor().getDevice(), 0);
                    TextViewer.this.styledText.setCursor(cursor);
                }
            }
        });
        this.styledText.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                if (StatusHelper.getValue("toggleKeyWord").equals("off")) {
                    return;
                }
                if (event.button == 1) {
                    String storyId = TextViewer.this.modelDocument.getRootElement().attributeValue("location").replace(File.separator, ";").split(";")[0];
                    try {
                        int offset = TextViewer.this.styledText.getOffsetAtLocation(new Point(event.x, event.y));
                        StyleRange range = TextViewer.this.styledText.getStyleRangeAtOffset(offset);
                        if (range != null && range.underline && range.underlineStyle == 0) {
                            String keyword = new TextDocumentReader(TextViewer.this.getDocument(), offset, TextViewer.this.keywordsHelper).getKeywordByCurrorLocation();
                            TextViewer.this.openRoleEditor(storyId);
                            Activator.getDefault().invoke("eventRoleSelectByName", keyword);
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
            }
        });
    }

    private void openRoleEditor(String storyId) {
        String location = ExplorerHelper.getOutlineFilePath(storyId, "roles");
        ExplorerView view = (ExplorerView)WJ.BroughtToTop(ExplorerView.class.getName());
        view.openEditor(location.replace(File.separator, ";").split(";")[2]);
    }

    private void insertNewLine() {
        this.styledText.addVerifyKeyListener(new VerifyKeyListener(){

            public void verifyKey(VerifyEvent event) {
                if (event.character == '\r') {
                    TextViewer.this.styledText.insert(System.getProperty("line.separator"));
                    TextViewer.this.styledText.setCaretOffset(TextViewer.this.styledText.getCaretOffset() + 2);
                }
            }
        });
    }

    private void redoUndo() {
        TextViewerUndoManager undoManager = new TextViewerUndoManager(99);
        undoManager.connect((ITextViewer)this);
        this.setUndoManager((IUndoManager)undoManager);
        this.appendVerifyKeyListener(new VerifyKeyListener(){

            public void verifyKey(VerifyEvent event) {
                if ((event.stateMask & 0x40000) != 0) {
                    event.doit = false;
                }
            }
        });
        this.styledText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if ((e.stateMask & 0x40000) == 0) {
                    return;
                }
                int operation = 0;
                if (e.character == ' ') {
                    operation = 13;
                } else if ((e.character | 0x40) == 90) {
                    operation = 1;
                } else if ((e.character | 0x40) == 89) {
                    operation = 2;
                } else if ((e.character | 0x40) == 70) {
                    ActionFactory4ToolBar.getInstance().getSearchAndReplace().run();
                }
                if (operation != 0 && TextViewer.this.canDoOperation(operation)) {
                    TextViewer.this.doOperation(operation);
                }
            }
        });
    }

    private void addContentMenu() {
        MenuManager menuMgr = new MenuManager();
        Menu menu = menuMgr.createContextMenu(this.getControl());
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ITextSelection selection = (ITextSelection)TextViewer.this.getSelection();
                if (TextViewer.this.modelDocument.getRootElement().getName().equals("chapter")) {
                    AddRoleAction setKeywordAction = new AddRoleAction(TextViewer.this);
                    manager.add((IAction)setKeywordAction);
                    setKeywordAction.setEnabled(selection.getLength() != 0);
                    manager.add((IContributionItem)new Separator());
                }
                CopyAction copyAction = new CopyAction();
                manager.add((IAction)copyAction);
                copyAction.setEnabled(selection.getLength() != 0);
                CutAction cutAction = new CutAction();
                manager.add((IAction)cutAction);
                cutAction.setEnabled(selection.getLength() != 0);
                PasteAction pasteAction = new PasteAction();
                manager.add((IAction)pasteAction);
                manager.add((IContributionItem)new Separator());
                manager.add((IAction)new ToggleKeyWordTipAction());
            }
        });
        menuMgr.setRemoveAllWhenShown(true);
        this.getControl().setMenu(menu);
    }

    public void propertyChange(PropertyChangeEvent event) {
        String eventName = event.getProperty();
        if (eventName.equals("eventRoleCreate") || eventName.equals("eventRoleTagModify") || eventName.equals("eventRoleModify")) {
            this.unconfigure();
            this.configure(new TextConfiguation(this.keywordsHelper));
        }
    }

    private class CopyAction
    extends Action {
        public CopyAction() {
            this.setText("\u590d\u5236");
        }

        public void run() {
            TextViewer.this.getTextWidget().copy();
        }
    }

    private class CutAction
    extends Action {
        public CutAction() {
            this.setText("\u526a\u5207");
        }

        public void run() {
            TextViewer.this.getTextWidget().cut();
        }
    }

    private class PasteAction
    extends Action {
        public PasteAction() {
            this.setText("\u7c98\u8d34");
        }

        public void run() {
            TextViewer.this.getTextWidget().paste();
        }
    }

    private class ToggleKeyWordTipAction
    extends Action {
        public ToggleKeyWordTipAction() {
            if (StatusHelper.getValue("toggleKeyWord").equals("on")) {
                this.setText("\u5173\u95ed\u89d2\u8272\u63d0\u793a");
            } else {
                this.setText("\u6253\u5f00\u89d2\u8272\u63d0\u793a");
            }
        }

        public void run() {
            if (StatusHelper.getValue("toggleKeyWord").equals("on")) {
                IEditorReference[] editors = WJ.getActivePage().getEditorReferences();
                int i = 0;
                while (i < editors.length) {
                    if (editors[i].getEditor(false) instanceof ITextEditor) {
                        TextViewer textViewer = ((ITextEditor)editors[i].getEditor(false)).getTextViewer();
                        textViewer.unconfigure();
                        textViewer.refresh();
                    }
                    ++i;
                }
                Cursor cursor = new Cursor(TextViewer.this.styledText.getCursor().getDevice(), 0);
                TextViewer.this.styledText.setCursor(cursor);
                StatusHelper.setValue("toggleKeyWord", "off");
            } else {
                StatusHelper.setValue("toggleKeyWord", "on");
                WJ.refreshKeywordsInEditor(TextViewer.this.keywordsHelper);
            }
        }
    }
}

