/*
 * Decompiled with CFR 0.152.
 */
package wj.ap.update;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Platform;
import wj.ap.update.Md5Helper;
import wj.ap.util.InternetHelper;
import wj.ap.util.ModelHelper;

public class FileUpdate {
    private String downloadAddress = "/at/update";

    public void update() {
        Document localVersionDoc = ModelHelper.getDocument("version.xml");
        String strUrl = String.valueOf(localVersionDoc.getRootElement().elementText("host")) + this.downloadAddress;
        InputStream is = InternetHelper.getInputStream(String.valueOf(strUrl) + "/version.xml", "GET");
        if (is == null) {
            return;
        }
        Document serverVersionDoc = ModelHelper.getDocument(is);
        IFile file = ModelHelper.getProject().getFile("version.xml");
        List serverFileList = serverVersionDoc.getRootElement().elements("file");
        List localFileList = localVersionDoc.getRootElement().elements("file");
        for (Element serverFile : serverFileList) {
            Element localFile = this.getLocalElement(serverFile, localFileList);
            if (localFile == null) {
                if (!this.downAndUpdateFile(serverFile)) continue;
                this.createElement(localVersionDoc, serverFile, file);
                continue;
            }
            if (Integer.parseInt(serverFile.attributeValue("versionNo")) <= Integer.parseInt(localFile.attributeValue("versionNo")) || !this.downAndUpdateFile(serverFile)) continue;
            this.updateElement(localVersionDoc, serverFile, localFile, file);
        }
    }

    private void createElement(Document localVersionDoc, Element serverFile, IFile versionFile) {
        Element root = localVersionDoc.getRootElement();
        Element newFile = root.addElement("tns:file");
        newFile.addAttribute("id", serverFile.attributeValue("id"));
        newFile.addAttribute("type", serverFile.attributeValue("type"));
        newFile.addAttribute("name", serverFile.attributeValue("name"));
        newFile.addAttribute("versionNo", serverFile.attributeValue("versionNo"));
        newFile.addAttribute("md5", serverFile.attributeValue("md5"));
        newFile.addAttribute("description", serverFile.attributeValue("description"));
        ModelHelper.saveDocument(localVersionDoc, versionFile);
    }

    private void updateElement(Document localVersionDoc, Element serverFile, Element localFile, IFile versionFile) {
        localFile.attribute("type").setValue(serverFile.attributeValue("type"));
        localFile.attribute("name").setValue(serverFile.attributeValue("name"));
        localFile.attribute("versionNo").setValue(serverFile.attributeValue("versionNo"));
        localFile.attribute("md5").setValue(serverFile.attributeValue("md5"));
        localFile.attribute("description").setValue(serverFile.attributeValue("description"));
        ModelHelper.saveDocument(localVersionDoc, versionFile);
    }

    private Element getLocalElement(Element serverFile, List<Element> localFileList) {
        Element targetFile = null;
        for (Element localFile : localFileList) {
            if (!localFile.attributeValue("id").equals(serverFile.attributeValue("id"))) continue;
            targetFile = localFile;
        }
        return targetFile;
    }

    private boolean downAndUpdateFile(Element serverFile) {
        String serverUrl = String.valueOf(serverFile.getDocument().getRootElement().elementText("host")) + this.downloadAddress;
        String type = serverFile.attributeValue("type");
        String fileName = serverFile.attributeValue("name");
        if (type.equals("jar")) {
            String osName = System.getProperty("os.name");
            fileName = osName.indexOf("Mac") > -1 ? "mac_" + fileName : "win_" + fileName;
        }
        InputStream is = InternetHelper.getInputStream(String.valueOf(serverUrl) + "/" + fileName, "GET");
        byte[] btArray = InternetHelper.readInputStream(is);
        boolean isOk = false;
        if (btArray != null) {
            try {
                File newFile;
                String tmpPath = String.valueOf(Platform.getInstallLocation().getURL().getPath()) + "tmp";
                File folder = new File(tmpPath);
                if (!folder.exists()) {
                    folder.mkdirs();
                }
                if (!(newFile = new File(tmpPath = String.valueOf(tmpPath) + "/" + fileName)).exists()) {
                    newFile.createNewFile();
                }
                FileOutputStream fops = new FileOutputStream(newFile);
                fops.write(btArray);
                fops.flush();
                fops.close();
                String md5 = serverFile.attributeValue("md5");
                String fileMd5 = Md5Helper.fileMD5(tmpPath);
                if (md5.equals(fileMd5)) {
                    String sysPath = Platform.getInstallLocation().getURL().getPath();
                    if (type.equals("jar")) {
                        String pluginPath = String.valueOf(sysPath) + "plugins/" + fileName;
                        File pluginFile = new File(pluginPath);
                        File tmpFile = new File(tmpPath);
                        isOk = tmpFile.renameTo(pluginFile);
                    } else if (type.equals("sensitiveWord")) {
                        String filePath = String.valueOf(sysPath) + "/workspace/_root_/" + fileName;
                        File oldFile = new File(filePath);
                        oldFile.delete();
                        isOk = newFile.renameTo(oldFile);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return isOk;
    }
}

