/*
 * Decompiled with CFR 0.152.
 */
package wj.ap.update;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.dom4j.Element;
import org.json.JSONArray;
import org.json.JSONObject;
import wj.ap.explorer.ExplorerModelHelper;
import wj.ap.login.Account;
import wj.ap.util.InternetHelper;
import wj.ap.util.ModelHelper;

public class ServerVersionAndFile {
    static final String FILE_UPDATE = "/at/file/upload";
    static final String FILE_DOWNLOAD = "/at/file/download";
    static final String FILE_DELETE = "/at/file/delete";
    static final String VERSION_COMMIT = "/at/version/commit";
    static final String VERSION_GET = "/at/version/info";

    static boolean commitVersion(JSONArray versionObject) {
        String url = String.valueOf(InternetHelper.getHost()) + VERSION_COMMIT;
        HttpPost post = new HttpPost(url);
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        Account account = Account.getInstance();
        params.add(new BasicNameValuePair("id", account.getUserId()));
        params.add(new BasicNameValuePair("tk", account.getToken()));
        params.add(new BasicNameValuePair("version", versionObject.toString()));
        UrlEncodedFormEntity entity = new UrlEncodedFormEntity(params, Charset.forName("UTF-8"));
        post.setEntity((HttpEntity)entity);
        try {
            String result = (String)InternetHelper.httpClient.execute((HttpUriRequest)post, (ResponseHandler)new ResponseHandler<String>(){

                public String handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                    StatusLine statusLine = response.getStatusLine();
                    int code = statusLine.getStatusCode();
                    if (code == 200) {
                        return EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)Charset.defaultCharset());
                    }
                    JSONObject obj = new JSONObject();
                    obj.put("success", false);
                    return obj.toString();
                }
            });
            JSONObject obj = new JSONObject(result);
            return obj.getBoolean("success");
        }
        catch (IOException e) {
            return false;
        }
    }

    static boolean commitFile(Element nodeInExplorer) {
        String content;
        String fileId;
        String url = String.valueOf(InternetHelper.getHost()) + FILE_UPDATE;
        if (!ServerVersionAndFile.commintFile(url, fileId = nodeInExplorer.attributeValue("id"), content = ModelHelper.getContent(ModelHelper.getDocument(nodeInExplorer.attributeValue("location"))))) {
            return false;
        }
        ExplorerModelHelper.updateElement(nodeInExplorer.attributeValue("id"), "isDirty", "false");
        int version = Integer.parseInt(nodeInExplorer.attributeValue("version"));
        ExplorerModelHelper.updateElement(nodeInExplorer.attributeValue("id"), "version", String.valueOf(++version));
        return true;
    }

    static boolean commintFile(String urlStr, String fileId, String content) {
        HttpPost post = new HttpPost(urlStr);
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        Account account = Account.getInstance();
        params.add(new BasicNameValuePair("id", account.getUserId()));
        params.add(new BasicNameValuePair("tk", account.getToken()));
        params.add(new BasicNameValuePair("fileId", fileId));
        params.add(new BasicNameValuePair("content", content));
        UrlEncodedFormEntity entity = new UrlEncodedFormEntity(params, Charset.forName("UTF-8"));
        post.setEntity((HttpEntity)entity);
        try {
            String result = (String)InternetHelper.httpClient.execute((HttpUriRequest)post, (ResponseHandler)new ResponseHandler<String>(){

                public String handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                    StatusLine statusLine = response.getStatusLine();
                    int code = statusLine.getStatusCode();
                    if (code == 200) {
                        return EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)Charset.defaultCharset());
                    }
                    JSONObject obj = new JSONObject();
                    obj.put("success", false);
                    return obj.toString();
                }
            });
            JSONObject obj = new JSONObject(result);
            return obj.getBoolean("success");
        }
        catch (IOException e) {
            return false;
        }
    }

    public static void main(String[] xx) {
        ServerVersionAndFile.getFileContentFromServer("22443610");
    }

    static String getFileContentFromServer(String fileId) {
        String url = String.valueOf(InternetHelper.getHost()) + FILE_DOWNLOAD;
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        Account account = Account.getInstance();
        params.add(new BasicNameValuePair("id", account.getUserId()));
        params.add(new BasicNameValuePair("tk", account.getToken()));
        params.add(new BasicNameValuePair("fileId", fileId));
        UrlEncodedFormEntity entity = new UrlEncodedFormEntity(params, Charset.forName("UTF-8"));
        try {
            JSONObject obj;
            HttpGet get = new HttpGet(String.valueOf(url) + "?" + EntityUtils.toString((HttpEntity)entity, (Charset)Charset.forName("UTF-8")));
            String result = (String)InternetHelper.httpClient.execute((HttpUriRequest)get, (ResponseHandler)new ResponseHandler<String>(){

                public String handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                    StatusLine statusLine = response.getStatusLine();
                    int code = statusLine.getStatusCode();
                    if (code == 200) {
                        return EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)Charset.defaultCharset());
                    }
                    return null;
                }
            });
            if (result != null && !(obj = new JSONObject(result)).isNull("content")) {
                return obj.getString("content");
            }
        }
        catch (IOException e) {
            return null;
        }
        return null;
    }

    static boolean deleteFileFromServer(String fileId) {
        String url = String.valueOf(InternetHelper.getHost()) + FILE_DELETE;
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        Account account = Account.getInstance();
        params.add(new BasicNameValuePair("id", account.getUserId()));
        params.add(new BasicNameValuePair("tk", account.getToken()));
        params.add(new BasicNameValuePair("fileId", fileId));
        UrlEncodedFormEntity entity = new UrlEncodedFormEntity(params, Charset.forName("UTF-8"));
        try {
            HttpGet get = new HttpGet(String.valueOf(url) + "?" + EntityUtils.toString((HttpEntity)entity, (Charset)Charset.forName("UTF-8")));
            String result = (String)InternetHelper.httpClient.execute((HttpUriRequest)get, (ResponseHandler)new ResponseHandler<String>(){

                public String handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                    StatusLine statusLine = response.getStatusLine();
                    int code = statusLine.getStatusCode();
                    if (code == 200) {
                        return EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)Charset.defaultCharset());
                    }
                    return null;
                }
            });
            if (result != null) {
                JSONObject obj = new JSONObject(result);
                return obj.getBoolean("success");
            }
        }
        catch (IOException e) {
            return false;
        }
        return false;
    }
}

